﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Class container for data received in a Deregistration Acknowledge message.
    /// </summary>
    public class P25DeregistrationAcknowledge
    {
        /// <summary>
        /// WACN ID of the message.
        /// </summary>
        public String WACNID { get; set; }

        /// <summary>
        /// System ID of the message.
        /// </summary>
        public int SystemID { get; set; }
        
        /// <summary>
        /// Radio ID of the message.
        /// </summary>
        public int RadioID { get; set; }
    }
}