﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Class container for data received in a Group Affiliation Response message.
    /// </summary>
    public class P25GroupAffiliationResponse
    {
        /// <summary>
        /// The announcement talkgroup ID for the affiliation
        /// </summary>
        public int AnnouncementTalkgroupID { get; set; }

        /// <summary>
        /// The talkgroup ID that the unit affiliated with.
        /// </summary>
        public int TalkgroupID { get; set; }

        /// <summary>
        /// Radio ID of the message.
        /// </summary>
        public int RadioID { get; set; }

        /// <summary>
        /// Type of affiliation.
        /// </summary>
        public P25GroupAffiliationType LocalOrGlobal { get; set; }

        /// <summary>
        /// Status of the affiliation.
        /// </summary>
        public P25GroupAffiliationValue GroupAffiliationValue { get; set; }
    }
}