﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public class P25GroupVoiceChannelGrantSingleBlock
    {
        /// <summary>
        /// Indicates if this is processed as an emergency service
        /// </summary>
        public bool IsEmergency { get; set; }

        /// <summary>
        /// Indicates if other resources (such as voice) other than the control channel are protected (encrypted)
        /// </summary>
        public bool IsProtected { get; set; }

        /// <summary>
        /// Indicates how the channel is to be used. Half duplex can transmit but can't receive at the same time. Full duplex allows both transmitting and receiving at the same time.
        /// </summary>
        public P25ServiceOptionsDuplex Duplex { get; set; }

        /// <summary>
        /// Defines packet or circuit mode.
        /// </summary>
        public P25ServiceOptionsMode Mode { get; set; }

        /// <summary>
        /// Indicates the importance of the channel.
        /// </summary>
        public P25ServiceOptionsPriorityLevel Priority { get; set; }

        /// <summary>
        /// Which identifier to use with the channel.
        /// </summary>
        public int Identifier { get; set; }

        /// <summary>
        /// Which channel to use.
        /// </summary>
        public int Channel { get; set; }

        /// <summary>
        /// Talkgroup ID of the channel grant.
        /// </summary>
        public int TalkgroupID { get; set; }

        /// <summary>
        /// Radio ID requesting channel grant.
        /// </summary>
        public int RadioID { get; set; }
    }
}