﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public class P25IdentifierUpdate
    {
        /// <summary>
        /// Identifier's ID that will be used in other messages.
        /// </summary>
        public int IdentifierID { get; set; }

        /// <summary>
        /// Base frequency used in frequency calculations.
        /// </summary>
        public double BaseFrequency { get; set; }

        /// <summary>
        /// Channel Spacing of frequencies
        /// </summary>
        public double ChannelSpacing { get; set; }

        /// <summary>
        /// Offset used in transmitting (calculating transmit frequency)
        /// </summary>
        public double TransmitOffset { get; set; }

        /// <summary>
        /// Bandwidth used.
        /// </summary>
        public double Bandwidth { get; set; }
    }
}
