﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public class P25UnitRegistrationResponse
    {
        /// <summary>
        /// Status of the registration.
        /// </summary>
        public P25UnitRegistrationValue RegistrationValue { get; set; }

        /// <summary>
        /// System ID of the registration.
        /// </summary>
        public int SystemID { get; set; }

        /// <summary>
        /// Radio ID registered on the system.
        /// </summary>
        public int RadioID { get; set; }

        /// <summary>
        /// Source Address (generally the Radio ID)
        /// </summary>
        public int SourceAddress { get; set; }
    }
}