﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Container for a P25 Frequency Identifier
    /// </summary>
    public class P25FrequencyIdentifier
    {
        /// <summary>
        /// Base Frequency.
        /// </summary>
        public double BaseFrequency { get; set; }

        /// <summary>
        /// Spacing between channels.
        /// </summary>
        public double ChannelSpacing { get; set; }

        /// <summary>
        /// Offset of transmit.
        /// </summary>
        public double TXOffset { get; set; }

        /// <summary>
        /// Creates a new P25FrequencyIdentifier used to hold a frequency identifier.
        /// </summary>
        /// <param name="BaseFrequency">Base Frequency</param>
        /// <param name="ChannelSpacing">Spacing between channels.</param>
        /// <param name="TXOffset">Offset of transmit.</param>
        public P25FrequencyIdentifier(double BaseFrequency, double ChannelSpacing, double TXOffset)
        {
            this.BaseFrequency = BaseFrequency;
            this.ChannelSpacing = ChannelSpacing;
            this.TXOffset = TXOffset;
        }

        /// <summary>
        /// Creates a new blank P25FrequencyIdentifier used to hold a frequency identifier.
        /// </summary>
        public P25FrequencyIdentifier() { }
    }

    /// <summary>
    /// Container for a collection of P25 Frequency Identifiers
    /// </summary>
    public class P25FrequencyIdentifiers : Dictionary<int, P25FrequencyIdentifier> { }
}