﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Container for data returned from processing a P25 message.
    /// </summary>
    public class P25Return
    {
        // Global Message Data

        /// <summary>
        /// Timestamp of the message
        /// </summary>
        public DateTime TimeStamp { get; set; }

        /// <summary>
        /// The type of P25 Message
        /// </summary>
        public P25ReturnType MessageType { get; set; }

        /// <summary>
        /// Whether the message is protected (encrypted)
        /// </summary>
        public bool ProtectedTrunking { get; set; }

        /// <summary>
        /// The Opcode used to identify the message type
        /// </summary>
        public String opCode { get; set; }

        /// <summary>
        /// The message's manufacturer ID
        /// </summary>
        public int ManufacturerID { get; set; }

        /// <summary>
        /// Indicates whether or not data is held in one or multiple packets. Currently, only single block packets are being decoded. This option is currently reserved.
        /// </summary>
        public bool IsSingleBlock = true;

        /// <summary>
        /// Original P25 Message
        /// </summary>
        public P25Message OriginalMessage { get; set; }

        // Data Storage

        public P25GroupVoiceChannelGrantSingleBlock dataGroupVoiceChannelGrant { get; set; }
        public P25GroupVoiceChannelGrantUpdate dataGroupVoiceChannelGrantUpdate { get; set; }
        public P25IdentifierUpdate dataIdentifierUpdate { get; set; }
        public P25MotorolaPatch dataMotorolaPatch { get; set; }
        public P25GroupAffiliationResponse dataGroupAffiliationResponse { get; set; }
        public P25UnitRegistrationResponse dataUnitRegistrationResponse { get; set; }
        public P25DeregistrationAcknowledge dataDeregistrationAcknowledge { get; set; }

        /// <summary>
        /// Creates a new blank P25 return.
        /// </summary>
        public P25Return() { }

        /// <summary>
        /// Creates a new P25 return.
        /// </summary>
        /// <param name="MessageType">Type of P25 message.</param>
        public P25Return(P25ReturnType MessageType)
        {
            this.MessageType = MessageType;
        }
    }
}
