﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Type of P25 Message.
    /// </summary>
    public enum P25ReturnType
    {
        /// <summary>
        /// Unknown P25 message.
        /// </summary>
        Unknown,
        /// <summary>
        /// Not enough information was available to process the P25 message. Normally this means an Identifier Update hasn't been passed or the class was recreated and the data is no longer available.
        /// </summary>
        NotEnoughInformation,
        /// <summary>
        /// Group Voice Channel Grant
        /// </summary>
        GroupVoiceChannelGrant,
        /// <summary>
        /// Group Voice Channel Grant Update
        /// </summary>
        GroupVoiceChannelGrantUpdate,
        /// <summary>
        /// Group Affiliation Response
        /// </summary>
        GroupAffiliationResponse,
        /// <summary>
        /// Unit Registration Response
        /// </summary>
        UnitRegistrationResponse,
        /// <summary>
        /// De-Registration Acknowledge
        /// </summary>
        DeregistrationAcknowledge,
        /// <summary>
        /// Identifier Update
        /// </summary>
        IdentifierUpdate,
        /// <summary>
        /// Motorola Patch
        /// </summary>
        MotorolaPatch
    }
}
