﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace CCDecodeP25
{
    public class P25DuplicateDetected : Exception
    {
        public P25DuplicateDetected()
            : base("This message is a duplicate of the last message of the same type.")
        {

        }

        public P25DuplicateDetected(string message)
            : base(message)
        {

        }

        public P25DuplicateDetected(string message, Exception innerException)
            : base(message, innerException)
        {

        }

        protected P25DuplicateDetected(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {

        }
    }
}