﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace CCDecodeP25
{
    public class P25NoChannelIdentifiers : Exception
    {
        public P25NoChannelIdentifiers()
            : base("Unable to provide information for the message because there are no channel identifiers.")
        {

        }

        public P25NoChannelIdentifiers(string message)
            : base(message)
        {

        }

        public P25NoChannelIdentifiers(string message, Exception innerException)
            : base(message, innerException)
        {

        }

        protected P25NoChannelIdentifiers(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {

        }
    }
}