﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace CCDecodeP25
{
    public class P25ProtectedMessage : Exception
    {
        public P25ProtectedMessage()
            : base("The message is protected and no information can be obtained from it!")
        {

        }

        public P25ProtectedMessage(string message)
            : base(message)
        {

        }

        public P25ProtectedMessage(string message, Exception innerException)
            : base(message, innerException)
        {

        }

        protected P25ProtectedMessage(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {

        }
    }
}