﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a De-Registration Acknowledge message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>De-Registration Acknowledge Data</returns>
        private P25DeregistrationAcknowledge HandleDeregistrationAcknowledge(P25Message message)
        {
            P25DeregistrationAcknowledge results = new P25DeregistrationAcknowledge();

            results.WACNID = message.oct3 + message.oct4 + message.oct5.Substring(0, 1); 
            results.SystemID = Convert.ToInt32(message.oct5.Substring(1, 1) + message.oct6);
            results.RadioID = Convert.ToInt32(message.oct7 + message.oct8 + message.oct9, 16);

            return results;
        }
    }
}