﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a Group Affiliation Response message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Group Affiliation Response Data</returns>
        private P25GroupAffiliationResponse HandleGroupAffiliationResponse(P25Message message)
        {
            P25GroupAffiliationResponse results = new P25GroupAffiliationResponse();

            results.LocalOrGlobal = (message.octBIN2.Substring(0, 1).Equals("0") ? P25GroupAffiliationType.Local : P25GroupAffiliationType.Global);

            switch (message.octBIN2.Substring(6, 2))
            {
                case "00":
                    results.GroupAffiliationValue = P25GroupAffiliationValue.Accept;
                    break;
                case "01":
                    results.GroupAffiliationValue = P25GroupAffiliationValue.Fail;
                    break;
                case "10":
                    results.GroupAffiliationValue = P25GroupAffiliationValue.Deny;
                    break;
                case "11":
                    results.GroupAffiliationValue = P25GroupAffiliationValue.Refused;
                    break;
                default:
                    break;
            }

            results.AnnouncementTalkgroupID = Convert.ToInt32(message.oct3 + message.oct4, 16);
            results.TalkgroupID = Convert.ToInt32(message.oct5 + message.oct6, 16);
            results.RadioID = Convert.ToInt32(message.oct7 + message.oct8 + message.oct9, 16);

            return results;
        }
    }
}