﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a Group Voice Channel Grant (single block) message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Group Voice Channel Grant (single block) Data</returns>
        private P25GroupVoiceChannelGrantSingleBlock HandleGroupVoiceChannelGrantSingleBlock(P25Message message)
        {
            P25GroupVoiceChannelGrantSingleBlock results = new P25GroupVoiceChannelGrantSingleBlock();

            // Service Options: Emergency
            results.IsEmergency = (message.octBIN2.Substring(0, 1).Equals("1"));

            // Service Options: Protected (Encrypted)
            results.IsProtected = (message.octBIN2.Substring(1, 1).Equals("1"));

            // Service Options: Duplex
            results.Duplex = (message.octBIN2.Substring(2, 1).Equals("1") ? P25ServiceOptionsDuplex.Full : P25ServiceOptionsDuplex.Half);

            // Service Options: Mode
            results.Mode = (message.octBIN2.Substring(3, 1).Equals("1") ? P25ServiceOptionsMode.Packet : P25ServiceOptionsMode.Circuit);

            // Service Options: Priority Level
            switch (message.octBIN2.Substring(5, 3))
            {
                case "000":
                    results.Priority = P25ServiceOptionsPriorityLevel.Reserved000;
                    break;
                case "001":
                    results.Priority = P25ServiceOptionsPriorityLevel.Lowest;
                    break;
                case "010":
                    results.Priority = P25ServiceOptionsPriorityLevel.SysDefinable010;
                    break;
                case "011":
                    results.Priority = P25ServiceOptionsPriorityLevel.SysDefinable011;
                    break;
                case "100":
                    results.Priority = P25ServiceOptionsPriorityLevel.Default;
                    break;
                case "101":
                    results.Priority = P25ServiceOptionsPriorityLevel.SysDefinable101;
                    break;
                case "110":
                    results.Priority = P25ServiceOptionsPriorityLevel.SysDefinable110;
                    break;
                case "111":
                    results.Priority = P25ServiceOptionsPriorityLevel.Highest;
                    break;
                default:
                    break;
            }

            results.Identifier = Convert.ToInt32(message.octBIN6.Substring(0, 4), 16);
            results.Channel = Convert.ToInt32(message.oct3 + message.oct4, 16);
            results.TalkgroupID = Convert.ToInt32(message.oct5 + message.oct6, 16);
            results.RadioID = Convert.ToInt32(message.oct7 + message.oct8 + message.oct9, 16);

            return results;
        }
    }
}