﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a Group Voice Channel Grant Update message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Group Voice Channel Grant Update Data</returns>
        private P25GroupVoiceChannelGrantUpdate HandleGroupVoiceChannelGrantUpdate(P25Message message)
        {
            P25GroupVoiceChannelGrantUpdate results = new P25GroupVoiceChannelGrantUpdate();

            results.Identifier1 = Convert.ToInt32(message.octBIN2.Substring(0, 4), 16);
            results.Channel1 = Convert.ToInt32(message.oct2 + message.oct3, 16);
            results.TalkgroupID1 = Convert.ToInt32(message.oct4 + message.oct5, 16);
            results.Identifier2 = Convert.ToInt32(message.octBIN6.Substring(0, 4), 16);
            results.Channel2 = Convert.ToInt32(message.oct6 + message.oct7, 16);
            results.TalkgroupID2 = Convert.ToInt32(message.oct8 + message.oct9, 16);

            return results;
        }
    }
}