﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes an Identifier Update message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Identifier Update Data</returns>
        private P25IdentifierUpdate HandleIdentifierUpdate(P25Message message)
        {
            P25IdentifierUpdate results = new P25IdentifierUpdate();

            results.IdentifierID = Convert.ToInt32(message.octBIN2.Substring(0, 4), 2);
            results.BaseFrequency = (Convert.ToDouble(Convert.ToInt32(Convert.ToString(Convert.ToInt32(message.oct6 + message.oct7 + message.oct8 + message.oct9, 16), 2).PadLeft(8, '0'), 2)) * 0.000005);
            results.ChannelSpacing = (Convert.ToDouble(Convert.ToInt32(message.octBIN4.Substring(6, 2) + Convert.ToString(Convert.ToInt32(message.oct5, 16), 2).PadLeft(8, '0'), 2)) * 0.125 / 1000);

            // Transmit Offset
            if (!((Convert.ToInt32(message.oct6, 16) >= 1 && Convert.ToInt32(message.oct6, 16) <= 2) || (Convert.ToInt32(message.oct6, 16) >= 4 && Convert.ToInt32(message.oct6, 16) <= 6)))
            {
                double txOffSet = 0;
                txOffSet = Convert.ToDouble((Convert.ToInt32(message.octBIN3.Substring(6, 2) + message.octBIN4.Substring(0, 6), 2))) * 0.250;
                if (message.octBIN3.Substring(5, 1) == "0")
                {
                    txOffSet *= -1;
                }

                results.TransmitOffset = txOffSet;
            }
            else
            {
                double txOffSet = 0;
                txOffSet = Convert.ToDouble((Convert.ToInt32(message.octBIN3.Substring(1, 7) + message.octBIN4.Substring(0, 6), 2))) * 0.250;
                if (message.octBIN3.Substring(1, 1) == "0")
                {
                    txOffSet *= -1;
                }

                results.TransmitOffset = txOffSet;
            }

            // Bandwidth
            switch (message.octBIN2.Substring(4, 4))
            {
                case "0100":
                    results.Bandwidth = (6.25D / 1000D);
                    break;
                case "0101":
                    results.Bandwidth = (12.5D / 1000D);
                    break;
                default:
                    results.Bandwidth = 0D;
                    break;
            }

            return results;
        }
    }
}