﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a Motorola Patch message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Motorola Patch Data</returns>
        private P25MotorolaPatch HandleMotorolaPatch(P25Message message)
        {
            P25MotorolaPatch results = new P25MotorolaPatch();

            // Supergroup ID (Source Talkgroup ID)
            results.SupergroupID = Convert.ToInt32(message.oct2 + message.oct3, 16);

            results.TalkgroupID1 = Convert.ToInt32(message.oct4 + message.oct5, 16);
            results.TalkgroupID2 = Convert.ToInt32(message.oct6 + message.oct7, 16);
            results.TalkgroupID3 = Convert.ToInt32(message.oct8 + message.oct9, 16);

            return results;
        }
    }
}