﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    public partial class P25Decode
    {
        /// <summary>
        /// Decodes a Unit Registration Response message.
        /// </summary>
        /// <param name="message">P25 Message</param>
        /// <returns>Unit Registration Response Data</returns>
        private P25UnitRegistrationResponse HandleUnitRegistrationResponse(P25Message message)
        {
            P25UnitRegistrationResponse results = new P25UnitRegistrationResponse();

            switch (message.octBIN2.Substring(2, 2))
            {
                case "00":
                    results.RegistrationValue = P25UnitRegistrationValue.Accept;
                    break;
                case "01":
                    results.RegistrationValue = P25UnitRegistrationValue.Fail;
                    break;
                case "10":
                    results.RegistrationValue = P25UnitRegistrationValue.Deny;
                    break;
                case "11":
                    results.RegistrationValue = P25UnitRegistrationValue.Refused;
                    break;
                default:
                    break;
            }

            results.SystemID = Convert.ToInt32(message.oct2.Substring(1, 1) + message.oct3);
            results.RadioID = Convert.ToInt32(message.oct4 + message.oct5 + message.oct6, 16);
            results.SourceAddress = Convert.ToInt32(message.oct7 + message.oct8 + message.oct9, 16);

            return results;
        }
    }
}