#!/bin/bash

log_path="./CVE-2021-44228_mitigation_result.log"
if [ -f $log_path ];then
    rm  $log_path
fi

echo "----- CVE-2021-44228 mitigation result -----" | tee -a $log_path
ver_8="version \"1.8."
ver_11="version \"11."
ver_12="version \"12."
ver_13="version \"13."
ver_14="version \"14."
ver_15="version \"15."
if [ -f $HOME/HR_log4j_fixer ];then
    rm  $HOME/HR_log4j_fixer
fi

j_ver=$(java -version 2>&1)
#echo $j_ver

if [[ $j_ver =~ $ver_8 ]];then
    $(sudo javac -XDignore.symbol.file=true -cp $JAVA_HOME/lib/tools.jar Log4jHotPatch.java)
    $(sudo jar -cfm Log4jHotPatch.jar Manifest.mf *.class)
    result=$(java -cp $JAVA_HOME/lib/tools.jar:./Log4jHotPatch.jar Log4jHotPatch 2>&1)
elif [[ $j_ver =~ $ver_11 
    || $j_ver =~ $ver_12 
    || $j_ver =~ $ver_13 
    || $j_ver =~ $ver_14 
    || $j_ver =~ $ver_15 ]];then
    #echo $j_ver
    $(sudo javac --add-exports java.base/jdk.internal.org.objectweb.asm=ALL-UNNAMED --add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED Log4jHotPatch.java)
    $(sudo jar -cfm Log4jHotPatch.jar Manifest.mf *.class)
    result=$(java Log4jHotPatch 2>&1)
else
    echo "no support jdk version" |tee -a $log_path
fi


#echo $result
if [[ -f $HOME/HR_log4j_fixer ]];then
    if [[ $result =~ "Successfully loaded" ]];then
        echo "CVE-2021-44228 was detected and all mitigations were successful !  list info table:" |tee -a $log_path
        echo "java_pid  log4j_version" |tee -a $log_path
        cat $HOME/HR_log4j_fixer |tee -a $log_path
        exit
    fi
fi

echo "not detected CVE-2021-44228!" |tee -a $log_path
