/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = new Locale("en", "", "");
    public static final Locale FRENCH = new Locale("fr", "", "");
    public static final Locale GERMAN = new Locale("de", "", "");
    public static final Locale ITALIAN = new Locale("it", "", "");
    public static final Locale JAPANESE = new Locale("ja", "", "");
    public static final Locale KOREAN = new Locale("ko", "", "");
    public static final Locale CHINESE = new Locale("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW", "");
    public static final Locale FRANCE = new Locale("fr", "FR", "");
    public static final Locale GERMANY = new Locale("de", "DE", "");
    public static final Locale ITALY = new Locale("it", "IT", "");
    public static final Locale JAPAN = new Locale("ja", "JP", "");
    public static final Locale KOREA = new Locale("ko", "KR", "");
    public static final Locale CHINA = new Locale("zh", "CN", "");
    public static final Locale PRC = new Locale("zh", "CN", "");
    public static final Locale TAIWAN = new Locale("zh", "TW", "");
    public static final Locale UK = new Locale("en", "GB", "");
    public static final Locale US = new Locale("en", "US", "");
    public static final Locale CANADA = new Locale("en", "CA", "");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA", "");
    static final long serialVersionUID = 9149081749638150636L;
    private String language = "";
    private String country = "";
    private String variant = "";
    private int hashcode = -1;
    private static Locale defaultLocale = new Locale(System.getProperty("user.language", "EN"), System.getProperty("user.region", ""));

    public Locale(String string, String string2, String string3) {
        this.language = this.toLowerCase(string);
        this.country = this.toUpperCase(string2);
        this.variant = this.toUpperCase(string3);
    }

    public Locale(String string, String string2) {
        this.language = this.toLowerCase(string);
        this.country = this.toUpperCase(string2);
        this.variant = "";
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale locale) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.language");
        }
        defaultLocale = locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.language);
        if (this.country.length() != 0) {
            stringBuffer.append('_');
            stringBuffer.append(this.country);
            if (this.variant.length() != 0) {
                stringBuffer.append('_');
                stringBuffer.append(this.variant);
            }
        }
        return stringBuffer.toString();
    }

    public String getISO3Language() throws MissingResourceException {
        if (this.language.length() == 0) {
            return "";
        }
        this.getISO2Language();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return resourceBundle.getString("ShortLanguage");
    }

    public String getISO3Country() throws MissingResourceException {
        if (this.country.length() == 0) {
            return "";
        }
        this.getISO2Country();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return resourceBundle.getString("ShortCountry");
    }

    String getISO2Language() throws MissingResourceException {
        if (this.language.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        String string = resourceBundle.getString("LocaleString");
        String string2 = string.substring(0, 2);
        if (!string2.equals(this.language)) {
            throw new MissingResourceException("Requested resource bundle not installed", "LocaleElements", "LocaleString");
        }
        return string2;
    }

    String getISO2Country() throws MissingResourceException {
        if (this.country.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        String string = resourceBundle.getString("LocaleString");
        String string2 = string.substring(3, 5);
        if (!string2.equals(this.country)) {
            throw new MissingResourceException("Requested resource bundle not installed", "LocaleElements", "LocaleString");
        }
        return string2;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        String string = this.language;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Languages"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        String string = this.country;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Countries"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        String string = this.variant;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (locale2.variant.length() == 0) {
            n = 1;
        }
        if (locale2.country.length() == 0) {
            n = 2;
        }
        while (!bl) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Variants"), string, string);
                if (string2.length() != 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) continue;
            switch (n) {
                case 0: {
                    locale2.variant = "";
                    break;
                }
                case 1: {
                    locale2.country = "";
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n;
        }
        return string2;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayCountry(locale);
        String string3 = this.getDisplayVariant(locale);
        if (string.length() != 0) {
            stringBuffer.append(string);
            if (string2.length() != 0 || string3.length() != 0) {
                stringBuffer.append(" (");
                if (string2.length() != 0) {
                    stringBuffer.append(string2);
                    if (string3.length() != 0) {
                        stringBuffer.append(",");
                    }
                }
                if (string3.length() != 0) {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(")");
            }
        } else if (string2.length() != 0) {
            stringBuffer.append(string2);
            if (string3.length() != 0) {
                stringBuffer.append(" (");
                stringBuffer.append(string3);
                stringBuffer.append(")");
            }
        } else if (string3.length() != 0) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        if (this.hashCode() != locale.hashCode()) {
            return false;
        }
        if (!this.language.equals(locale.language)) {
            return false;
        }
        if (!this.country.equals(locale.country)) {
            return false;
        }
        return this.variant.equals(locale.variant);
    }

    private String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String findStringMatch(String[][] stringArray, String string, String string2) {
        int n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2][0])) {
                return stringArray[n2][1];
            }
            ++n2;
        }
        if (!string2.equals(string)) {
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        if (!"EN".equals(string) && "EN".equals(string2)) {
            n = 0;
            while (n < stringArray.length) {
                if ("EN".equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        return "";
    }
}

