/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import sun.security.util.BigInt;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerOutputStream
extends ByteArrayOutputStream {
    public DerOutputStream(int n) {
        super(n);
    }

    public DerOutputStream() {
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.emit(this);
    }

    public void putInteger(BigInt bigInt) throws IOException {
        byte[] byArray = bigInt.toByteArray();
        this.write(2);
        if ((byArray[0] & 0x80) != 0) {
            this.putLength(byArray.length + 1);
            this.write(0);
        } else {
            this.putLength(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.emit(this);
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n = 0;
        while (n < derValueArray.length) {
            derValueArray[n].emit(derOutputStream);
            ++n;
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n = 0;
        while (n < derValueArray.length) {
            derValueArray[n].emit(derOutputStream);
            ++n;
        }
        this.write((byte)49, derOutputStream);
    }

    public void putPrintableString(String string) throws IOException {
        this.write(19);
        this.putLength(string.length());
        int n = 0;
        while (n < string.length()) {
            this.write((byte)string.charAt(n));
            ++n;
        }
    }

    public void putIA5String(String string) throws IOException {
        this.write(22);
        this.putLength(string.length());
        int n = 0;
        while (n < string.length()) {
            this.write((byte)string.charAt(n));
            ++n;
        }
    }

    public void putUTCTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(23);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    void putLength(int n) throws IOException {
        if (n < 128) {
            this.write((byte)n);
            return;
        }
        if (n < 256) {
            this.write(-127);
            this.write((byte)n);
            return;
        }
        if (n < 65536) {
            this.write(-126);
            this.write((byte)(n >> 8));
            this.write((byte)n);
            return;
        }
        if (n < 0x1000000) {
            this.write(-125);
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
            return;
        }
        this.write(-124);
        this.write((byte)(n >> 24));
        this.write((byte)(n >> 16));
        this.write((byte)(n >> 8));
        this.write((byte)n);
    }
}

