''''''''''''''''''''''''''''''''''''
' (C) Copyright 1998 Cisco Systems, Inc.
' All Rights Reserved
'
' w3cfg.vbs
'
' Revision History:
'     Date                           Comment
'    7/24/97  Adam Stone             Initial version started
'    4/27/98  m.t.thompson@ieee.org  Massive carving to make CW2000 Essentials installer.
'             Incarnated from NT 4.0 Option Pack sample IIS admin scripts:
'               winnt\system32\inetsrv\adminsamples\adsutil.vbs
'               winnt\system32\inetsrv\adminsamples\mkw3site.vbs
'               winnt\system32\inetsrv\adminsamples\delwebsv.vbs
'               winnt\system32\inetsrv\adminsamples\mkwebdir.vbs
'
'  Known Bugs:
'    Errors during script execution may leave services in a start
'      or stop state other than the start/stop state intended.
'
''''''''''''''''''''''''''''''''''''
' Contains numerous hardcoded assumptions about structure of CW2000 Essentials tree,
'   required IIS options, etc...

Option Explicit
On Error Resume Next

'Verbose flag for code that uses it.
Dim verbose
verbose = False


''''''''''''''''''
' Main Script Code
''''''''''''''''''
Dim ArgObj ' Object which contains the command line argument
Dim Result ' Result of the command function call

' Used for string formatting
Dim Spacer
Dim SpacerSize

Const IIS_DATA_NO_INHERIT = 0
Const IIS_DATA_INHERIT = 1
Const GENERAL_FAILURE = 2
Const GENERAL_WARNING = 1
Const TemporaryFolder = 2
Const INPROC  = True
Const OUTPROC = False

Spacer = "                                " ' Used to format the strings
SpacerSize = Len (Spacer)

Result = 0 ' Initialize to success in case it's not set later.

' Note: The default execution mode may be under WScript.exe.
' That would be very annoying since WScript has popups for Echo.
' So, I want to detect that, and warn the user that it may cause
' problems.
DetectExeType

' Get the Arguments object
Set ArgObj = WScript.Arguments

' Test to make sure there is at least one command line arg - the command
If ArgObj.Count < 1 Then
	DisplayHelpMessage
	WScript.Quit (GENERAL_FAILURE)
End If

Message "Info", False, "Executing command " & UCase(ArgObj.Item(0)) & " at " & Now

' Call the function associated with the given command
Select Case UCase(ArgObj.Item(0))
    Case "SET"
		Result = SetCommand ()
    Case "CREATE"
		Result = CreateCommand ("")
    Case "DELETE"
		Result = DeleteCommand ()
    Case "GET"
		Result = GetCommand ()
    Case "ENUM"
		Result = EnumCommand ()
    Case "ENUM_ALL"
		Result = EnumAllCommand ()
    Case "ENUMALL"
		Result = EnumAllCommand ()
    Case "COPY"
		Result = CopyMoveCommand (True)  ' The TRUE means COPY, not MOVE
    Case "MOVE"
		Result = CopyMoveCommand (False)  ' The FALSE means MOVE, not COPY
    Case "CREATE_VDIR"
		Result = CreateCommand ("IIsWebVirtualDir")
    Case "CREATE_VSERV"
		Result = CreateCommand ("IIsWebServer")
    Case "START_SERVER"
		Result = StartServerCommand()
    Case "STOP_SERVER"
		Result = StopServerCommand()
    Case "STOP_WSERVER_ALL"
		Result = StopWServerAllCommand()
    Case "PAUSE_SERVER"
		Result = PauseServerCommand()
    Case "CONTINUE_SERVER"
		Result = ContinueServerCommand()
' New Stuff being added
	Case "FIND"
		Result = FindData ()
	Case "COPY"
		WScript.Echo "COPY is not yet supported.  It will be soon."
	Case "APPCREATEINPROC"
		Result = AppCreateCommand (True)
	Case "APPCREATEOUTPROC"
		Result = AppCreateCommand (False)
	Case "APPDELETE"
		Result = AppDeleteCommand ()
	Case "APPUNLOAD"
		Result = AppUnloadCommand ()
	Case "APPGETSTATUS"
		Result = AppGetStatusCommand ()
	Case "HELP"
		DisplayHelpMessageEx
	Case "ESSENTIALSINFOSHORT"
		Result = EssentialsInfoShort()
	Case "ESSENTIALSCLEANPREV"
		Result = EssentialsCleanPrev()
	Case "ESSENTIALSINFO"
		Result = EssentialsInfo()
	Case "ESSENTIALSINSTALL"
		Result = EssentialsInstall()
	Case "ESSENTIALSUNINSTALL"
		Result = EssentialsUnInstall()
	
' End New Stuff

    Case Else
		WScript.Echo "Command not recognized: " & ArgObj.Item(0)
		WScript.Echo "For help, just type ""Cscript.exe w3cfg.vbs""."
		Result = GENERAL_FAILURE

End Select


WScript.Quit (Result)

''''''''''
' End Main
''''''''''

'indev foo
''''''''''''''''''''''''''
' EssentialsCleanPrev  Clean, potentially harmful pre-IIS4.0 configuration from
'   the webserver that may be left over from the previous release of ESSENTIALS
'   ie. CRM website.
''''''''''''''''''''''''''
Function EssentialsCleanPrev()
	Dim RootDirectory
	Dim WebHost
	Dim WebSiteADSILocalPath, WebSiteADSIPath

	On Error Resume Next
	EssentialsCleanPrev = 0 ' Assume Success
	WebHost = "LocalHost"

'Parse our arguments.
    	'WScript.Echo "  w3cfg.vbs ESSENTIALSCLEANPREV ""C:\Program Files\CSCOpx"""

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the ESSENTIALSCLEANPREV command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	RootDirectory = ArgObj.Item(1)


'  Generate useful ADSI paths.
'  Hardcoded to root web service object that needs cleaning from erroneous import
'    of old CRM website configuration.
	WebSiteADSILocalPath = "W3SVC/"
        WebSiteADSIPath = "IIS://" & WebHost & "/" & WebSiteADSILocalPath

'  Remove CRM FileAuth.dll filter.
'filter load order w3svc/Filters/FilterLoadOrder : (STRING) "sspifilt,pwsdata,fpexedll,fpexedll.dll,FileAuth.dll"
'filter dir /w3svc/Filters/FileAuth.dll
'filter path 

'indev

'  Remove CRM perl mappings.



'  Enumerate metabase nodes for localhost, w3svc, CW2000 website, and CW2000 virtual dirs, etc.

	Message "Info", False, "Configuration for website: " & WebSiteADSIPath
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/"
	EnumCommandParam "", ""

End Function 'EssentialsCleanPrev()

'indev bar

''''''''''''''''''''''''''
' EssentialsInfoShort Display bindings and site ADSI path.
''''''''''''''''''''''''''
Function EssentialsInfoShort()
	Dim ServerComment
	Dim WebHost, WebSite
	Dim WebSiteADSILocalPath, WebSiteADSIPath
	Dim ServerBindings

	On Error Resume Next
	EssentialsInfoShort = 0 ' Assume Success
	WebHost = "LocalHost"

'Parse our arguments.
   	 'WScript.Echo "  w3cfg.vbs ESSENTIALSINFOSHORT ""CW2000"""

	If ArgObj.Count <> 2 Then
		Message "Error", False, "Wrong number of Args for the ESSENTIALSINFOSHORT command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ServerComment = ArgObj.Item(1)

'  Find the created web site and it's automatically assigned numerical "Name".
	set WebSite = findWebFromServerComment(WebHost, ServerComment)
        Err.Clear
	if Not isObject(WebSite) then
		Message "Warning", False, "Can't find " & ServerComment & " webserver in IIS 4.0 metabase. Possibly uninstalled already."
		WScript.Quit (1)
	end if

'  Generate useful ADSI paths.
	WebSiteADSILocalPath = "W3SVC/" & WebSite.Name
        WebSiteADSIPath = "IIS://" & WebHost & "/" & WebSiteADSILocalPath

'  Display website path, bindings.

	Message "Info", False, "Configuration for website: " & WebSiteADSIPath
	Message "Info", False, "ADSI Path: " & WebSiteADSIPath
	GetCommandParam WebSiteADSILocalPath & "/ServerBindings", ServerBindings

End Function ' EssentialsInfoShort

''''''''''''''''''''''''''
' EssentialsInfo dump of the CW2000 Essentials website.
' Displays more information about the essentials website than
' you EVER wanted to know!
''''''''''''''''''''''''''
Function EssentialsInfo()
	Dim ServerComment
	Dim WebHost, WebSite
	Dim WebSiteADSILocalPath, WebSiteADSIPath

	On Error Resume Next
	EssentialsInfo = 0 ' Assume Success
	WebHost = "LocalHost"

'Parse our arguments.
   	 'WScript.Echo "  w3cfg.vbs ESSENTIALSINFO ""CW2000"""

	If ArgObj.Count <> 2 Then
		Message "Error", False, "Wrong number of Args for the ESSENTIALSINFO command."
		WScript.Quit (GENERAL_FAILURE)
	End If

	ServerComment = ArgObj.Item(1)

'  Find the created web site and it's automatically assigned numerical "Name".
	set WebSite = findWebFromServerComment(WebHost, ServerComment)
        Err.Clear
	if Not isObject(WebSite) then
		Message "Error", False, "Can't find " & ServerComment & " webserver in IIS 4.0 metabase. Possibly uninstalled already."
		WScript.Quit (1)
	end if

'  Generate useful ADSI paths.
	WebSiteADSILocalPath = "W3SVC/" & WebSite.Name
        WebSiteADSIPath = "IIS://" & WebHost & "/" & WebSiteADSILocalPath

'  Enumerate metabase nodes for localhost, w3svc, CW2000 website, and CW2000 virtual dirs, etc.

	Message "Info", False, "Configuration for website: " & WebSiteADSIPath
	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/"
	EnumCommandParam "", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC"
	EnumCommandParam "W3SVC", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Filters"
	EnumCommandParam "W3SVC/Filters", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Filters/sspifilt"
	EnumCommandParam "W3SVC/Filters/sspifilt", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Filters/pwsdata"
	EnumCommandParam "W3SVC/Filters/pwsdata", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Filters/fpexedll"
	EnumCommandParam "W3SVC/Filters/fpexedll", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Filters/fpexedll.dll"
	EnumCommandParam "W3SVC/Filters/fpexedll.dll", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/W3SVC/Info"
	EnumCommandParam "W3SVC/Info", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath
	EnumCommandParam WebSiteADSILocalPath, ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/Filters"
	EnumCommandParam WebSiteADSILocalPath & "/Filters", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/Filters/CW2000jrun"
	EnumCommandParam WebSiteADSILocalPath & "/Filters/CW2000jrun", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/ROOT"
	EnumCommandParam WebSiteADSILocalPath & "/ROOT", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/ROOT/cgi-bin"
	EnumCommandParam WebSiteADSILocalPath & "/ROOT/cgi-bin", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/ROOT/CSCOnm"
	EnumCommandParam WebSiteADSILocalPath & "/ROOT/CSCOnm", ""

	WScript.Echo
	Message "Info", False, "Metabase node: " & "IIS://" & WebHost & "/" & WebSiteADSILocalPath & "/ROOT/Scripts"
	EnumCommandParam WebSiteADSILocalPath & "/ROOT/Scripts", ""

End Function ' EssentialsInfo


''''''''''''''''''''''''''
' EssentialsInstall the CW2000 Essentials website.
''''''''''''''''''''''''''
Function EssentialsInstall()
	Dim WebHost, WebSite
	Dim WebSiteADSILocalPath, WebSiteADSIPath
	Dim RootDirectory, ServerComment, Port
	Dim Computers
	Dim WshShell
	Dim Return
	Dim WinProductType
	Dim IISADMINRunningOnEntry, W3SVCRunningOnEntry

	On Error Resume Next
	EssentialsInstall = 0 ' Assume Success
	WebHost = "LocalHost"

'Parse our arguments.

'  w3cfg.vbs ESSENTIALSINSTALL   ""CW2000"" 1741 ""C:\Program Files\CSCOpx"""

	If ArgObj.Count < 4 Then
		WScript.Echo "Error: Wrong number of Args for the ESSENTIALSINSTALL command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ServerComment = ArgObj.Item(1)
	Port          = ArgObj.Item(2)
	RootDirectory = ArgObj.Item(3)

'indev Add IISADMIN/W3SVC service state check, start it, and then leave it in the state we found it.
'  Create a Wscript.Shell Object for later use.
	Set WshShell = Wscript.CreateObject("Wscript.Shell")

'  Record state of and start IISADMIN and W3SVC services if needed.
'    Note W3SVC is required for IIsWebServer.Start method.
'	Return = ServiceState(IISADMINRunningOnEntry, W3SVCRunningOnEntry)

'	If (Not IISADMINRunningOnEntry) Then
		' 7 = SW_SHOWMINNOACTIVE
		Return = WshShell.Run ("%SystemRoot%\system32\net.exe start IISADMIN ", 7, True)
'	Else
'		Message "Info", False, "Found IISADMIN service already started."
'	End If
'	If (Not W3SVCRunningOnEntry) Then
		' 7 = SW_SHOWMINNOACTIVE
		Return = WshShell.Run ("%SystemRoot%\system32\net.exe start W3SVC    ", 7, True)
'	Else
'		Message "Info", False, "Found W3SVC service already started."
'	End If

'Now lets do some configuration!
'  Create web site, root virtual directory
'  	cscript mkw3site.vbs //NoLogo -r "C:\Program Files\CSCOpx\htdocs" -t "CW2000" -o 1741 --DontStart
	Computers    = Array(1)
	Computers(0) = WebHost
	'ASTCreateWebSite(IPAddress, RootDirectory,            ServerComment, HostName, Port, Computers, Start)
	ASTCreateWebSite "",        RootDirectory & "\htdocs", ServerComment, "",  Port, Computers, False

'  Find the created web site and it's automatically assigned numerical "Name"
'  	cscript findweb.vbs //NoLogo -s "CW2000"
	set WebSite = findWebFromServerComment(WebHost, ServerComment)
        Err.Clear
	if Not isObject(WebSite) then
		Message "Error", False, "Can't find " & ServerComment & " webserver in IIS 4.0 metabase. Website creation failed."
		WScript.Quit (1)
	end if

'  Generate useful ADSI paths.
'	ie. W3SVC/3
	WebSiteADSILocalPath = "W3SVC/" & WebSite.Name
'       ie. IIS://LocalHost/W3SVC/3
        WebSiteADSIPath = "IIS://" & WebHost & "/" & WebSiteADSILocalPath
'debug
'Wscript.echo "ServerComment: " & ServerComment & "    " & "WebHost: " & WebHost
'Wscript.echo "WebSiteADSILocalPath: " & WebSiteADSILocalPath & "    " & "WebSiteADSIPath: " & WebSiteADSIPath

'  Echo ADSI path for future archaeologist.
	Message "Info", False, "ADSI Path: " & WebSiteADSIPath

'  Add write permission to CW2000 Home Directory
	' cscript w3cfg.vbs //NoLogo SET W3SVC/3/ROOT/AccessWrite True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AccessWrite", "True"

' Set default document.
'	cscript adsutil.vbs //NoLogo SET "W3SVC/3/ROOT/DefaultDoc" "index.html"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/DefaultDoc", "index.html"

' Install jrun filter
'   Create Filters Path. ( Throws error if already created. )
'	cscript adsutil.vbs //NoLogo CREATE "W3SVC/3/Filters" "IIsFilters"
	CreateCommandParam WebSiteADSILocalPath & "/Filters", "IIsFilters"

'   Create metabase path for jrun filter info.
'	cscript adsutil.vbs //NoLogo CREATE "W3SVC/3/Filters/CW2000jrun" "IIsFilter"
	CreateCommandParam WebSiteADSILocalPath & "/Filters/CW2000jrun", "IIsFilter"

'   Set path to jrun filter dll. ( Creates metabase parameter. )
SetCommandParam WebSiteADSILocalPath & "/Filters/CW2000jrun/FilterPath", RootDirectory & "\lib\jrun\plugin\jrun.dll"

' Assume that parameter "W3SVC/3/Filters/<filterName>/FilterState is created / managed by IIS.

'   Set filter load order.
'	cscript adsutil.vbs //NoLogo SET "W3SVC/3/Filters/FilterLoadOrder" "CW2000jrun"
	SetCommandParam WebSiteADSILocalPath & "/Filters/FilterLoadOrder", "CW2000jrun"

' Authentication: Enable Anonymous and Basic, disable NT Challenge / Response (NTLM)
'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/AuthAnonymous True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AuthAnonymous", "True"

'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/AuthBasic True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AuthBasic", "True"

'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/AuthNTLM False
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AuthNTLM", "False"

' Authentication: Set bin account for Anonymous access and sync password.
'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/AnonymousUserName "bin"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AnonymousUserName", "bin"

'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/AnonymousPasswordSync True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/AnonymousPasswordSync", "True"

' Hmmm... didn't notice this option in MMC IIS console...
'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/CreateCGIWithNewConsole True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/CreateCGIWithNewConsole", "True"

' Should run applications in separate memory space (OUTPROC) to avoid things
'   like java run time conflicts with other web sites. But they are more
'   stable in terms of memory consumption and other factors as IN-PROCESS (INPROC)
'   applications. Hence INPROC for now.
'   Please use the constants INPROC / OUTPROC here.
'	cscript adsutil.vbs //NoLogo APPCREATEINPROC  W3SVC/3/ROOT
	AppCreateCommandParam WebSiteADSILocalPath & "/ROOT", INPROC

' for perl_postinstall:
' extension,scriptProcessor,Flags
'   Flag = 1, Allowed on read directory.
'	cscript adsutil.vbs //NoLogo SET W3SVC/3/ROOT/ScriptMaps ".pl,C:\Program Files\CSCOpx\bin\perl.exe ""%s"",1"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/ScriptMaps", ".pl," & RootDirectory & "\bin\perl.exe ""%s"",1"

'  Map /cgi-bin virtual directory w/ permissions execute, deny inherited write.
	' cscript mkwebdir.vbs //NoLogo -w "CW2000" -v "cgi-bin","C:\Program Files\CSCOpx\cgi-bin"
	ASTCreateVirtualWebDir WebSite, "cgi-bin",RootDirectory & "\cgi-bin"
	' cscript w3cfg.vbs //NoLogo SET W3SVC/3/ROOT/cgi-bin/AccessExecute True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/cgi-bin/AccessWrite", "False"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/cgi-bin/AccessExecute", "True"

'  Map /CSCOnm/classpath virtual directory w/ permissions deny inherited write.
'  Can't map virtual path, only single level directory! Asked bdegtyar, this is ok for now.
	' cscript mkwebdir.vbs //NoLogo -w "CW2000" -v "CSCOnm","C:\Program Files\CSCOpx\www"
	ASTCreateVirtualWebDir WebSite, "CSCOnm", RootDirectory & "\www"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/CSCOnm/AccessWrite", "False"

'  Map /Scripts virtual directory w/ permissions execute, deny inherited write.
	' cscript mkwebdir.vbs //NoLogo -w "CW2000" -v "Scripts","C:\Program Files\CSCOpx\lib\jrun\plugin"
	ASTCreateVirtualWebDir WebSite, "Scripts", RootDirectory & "\lib\jrun\plugin"
	' cscript w3cfg.vbs //NoLogo SET W3SVC/3/ROOT/Scripts/AccessExecute True
	SetCommandParam WebSiteADSILocalPath & "/ROOT/Scripts/AccessWrite", "False"
	SetCommandParam WebSiteADSILocalPath & "/ROOT/Scripts/AccessExecute", "True"

'  If it's NT Workstation, stop all the other web servers since NT Workstation
'    supports only one running webserver, and it should be US!
	Err.clear
	WinProductType = WshShell.RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions\ProductType")
	If (Err.Number <> 0) Then
		Message "Error", True,   "Couldn't read registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions\ProductType"
		Message "Error", False,  "to determine NT ProductType."
	Else
		If (WinProductType = "WinNT") Then
			Message "Info", False, "Host is NT Workstation, hence Personal Web Server."
			Message "Info", False, "Personal Web Server only supports a single web server."
			Message "Info", False, "Stopping all other web servers in order to start " & ServerComment
			Message "Info", False, "as the only allowed server under Personal Web Server."
			Return = StopWServerAllCommandParam()
		End If
	End If


	' Start CW2000 web server.
	' Argh! on workstation / pws need to stop default site. Probably should have taken
	'   it over to begin with :-(
	StartServerCommandParam WebSiteADSILocalPath

'  Restore IISADMIN and W3SVC services to the state we found them in.

'	If (Not W3SVCRunningOnEntry) Then
		'7 = SW_SHOWMINNOACTIVE
		'Stop W3SVC  service.
'		Return = WshShell.Run ("%SystemRoot%\system32\net.exe stop W3SVC     ", 7, True)
'	End If

'	If (Not IISADMINRunningOnEntry) Then
		'Stop IISADMIN service. MUST have /yes so other dependent services like MSFTPSVC
		'   are also stopped. Otherwise it won't let us stop IISADMIN .
'		Return = WshShell.Run ("%SystemRoot%\system32\net.exe stop IISADMIN /yes ", 7, True)
'	End If

	Set WshShell = Nothing

End Function

''''''''''''''''''''''''''
' EssentialsUnInstall the CW2000 Essentials website.
''''''''''''''''''''''''''
Function EssentialsUnInstall()
	Dim ServerComment
	Dim WebHost, WebSite
	Dim WebSiteADSILocalPath, WebSiteADSIPath
	Dim ServerState
	Dim ServerList

	On Error Resume Next
	EssentialsUnInstall = 0 ' Assume Success
	WebHost = "LocalHost"

'Parse our arguments.
   	 'WScript.Echo "  w3cfg.vbs ESSENTIALSUNINSTALL ""CW2000"""

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the ESSENTIALSUNINSTALL command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ServerComment = ArgObj.Item(1)

'indev Add IISADMIN/W3SVC service state check, start it, and then leave it in the state we found it.

'  Find the created web site and it's automatically assigned numerical "Name".
	set WebSite = findWebFromServerComment(WebHost, ServerComment)
        Err.Clear
	if Not isObject(WebSite) then
		' CAUTION: Changing the text of this message will break
		'   web.rul for Cisco Works 2000 Essentials intallshield
		'   installer!!
		Message "Error", False, "Can't find " & ServerComment & " webserver in IIS 4.0 metabase. Possibly uninstalled already."
		WScript.Quit (1)
	end if

'  Generate useful ADSI paths.
	WebSiteADSILocalPath = "W3SVC/" & WebSite.Name
        WebSiteADSIPath = "IIS://" & WebHost & "/" & WebSiteADSILocalPath

'  Stop it. ( The website :-) )
	' cscript w3cfg.vbs //NoLogo STOP_SERVER W3SVC/3
	StopServerCommandParam WebSiteADSILocalPath

'  Delete the application.
'  Otherwise, the Micorosoft Transaction Server Packages don't get cleaned up.
	AppDeleteCommandParam WebSiteADSILocalPath & "/ROOT"

'  Delete the web virtual service object.
	ServerList    = Array(1)
	ServerList(0) = WebSite.Name
	ASTDeleteWebSite(ServerList)

	EssentialsUnInstall = 0 ' Success

End Function ' EssentialsUnInstall()



''''''''''''''''''''''''''''
'
' Display Help Message
'
''''''''''''''''''''''''''''
Sub DisplayHelpMessage ()
    WScript.Echo
    WScript.Echo "Usage:"
    WScript.Echo "	w3cfg.vbs <cmd> [<path> [<value>]]"
    WScript.Echo
    WScript.Echo "Note: w3cfg only supports the ""no switch"" option of MDUTIL"
    WScript.Echo
    WScript.Echo "Description:"
    WScript.Echo "CW2000 Essentials w3svc configuration and"
    WScript.Echo "IIS K2 administration utility that enables the manipulation with ADSI parameters"
    WScript.Echo
    WScript.Echo "Supported MDUTIL Commands:"
    WScript.Echo "  GET, SET, ENUM, DELETE, CREATE, COPY, "
    WScript.Echo "  APPCREATEINPROC, APPCREATEOUTPROC, APPDELETe, APPUNLOAD, APPGETSTATUS "
    WScript.Echo
    WScript.Echo "Samples:"
    WScript.Echo "  w3cfg.vbs ESSENTIALSINFOSHORT  ""CW2000"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSCLEANPREV ""C:\Program Files\CSCOpx"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSINFO      ""CW2000"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSINSTALL   ""CW2000"" 1741 ""C:\Program Files\CSCOpx"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSUNINSTALL ""CW2000"""
    WScript.Echo
    WScript.Echo "  w3cfg.vbs GET W3SVC/1/ServerBindings"
    WScript.Echo "  w3cfg.vbs SET W3SVC/1/ServerBindings "":81:"""
    WScript.Echo "  w3cfg.vbs CREATE W3SVC/1/ROOT/MyVdir ""IIsWebVirtualDir"""
    WScript.Echo "  w3cfg.vbs START_SERVER W3SVC/1"
    WScript.Echo "  w3cfg.vbs ENUM /P W3SVC"
    WScript.Echo
    WScript.Echo "For Extended Help type:"
    WScript.Echo "  w3cfg.vbs HELP"


End Sub



''''''''''''''''''''''''''''
'
' Display Help Message
'
''''''''''''''''''''''''''''
Sub DisplayHelpMessageEx ()

    WScript.Echo
    WScript.Echo "Usage:"
    WScript.Echo "	w3cfg.vbs CMD [param param]"
    WScript.Echo
    WScript.Echo "Note: w3cfg only supports the ""no switch"" option of MDUTIL"
    WScript.Echo
    WScript.Echo "Description:"
    WScript.Echo "CW2000 Essentials w3svc installation and"
    WScript.Echo "IIS K2 administration utility that enables the manipulation with ADSI parameters"
    WScript.Echo
    WScript.Echo " w3cfg.vbs ESSENTIALSCLEANPREV previousInstallDir            - Clean previous version from webserver."
    WScript.Echo " w3cfg.vbs ESSENTIALSINFO      serverComment                 - Display all configuration information."
    WScript.Echo " w3cfg.vbs ESSENTIALSINFOSHORT serverComment                 - Display bindings and site ADSI path."
    WScript.Echo " w3cfg.vbs ESSENTIALSINSTALL   serverComment port installDir - Install   the ESSENTIALS website."
    WScript.Echo " w3cfg.vbs ESSENTIALSUNINSTALL serverComment                 - UnInstall the ESSENTIALS website."
    WScript.Echo
    WScript.Echo "Standard MDUTIL Commands:"
    WScript.Echo " w3cfg.vbs GET      path             - display chosen parameter"
    WScript.Echo " w3cfg.vbs SET      path value ...   - assign the new value"
    WScript.Echo " w3cfg.vbs ENUM     path [""/P"" | ""/A""] - enumerate all parameters for given path"
    WScript.Echo " w3cfg.vbs DELETE   path             - delete given path or parameter"
    WScript.Echo " w3cfg.vbs CREATE   path [KeyType]   - create given path and assigns it the given KeyType"
    WScript.Echo
    WScript.Echo " w3cfg.vbs APPCREATEINPROC  W3SVC/1/ROOT - Create an in-proc application"
    WScript.Echo " w3cfg.vbs APPCREATEOUTPROC W3SVC/1/ROOT - Create an out-proc application"
    WScript.Echo " w3cfg.vbs APPDELETE        W3SVC/1/ROOT - Delete the application if there is one"
    WScript.Echo " w3cfg.vbs APPUNLOAD        W3SVC/1/ROOT - Unload an application from w3svc runtime lookup table."
    WScript.Echo " w3cfg.vbs APPGETSTATUS     W3SVC/1/ROOT - Get status of the application"
    WScript.Echo
    WScript.Echo "New ADSI Options:"
    WScript.Echo " /P - Valid for ENUM only.  Enumerates the paths only (no data)"
    WScript.Echo " /A - Valid for ENUM only.  Enumerates all data that CAN be set on the node"
    WScript.Echo " KeyType - Valide for CREATE only.  Assigns the valid KeyType to the path"
    WScript.Echo
    WScript.Echo "Extended w3cfg Commands:"
    WScript.Echo " w3cfg.vbs FIND             path     - find the paths where a given parameter is set"
    WScript.Echo " w3cfg.vbs CREATE_VDIR      path     - create given path as a Virtual Directory"
    WScript.Echo " w3cfg.vbs CREATE_VSERV     path     - create given path as a Virtual Server"
    WScript.Echo " w3cfg.vbs START_SERVER     path     - starts the given web site"
    WScript.Echo " w3cfg.vbs STOP_SERVER      path     - stops the given web site"
    WScript.Echo " w3cfg.vbs STOP_WSERVER_ALL path     - stops ALL web sites"
    WScript.Echo " w3cfg.vbs PAUSE_SERVER     path     - pauses the given web site"
    WScript.Echo " w3cfg.vbs CONTINUE_SERVER  path     - continues the given web site"
    WScript.Echo
    WScript.Echo "Samples:"
    WScript.Echo "  w3cfg.vbs ESSENTIALSINFOSHORT  ""CW2000"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSCLEANPREV ""C:\Program Files\CSCOpx"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSINFO      ""CW2000"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSINSTALL   ""CW2000"" 1741 ""C:\Program Files\CSCOpx"""
    WScript.Echo "  w3cfg.vbs ESSENTIALSUNINSTALL ""CW2000"""
    WScript.Echo "  w3cfg.vbs GET W3SVC/1/ServerBindings"
    WScript.Echo "  w3cfg.vbs SET W3SVC/1/ServerBindings "":81:"""
    WScript.Echo "  w3cfg.vbs CREATE W3SVC/1/ROOT/MyVdir ""IIsWebVirtualDir"""
    WScript.Echo "  w3cfg.vbs START_SERVER W3SVC/1"
    WScript.Echo "  w3cfg.vbs ENUM /P W3SVC"

' w3cfg.vbs ENUM_ALL path             - recursively enumerate all parameters
' w3cfg.vbs COPY     pathsrc pathdst  - copy all from pathsrc to pathdst (will create pathdst)
' w3cfg.vbs SCRIPT   scriptname       - runs the script

'  -path has format: {computer}/{service}/{instance}/{URL}/{Parameter}

End Sub






'''''''''''''''''''''''''''
'
' DetectExeType
'
' This can detect the type of exe the
' script is running under and warns the
' user of the popups.
'
'''''''''''''''''''''''''''
Sub DetectExeType ()
	Dim ScriptHost
	Dim ShellObject

	Dim CurrentPathExt
	Dim EnvObject

	Dim RegCScript
	Dim RegPopupType ' This is used to set the pop-up box flags.  
						' I couldn't find the pre-defined names
	RegPopupType = 32 + 4

	On Error Resume Next

	ScriptHost = WScript.FullName
	ScriptHost = Right (ScriptHost, Len (ScriptHost) - InStrRev(ScriptHost,"\"))

	If (UCase (ScriptHost) = "WSCRIPT.EXE") Then
		WScript.Echo ("This script does not work with WScript.")

		' Create a pop-up box and ask if they want to register cscript as the default host.
		Set ShellObject = WScript.CreateObject ("WScript.Shell")
		' -1 is the time to wait.  0 means wait forever.
		RegCScript = ShellObject.PopUp ("Would you like to register CScript as your default host for VBscript?", 0, "Register CScript", RegPopupType)
                                                                                
		If (Err.Number <> 0) Then
			ReportError ()
			WScript.Echo "To run this script using CScript, type: ""CScript.exe " & WScript.ScriptName & """"
			WScript.Quit (GENERAL_FAILURE)
			WScript.Quit (Err.Number)
		End If

		' Check to see if the user pressed yes or no.  Yes is 6, no is 7
		If (RegCScript = 6) Then
			ShellObject.RegWrite "HKEY_CLASSES_ROOT\VBSFile\Shell\Open\Command\", "%WINDIR%\System32\CScript.exe //nologo ""%1"" %*", "REG_EXPAND_SZ"
			ShellObject.RegWrite "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\VBSFile\Shell\Open\Command\", "%WINDIR%\System32\CScript.exe //nologo ""%1"" %*", "REG_EXPAND_SZ"
			' Check if PathExt already existed
			CurrentPathExt = ShellObject.RegRead ("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\PATHEXT")
			if Err.Number = &h80070002 Then
				Err.Clear
				Set EnvObject = ShellObject.Environment ("PROCESS")
				CurrentPathExt = EnvObject.Item ("PATHEXT")
			End If

			ShellObject.RegWrite "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment\PATHEXT", CurrentPathExt & ";.VBS", "REG_SZ"

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying to write the registry settings!"
				WScript.Quit (Err.Number)
			Else
				Message "Info", False, "Successfully registered CScript"
			End If
		else
			Message "Info", False, "To run this script type: ""CScript.Exe w3cfg.vbs <cmd> <params>"""
		End If

		Dim ProcString
		Dim ArgIndex
		Dim ArgObj
		Dim Result

		ProcString = "Cscript //nologo " & WScript.ScriptFullName

		Set ArgObj = WScript.Arguments

		For ArgIndex = 0 To ArgObj.Count - 1
			ProcString = ProcString & " " & ArgObj.Item (ArgIndex)
		Next

		'Now, run the original executable under CScript.exe
		Result = ShellObject.Run (ProcString, 0, True)

		WScript.Quit (Result)
	End If

End Sub


''''''''''''''''''''''''''
' SetCommand Function
' Sets the value of a property in the metabase.
''''''''''''''''''''''''''
Function SetCommand()
	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim ObjectPath
	Dim ObjectParameter
	Dim MachineName
	Dim ValueIndex
	Dim ValueList
	Dim ValueDisplay
	Dim ValueDisplayLen
	Dim ValueDataType

	Dim ValueData

	Dim ObjectDataType

	On Error Resume Next

	SetCommand = 0 ' Assume Success

	If ArgObj.Count < 3 Then
		WScript.Echo "Error: Wrong number of Args for the SET command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item(1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParameter = SplitParam (ObjectPath)

	' Some Property Types have special needs - like ServerCommand.
	' Check to see if this is a special command.  If it is, then process it special.
	If (IsSpecialSetProperty (ObjectParameter)) Then
		SetCommand = DoSpecialSetProp (ObjectPath, ObjectParameter, MachineName)
		Exit Function 		
	End If

	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To Get the Object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Get the Schema of the property and determine if it's multivalued
	IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	ObjectDataType = UCase(IIsSchemaObject.Syntax)
	SanitizePath ObjectDataType

	Select Case (ObjectDataType)

	Case "STRING"
		ValueList = ArgObj.Item(2)
		IIsObject.Put ObjectParameter, (ValueList)

	Case "EXPANDSZ"
		ValueList = ArgObj.Item(2)
		IIsObject.Put ObjectParameter, (ValueList)

	Case "INTEGER"
		' Added to convert hex values to integers
		ValueData = ArgObj.Item(2)

		If (UCase(Left (ValueData, 2))) = "0X" Then 
			ValueData = "&h" &  Right (ValueData, Len (ValueData) - 2)
		End If

		ValueList = CLng (ValueData)
		IIsObject.Put ObjectParameter, (ValueList)

	Case "BOOLEAN"
		ValueList = CBool (ArgObj.Item(2))
		IIsObject.Put ObjectParameter, (ValueList)

	Case "LIST"
		ReDim ValueList(ArgObj.Count - 3)
		For ValueIndex = 2 To ArgObj.Count - 1
			ValueList (ValueIndex - 2) = ArgObj.Item (ValueIndex)
		Next

		IIsObject.Put ObjectParameter, (ValueList)

	Case Else
		WScript.Echo "Error: Unknown data type in schema: " & IIsSchemaObject.Syntax

	End Select

	IIsObject.SetInfo

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To SET the Property: " & ObjectParameter
		WScript.Quit (Err.Number)
	End If

	' The function call succeeded, so display the output
	' Set up the initial part of the display - the property name and data type
	ValueDisplay = ObjectParameter
	ValueDisplayLen = Len (ValueDisplay)

	If (ValueDisplayLen < SpacerSize) Then
		'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
		ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & ObjectDataType & ") "
	Else
		ValueDisplay = ValueDisplay & ": " & "(" & TypeName (ValueList) & ") "
	End If

	' Create the rest of the display - The actual data
	If (IIsSchemaObject.MultiValued) Then
		For ValueIndex = 0 to UBound (ValueList)
			'WScript.Echo """" & ValueList(ValueIndex) & """"
			ValueDisplay = ValueDisplay & """" & ValueList (ValueIndex) & """ "
		Next
	Else
		If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
			'WScript.Echo """" & ValueList & """"
			ValueDisplay = ValueDisplay & """" & ValueList & """"
		Else
			'WScript.Echo ValueList
			ValueDisplay = ValueDisplay & ValueList
		End If
	End If

	' Display the output
	WScript.Echo ValueDisplay

	SetCommand = 0 ' Success

End Function

'Parameterized version of SetCommand
'  List type properties are restricted to a single value for this
'  limited implementation.
Function SetCommandParam(ObjectPath, Value)
	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim ObjectParameter
	Dim MachineName
	Dim ValueIndex
	Dim ValueList
	Dim ValueDisplay
	Dim ValueDisplayLen
	Dim ValueDataType
	Dim ValueData
	Dim ObjectDataType

	On Error Resume Next

	SetCommandParam = 0 ' Assume Success

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParameter = SplitParam (ObjectPath)

	' Some Property Types have special needs - like ServerCommand.
	' Check to see if this is a special command.  If it is, then process it special.
	If (IsSpecialSetProperty (ObjectParameter)) Then
		SetCommandParam = DoSpecialSetProp (ObjectPath, ObjectParameter, MachineName)
		Exit Function 		
	End If

	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To Get the Object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Get the Schema of the property and determine if it's multivalued
	IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	ObjectDataType = UCase(IIsSchemaObject.Syntax)
	SanitizePath ObjectDataType

	Select Case (ObjectDataType)

	Case "STRING"
		ValueList = Value
		IIsObject.Put ObjectParameter, (ValueList)

	Case "EXPANDSZ"
		ValueList = Value
		IIsObject.Put ObjectParameter, (ValueList)

	Case "INTEGER"
		' Added to convert hex values to integers
		ValueData = Value

		If (UCase(Left (ValueData, 2))) = "0X" Then 
			ValueData = "&h" &  Right (ValueData, Len (ValueData) - 2)
		End If

		ValueList = CLng (ValueData)
		IIsObject.Put ObjectParameter, (ValueList)

	Case "BOOLEAN"
		ValueList = CBool (Value)
		IIsObject.Put ObjectParameter, (ValueList)

	Case "LIST"
		ReDim ValueList(0)
		ValueList (0) = Value
		IIsObject.Put ObjectParameter, (ValueList)

	Case Else
		WScript.Echo "Error: Unknown data type in schema: " & IIsSchemaObject.Syntax

	End Select

	IIsObject.SetInfo

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To SET the Property: " & ObjectParameter
		WScript.Quit (Err.Number)
	End If

	' The function call succeeded, so display the output
	' Set up the initial part of the display - the property name and data type
	ValueDisplay = ObjectParameter
	ValueDisplayLen = Len (ValueDisplay)

	If (ValueDisplayLen < SpacerSize) Then
		'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
		ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & ObjectDataType & ") "
	Else
		ValueDisplay = ValueDisplay & ": " & "(" & TypeName (ValueList) & ") "
	End If

	' Create the rest of the display - The actual data
	If (IIsSchemaObject.MultiValued) Then
		For ValueIndex = 0 to UBound (ValueList)
			'WScript.Echo """" & ValueList(ValueIndex) & """"
			ValueDisplay = ValueDisplay & """" & ValueList (ValueIndex) & """ "
		Next
	Else
		If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
			'WScript.Echo """" & ValueList & """"
			ValueDisplay = ValueDisplay & """" & ValueList & """"
		Else
			'WScript.Echo ValueList
			ValueDisplay = ValueDisplay & ValueList
		End If
	End If

	' Display the output
	WScript.Echo ValueDisplay

	SetCommandParam = 0 ' Success

End Function


''''''''''''''''''''''''''
'
' GetCommand Function
'
' Gets the value of a property in the metabase.
'
''''''''''''''''''''''''''
Function GetCommand()

	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim ObjectPath
	Dim ObjectParameter
	Dim MachineName
	Dim ValueIndex
	Dim ValueList
	Dim ValueDisplay
	Dim ValueDisplayLen
	Dim NewObjectParameter

	Dim DataPathList
	Dim DataPath

	On Error Resume Next

	GetCommand = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the GET command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParameter = SplitParam (ObjectPath)

	NewObjectParameter = MapSpecGetParamName (ObjectParameter)
	ObjectParameter = NewObjectParameter

	If (IsSpecialGetProperty(ObjectParameter)) Then
		GetCommand = DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)
		Exit Function
	End If

	If ObjectPath = "" Then 
		IIsObjectPath = "IIS://" & MachineName
	Else
		IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Object (GetObject Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Get the Schema of the property and determine if it's multivalued
	IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	' First, attempt to retrieve the property - this will tell us
	' if you are even allowed to set the property at this node.
	' Retrieve the property
	ValueList = IIsObject.Get (ObjectParameter)
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the property: (Get Method Failed) " & ObjectParameter
		WScript.Echo "  (This property is probably not allowed at this node)"
		WScript.Quit (Err.Number)
	End If

	' Test to see if the property is ACTUALLY set at this node
	DataPathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_INHERIT)
	If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_NO_INHERIT)
	Err.Clear

	' If the data is not set anywhere, then stop the madness
	If (UBound (DataPathList) < 0) Then
		WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
		WScript.Quit (&h80005006) ' end with property not set error
	End If

	DataPath = DataPathList (0)
	SanitizePath DataPath

	' Test to see if the item is actually set HERE
	If UCase (DataPath) <> UCase (IIsObjectPath) Then
		WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
		WScript.Quit (&h80005006) ' end with property not set error
	End If

	' Set up the initial part of the display - the property name and data type
	ValueDisplay = ObjectParameter
	ValueDisplayLen = Len (ValueDisplay)

	If (ValueDisplayLen < SpacerSize) Then
		'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
		ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & UCase(IIsSchemaObject.Syntax) & ") "
	Else
		ValueDisplay = ValueDisplay & ": " & "(" & TypeName (ValueList) & ") "
	End If

	' Create the rest of the display - The actual data
	If (IIsSchemaObject.MultiValued) Then
		For ValueIndex = 0 to UBound (ValueList)
			'WScript.Echo """" & ValueList(ValueIndex) & """"
			ValueDisplay = ValueDisplay & """" & ValueList (ValueIndex) & """ "
		Next
	Else
		If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
			'WScript.Echo """" & ValueList & """"
			ValueDisplay = ValueDisplay & """" & ValueList & """"
		Else
			'WScript.Echo ValueList
			ValueDisplay = ValueDisplay & ValueList
		End If
	End If

	' Display the output
	WScript.Echo ValueDisplay

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Property: " & ObjectParameter
		WScript.Quit (Err.Number)
	End If

	GetCommand = 0 ' Success

End Function

''''''''''''''''''''''''''
' GetCommandParam Function
' Parameterized version of GetCommand
'
''''''''''''''''''''''''''
Function GetCommandParam(ObjectPath, ValueList)

	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim ObjectParameter
	Dim MachineName
	Dim ValueIndex
	Dim ValueDisplay
	Dim ValueDisplayLen
	Dim NewObjectParameter

	Dim DataPathList
	Dim DataPath

	On Error Resume Next

	GetCommandParam = 0 ' Assume Success

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParameter = SplitParam (ObjectPath)

	NewObjectParameter = MapSpecGetParamName (ObjectParameter)
	ObjectParameter = NewObjectParameter

	If (IsSpecialGetProperty(ObjectParameter)) Then
		GetCommandParam = DoSpecialGetProp(ObjectPath, ObjectParameter, MachineName)
		Exit Function
	End If

	If ObjectPath = "" Then 
		IIsObjectPath = "IIS://" & MachineName
	Else
		IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Object (GetObject Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Get the Schema of the property and determine if it's multivalued
	IIsSchemaPath = "IIS://" & MachineName & "/Schema/" & ObjectParameter
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	' First, attempt to retrieve the property - this will tell us
	' if you are even allowed to set the property at this node.
	' Retrieve the property
	ValueList = IIsObject.Get (ObjectParameter)
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the property: (Get Method Failed) " & ObjectParameter
		WScript.Echo "  (This property is probably not allowed at this node)"
		WScript.Quit (Err.Number)
	End If

	' Test to see if the property is ACTUALLY set at this node
	DataPathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_INHERIT)
	If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_NO_INHERIT)
	Err.Clear

	' If the data is not set anywhere, then stop the madness
	If (UBound (DataPathList) < 0) Then
		WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
		WScript.Quit (&h80005006) ' end with property not set error
	End If

	DataPath = DataPathList (0)
	SanitizePath DataPath

	' Test to see if the item is actually set HERE
	If UCase (DataPath) <> UCase (IIsObjectPath) Then
		WScript.Echo "The parameter """ & ObjectParameter & """ is not set at this node."
		WScript.Quit (&h80005006) ' end with property not set error
	End If

	' Set up the initial part of the display - the property name and data type
	ValueDisplay = ObjectParameter
	ValueDisplayLen = Len (ValueDisplay)

	If (ValueDisplayLen < SpacerSize) Then
		'ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & TypeName (ValueList) & ") "
		ValueDisplay = ValueDisplay & (Right (Spacer, SpacerSize - ValueDisplayLen)) & ": " & "(" & UCase(IIsSchemaObject.Syntax) & ") "
	Else
		ValueDisplay = ValueDisplay & ": " & "(" & TypeName (ValueList) & ") "
	End If

	' Create the rest of the display - The actual data
	If (IIsSchemaObject.MultiValued) Then
		For ValueIndex = 0 to UBound (ValueList)
			'WScript.Echo """" & ValueList(ValueIndex) & """"
			ValueDisplay = ValueDisplay & """" & ValueList (ValueIndex) & """ "
		Next
	Else
		If (UCase(IIsSchemaObject.Syntax) = "STRING") Then
			'WScript.Echo """" & ValueList & """"
			ValueDisplay = ValueDisplay & """" & ValueList & """"
		Else
			'WScript.Echo ValueList
			ValueDisplay = ValueDisplay & ValueList
		End If
	End If

	' Display the output
	WScript.Echo ValueDisplay

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To GET the Property: " & ObjectParameter
		WScript.Quit (Err.Number)
	End If

	GetCommandParam = 0 ' Success

End Function


''''''''''''''''''''''''''
'
' EnumCommand Function
'
' Enumerates all properties at a path in the metabase.
'
''''''''''''''''''''''''''
Function EnumCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim ObjectPath
	Dim MachineName
	Dim ValueIndex
	Dim ValueList
	Dim ValueString
	Dim PropertyName
	Dim PropertyListSet
	Dim PropertyList
	Dim PropertyObjPath
	Dim PropertyObject
	Dim ChildObject
	Dim ChildObjectName
	Dim EnumPathsOnly
	Dim EnumAllData
	Dim ErrMask

	Dim PropertyDataType

	Dim DataPathList
	Dim DataPath

	Dim SpecialResult

	Dim PathOnlyOption
	PathOnlyOption = "/P"
	Dim AllDataOption
	AllDataOption = "/A"

	EnumCommand = 0 ' Assume Success
	EnumPathsOnly = False ' Assume that the user wants all of the data items
	EnumAllData = False ' Assume that the user wants only the actual data items

'Debug
'Dim TestObjectPath
'Dim TestNumber
'Dim TestIndex
'Dim SetIndex

'debug
'WScript.Echo "ArgObj.Count: " & ArgObj.Count
'For TestIndex = 0 to ArgObj.Count - 1
'	WScript.Echo "ArgObj.Item(" & TestIndex & "): " & ArgObj.Item(TestIndex)
'Next

	If (ArgObj.Count = 1) Then
		ObjectPath = ""
		EnumPathsOnly = False
	ElseIf (ArgObj.Count = 2) Then
		If UCase (ArgObj.item(1)) = PathOnlyOption Then 
			ObjectPath = ""
			EnumPathsOnly = True
		Elseif UCase (ArgObj.item(1)) = AllDataOption Then
			ObjectPath = ""
			EnumAllData = True
		Else
			ObjectPath = ArgObj.Item (1)
			EnumPathsOnly = False
		End if
	Elseif (ArgObj.Count = 3) Then 

		If UCase (ArgObj.item(1)) =  PathOnlyOption Then 
			ObjectPath = ArgObj.Item (2)
			EnumPathsOnly = True
		ElseIf UCase (ArgObj.Item(2)) = PathOnlyOption Then
			ObjectPath = ArgObj.Item (1)
			EnumPathsOnly = True
		ElseIf UCase (ArgObj.Item(1)) = AllDataOption Then
			ObjectPath = ArgObj.Item (2)
			EnumAllData = True
		ElseIf UCase (ArgObj.Item(2)) = AllDataOption Then
			ObjectPath = ArgObj.Item (1)
			EnumAllData = True
		Else
			WScript.Echo "Error: Invalid arguments for the ENUM command"
			WScript.Quit (GENERAL_FAILURE)
		End if
	Else
		WScript.Echo "Error: Wrong number of Args for the ENUM command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

'debug 
'WScript.Echo "EnumPathsOnly: " & EnumPathsOnly
'WScript.Echo "EnumAllData: " & EnumAllData
'WScript.Echo "ObjectPath: " & ObjectPath
'WScript.Quit (Err.Number)

	IIsObjectPath = "IIS://" & MachineName
	If (ObjectPath <> "") Then 
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If
'debug
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error Trying To ENUM the Object (GetObject Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Get the Schema of the object and enumerate through all of the properties
	IIsSchemaPath = IIsObject.Schema
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	Redim PropertyListSet (1)
	PropertyListSet(0) = IIsSchemaObject.MandatoryProperties
	PropertyListSet(1) = IIsSchemaObject.OptionalProperties

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error trying to get the list of properties: " & IIsSchemaPath
		WScript.Quit (Err.Number)
	End If

	If (Not EnumPathsOnly) Then
	For Each PropertyList in PropertyListSet

		For Each PropertyName in PropertyList
			' Test to see if the property is even set at this node
			DataPathList = IIsObject.GetDataPaths (PropertyName, IIS_DATA_INHERIT)
			If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths (PropertyName, IIS_DATA_NO_INHERIT)
			Err.Clear

			If (UBound (DataPathList) >= 0) Or (EnumAllData)Then
			 DataPath = DataPathList (0)
			 SanitizePath DataPath
			 If (UCase (DataPath) = UCase (IIsObjectPath)) Or (EnumAllData) Then
			 ' If the above statement is true, then the data exists here or the user wants it anyway.

			PropertyObjPath = "IIS://" & MachineName & "/Schema/" & PropertyName
			Set PropertyObject = GetObject (PropertyObjPath)

			If (Err.Number <> 0) Then
				WScript.Echo
				ReportError ()
				WScript.Echo "Error trying to enumerate the Optional properties (Couldn't Get Property Information): " & PropertyObjPath
				WScript.Echo "Last Property Name: " & PropertyName
				WScript.Echo "PropertyObjPath: " & PropertyObjPath
				'WScript.Quit (Err.Number)
				WScript.Echo
				EnumCommand = Err.Number
				Err.Clear
			End If

			ValueList = ""

			PropertyDataType = UCase (PropertyObject.Syntax)
			Select Case PropertyDataType
				Case "STRING"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ")" & """" & ValueList & """"
					End If
				Case "EXPANDSZ"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") """ & ValueList & """"
					End If
				Case "INTEGER"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") " & ValueList
					End If
				Case "BOOLEAN"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") " & ValueList
					End If

				Case "LIST"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ")"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ")"
					End If
					ValueString = ""

					For ValueIndex = 0 to UBound (ValueList)
						ValueString = ValueString & """" & ValueList (ValueIndex) & """"
						If ValueIndex < UBound (ValueList) Then
							ValueString = ValueString & ", "
						End If
					Next
					WScript.Echo "   " & ValueString

				Case Else

					If (IsSpecialGetProperty (PropertyName)) Then

						SpecialResult = DoSpecialGetProp (ObjectPath, PropertyName, MachineName)
						Err.Clear

					Else
						WScript.Echo
						WScript.Echo "DataType: " & """" & PropertyObject.Syntax & """" & " Not Yet Supported on property: " & PropertyName
						ReportError
						WScript.Echo
					End If

			End Select

			 End If ' End if data exists at the current node
			End If ' End If data list > 0

			If (Err.Number <> 0) Then
				WScript.Echo
				ReportError ()
				WScript.Echo "Error trying to enumerate the Optional properties (Error trying to get property value): " & PropertyObjPath
				WScript.Echo "Last Property Name: " & PropertyName
				WScript.Echo "PropertyObjPath: " & PropertyObjPath
				' If there is an ADS error, just ignore it and move on
				' otherwise, quit
				if ((Err.Number) >= &H80005000) And ((Err.Number) < &H80006000) then
					Err.Clear
					WScript.Echo "Continuing..."
				Else
					WScript.Quit (Err.Number)
				End If
				WScript.Echo
			End If
		Next
	Next

	End If ' End if (Not EnumPathsOnly)

	' Now, enumerate the data paths
	For Each ChildObject in IIsObject
		ChildObjectName = Right (ChildObject.Adspath, Len (ChildObject.AdsPath) - 6)
		ChildObjectName = Right (ChildObjectName, Len (ChildObjectName) - InStr (ChildObjectName, "/") + 1)
		WScript.Echo "[" & ChildObjectName & "]"
	Next

End Function


''''''''''''''''''''''''''
' EnumCommandParam Function
' Paramaterized version of EnumCommand
' EnumOption can be one of:
'   "/P" Enumerate the paths only (no data).
'   "/A" Enumerate all data that CAN be set on the node.
'   ""   Enumerate all data set at this node.
'
' Modified to return instead of quit the script on error.
''''''''''''''''''''''''''
Function EnumCommandParam(ObjectPath, EnumOption)

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsSchemaObject
	Dim IIsSchemaPath
	Dim MachineName
	Dim ValueIndex
	Dim ValueList
	Dim ValueString
	Dim PropertyName
	Dim PropertyListSet
	Dim PropertyList
	Dim PropertyObjPath
	Dim PropertyObject
	Dim ChildObject
	Dim ChildObjectName
	Dim EnumPathsOnly
	Dim EnumAllData
	Dim ErrMask

	Dim PropertyDataType

	Dim DataPathList
	Dim DataPath

	Dim SpecialResult

	Dim PathOnlyOption
	PathOnlyOption = "/P"
	Dim AllDataOption
	AllDataOption = "/A"

	EnumCommandParam = 0 ' Assume Success
	EnumPathsOnly = False ' Assume that the user wants all of the data items
	EnumAllData = False ' Assume that the user wants only the actual data items

'Debug
'Dim TestObjectPath
'Dim TestNumber
'Dim TestIndex
'Dim SetIndex

'debug
'WScript.Echo "ArgObj.Count: " & ArgObj.Count
'For TestIndex = 0 to ArgObj.Count - 1
'	WScript.Echo "ArgObj.Item(" & TestIndex & "): " & ArgObj.Item(TestIndex)
'Next

	EnumPathsOnly = False
	EnumAllData   = False

	If UCase (EnumOption) = PathOnlyOption Then
		EnumPathsOnly = True
	Elseif UCase (EnumOption) = AllDataOption Then
		EnumAllData = True
	End if

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

'debug 
'WScript.Echo "EnumPathsOnly: " & EnumPathsOnly
'WScript.Echo "EnumAllData: " & EnumAllData
'WScript.Echo "ObjectPath: " & ObjectPath
'WScript.Quit (Err.Number)

	IIsObjectPath = "IIS://" & MachineName
	If (ObjectPath <> "") Then 
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If
'debug
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error Trying To ENUM the Object (GetObject Failed): " & ObjectPath
		'WScript.Quit (Err.Number)
		Exit Function
	End If

	' Get the Schema of the object and enumerate through all of the properties
	IIsSchemaPath = IIsObject.Schema
	Set IIsSchemaObject = GetObject (IIsSchemaPath)

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error Trying To GET the Schema of the property: " & IIsSchemaPath
		'WScript.Quit (Err.Number)
		Exit Function
	End If

	Redim PropertyListSet (1)
	PropertyListSet(0) = IIsSchemaObject.MandatoryProperties
	PropertyListSet(1) = IIsSchemaObject.OptionalProperties

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error trying to get the list of properties: " & IIsSchemaPath
		'WScript.Quit (Err.Number)
		Exit Function
	End If

	If (Not EnumPathsOnly) Then
	For Each PropertyList in PropertyListSet

		For Each PropertyName in PropertyList
			' Test to see if the property is even set at this node
			DataPathList = IIsObject.GetDataPaths (PropertyName, IIS_DATA_INHERIT)
			If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths (PropertyName, IIS_DATA_NO_INHERIT)
			Err.Clear

			If (UBound (DataPathList) >= 0) Or (EnumAllData)Then
			 DataPath = DataPathList (0)
			 SanitizePath DataPath
			 If (UCase (DataPath) = UCase (IIsObjectPath)) Or (EnumAllData) Then
			 ' If the above statement is true, then the data exists here or the user wants it anyway.

			PropertyObjPath = "IIS://" & MachineName & "/Schema/" & PropertyName
			Set PropertyObject = GetObject (PropertyObjPath)

			If (Err.Number <> 0) Then
				WScript.Echo
				ReportError ()
				WScript.Echo "Error trying to enumerate the Optional properties (Couldn't Get Property Information): " & PropertyObjPath
				WScript.Echo "Last Property Name: " & PropertyName
				WScript.Echo "PropertyObjPath: " & PropertyObjPath
				'WScript.Quit (Err.Number)
				WScript.Echo
				EnumCommandParam = Err.Number
				Err.Clear
			End If

			ValueList = ""

			PropertyDataType = UCase (PropertyObject.Syntax)
			Select Case PropertyDataType
				Case "STRING"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ")" & """" & ValueList & """"
					End If
				Case "EXPANDSZ"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") """ & ValueList & """"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") """ & ValueList & """"
					End If
				Case "INTEGER"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") " & ValueList
					End If
				Case "BOOLEAN"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ") " & ValueList
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ") " & ValueList
					End If

				Case "LIST"
					ValueList = IIsObject.Get (PropertyName)
					If (Len(PropertyName) < SpacerSize) Then
						WScript.Echo PropertyName & Left (Spacer, Len (Spacer) - Len (PropertyName)) & ": " & "(" & PropertyDataType & ")"
					Else
						WScript.Echo PropertyName &  " : " & "(" & PropertyDataType & ")"
					End If
					ValueString = ""

					For ValueIndex = 0 to UBound (ValueList)
						ValueString = ValueString & """" & ValueList (ValueIndex) & """"
						If ValueIndex < UBound (ValueList) Then
							ValueString = ValueString & ", "
						End If
					Next
					WScript.Echo "   " & ValueString

				Case Else

					If (IsSpecialGetProperty (PropertyName)) Then

						SpecialResult = DoSpecialGetProp (ObjectPath, PropertyName, MachineName)
						Err.Clear

					Else
						WScript.Echo
						WScript.Echo "DataType: " & """" & PropertyObject.Syntax & """" & " Not Yet Supported on property: " & PropertyName
						ReportError
						WScript.Echo
					End If

			End Select

			 End If ' End if data exists at the current node
			End If ' End If data list > 0

			If (Err.Number <> 0) Then
				WScript.Echo
				ReportError ()
				WScript.Echo "Error trying to enumerate the Optional properties (Error trying to get property value): " & PropertyObjPath
				WScript.Echo "Last Property Name: " & PropertyName
				WScript.Echo "PropertyObjPath: " & PropertyObjPath
				' If there is an ADS error, just ignore it and move on
				' otherwise, quit
				if ((Err.Number) >= &H80005000) And ((Err.Number) < &H80006000) then
					Err.Clear
					WScript.Echo "Continuing..."
				Else
					'WScript.Quit (Err.Number)
					Exit Function
				End If
				WScript.Echo
			End If
		Next
	Next

	End If ' End if (Not EnumPathsOnly)

	' Now, enumerate the data paths
	For Each ChildObject in IIsObject
		ChildObjectName = Right (ChildObject.Adspath, Len (ChildObject.AdsPath) - 6)
		ChildObjectName = Right (ChildObjectName, Len (ChildObjectName) - InStr (ChildObjectName, "/") + 1)
		WScript.Echo "[" & ChildObjectName & "]"
	Next

End Function

''''''''''''''''''''''''''
' Create Function
' Creates a path in the metabase.  An additional parameter that is 
' not found in mdutil is optional.  That is the Object Type (KeyType)
' If this is not specified, the object type will be assumed to be
' IIsObject (which, of course, is useless).
''''''''''''''''''''''''''
Function CreateCommand(ObjectTypeParam)

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim IIsObjectRelativePath
	Dim NewObject
	Dim ObjectTypeName
	Dim ParentObjPath
	Dim ParentObjSize
	Dim FullAdsParentPath
	Dim MachineName
	Dim OpenErr

	' Set the return code - assume success
	CreateCommand = 0

	' Setup the parameters
	If (ArgObj.Count = 2) Then
		If (ObjectTypeParam = "") Then
			ObjectTypeName = "IIsObject"
		Else
			ObjectTypeName = ObjectTypeParam
		End If
	ElseIf (ArgObj.Count = 3) Then
		ObjectTypeName = ArgObj.Item(2)
	Else
		WScript.Echo "Error: Wrong number of Args for the CREATE command"
		DisplayHelpMessage
		WScript.Quit (GENERAL_FAILURE)
	End If

	IIsObjectPath = ArgObj.Item (1)
	SanitizePath IIsObjectPath
	MachineName = SeparateMachineName (IIsObjectPath)

	' Parse the path and determine if the parent exists.
	ParentObjSize = InStrRev (IIsObjectPath, "/")
	ParentObjPath = ""

	If ParentObjSize <> 0 Then
		ParentObjPath = Left (IIsObjectpath, ParentObjSize - 1)
		IIsObjectRelativePath = Right (IIsObjectPath, Len (IIsObjectPath) - ParentObjSize)
	Else
		IIsObjectRelativePath = IIsObjectPath 
	End if

	If ParentObjPath <> "" Then
		FullAdsParentPath = "IIS://" & MachineName & "/" & ParentObjPath
	Else
		FullAdsParentPath = "IIS://" & MachineName
	End If
'debug
'WScript.Echo "Last Error: " & Err.Number
'WScript.Echo "MachineName: " & MachineName
'WScript.Echo "ParentObjPath: " & ParentObjPath
'WScript.Echo "FullAdsParentPath: " & FullAdsParentPath
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
'WScript.Echo "IIsObjectRelativePath: " & IIsObjectRelativePath
'WScript.Echo "ObjectTypeName: " & ObjectTypeName

	' First, attempt to open the parent path and add the new path.
	Set IIsObject = GetObject (FullAdsParentPath)
	if Err.Number <> 0 then
		OpenErr = Err.Number
		OpenErrDesc = Err.Description
		Err.Clear
		' Attempt to get the Computer Object (IIS://LocalHost)
		Set IIsObject = GetObject ("IIS://" & MachineName)
		If Err.Number <> 0 Then
			WScript.Echo
			ReportError ()
			WScript.Echo "Error accessing the object: " & IIsObjectPath
			WScript.Quit(Err.Number)
		End If
	End If

	'Now, attempt to add the new object.
	If (OpenErr <> 0) Then
		Set NewObject = IIsObject.Create (ObjectTypeName, IIsObjectPath)
	Else
		Set NewObject = IIsObject.Create (ObjectTypeName, IIsObjectRelativePath)
	End If

	If Err.Number <> 0 Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error creating the object: " & IIsObjectPath
		WScript.Quit(Err.Number)
	End If

	NewObject.SetInfo

	If Err.Number <> 0 Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error creating the object: " & IIsObjectPath
		WScript.Quit(Err.Number)
	End If


	' Now, if the parent object was not created, generate a warning.
	If OpenErr <> 0 Then
		WScript.Echo
		WScript.Echo "WARNING: The parent path (" & ParentObjPath & ") was not already created."
		WScript.Echo "    This means that some of the intermediate objects will not have an accurate"
		WScript.Echo "    Object Type. You should fix this by setting the KeyType on the intermediate"
		WScript.Echo "    objects."
		WScript.Echo
		CreateCommand = GENERAL_WARNING
	End If

	If UCase(ObjectTypeName) = "IISOBJECT" Then
		WScript.Echo
		WScript.Echo "WARNING: The Object Type of this object was not specified or was specified as"
		WScript.Echo "    IIsObject.  This means that you will not be able to set or get properties"
		WScript.Echo "    on the object until the KeyType property is set."
		WScript.Echo
		CreateCommand = GENERAL_WARNING
	End If

	WScript.Echo "created """ & IIsObjectPath & """"
End Function

'CreateCommand using parameters.
Function CreateCommandParam(IIsObjectPath,ObjectTypeName)

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectRelativePath
	Dim NewObject
	Dim ParentObjPath
	Dim ParentObjSize
	Dim FullAdsParentPath
	Dim MachineName
	Dim OpenErr

	' Set the return code - assume success
	CreateCommandParam = 0

	SanitizePath IIsObjectPath
	MachineName = SeparateMachineName (IIsObjectPath)

	' Parse the path and determine if the parent exists.
	ParentObjSize = InStrRev (IIsObjectPath, "/")
	ParentObjPath = ""

	If ParentObjSize <> 0 Then
		ParentObjPath = Left (IIsObjectpath, ParentObjSize - 1)
		IIsObjectRelativePath = Right (IIsObjectPath, Len (IIsObjectPath) - ParentObjSize)
	Else
		IIsObjectRelativePath = IIsObjectPath 
	End if

	If ParentObjPath <> "" Then
		FullAdsParentPath = "IIS://" & MachineName & "/" & ParentObjPath
	Else
		FullAdsParentPath = "IIS://" & MachineName
	End If
'debug
'WScript.Echo "Last Error: " & Err.Number
'WScript.Echo "MachineName: " & MachineName
'WScript.Echo "ParentObjPath: " & ParentObjPath
'WScript.Echo "FullAdsParentPath: " & FullAdsParentPath
'WScript.Echo "IIsObjectPath: " & IIsObjectPath
'WScript.Echo "IIsObjectRelativePath: " & IIsObjectRelativePath
'WScript.Echo "ObjectTypeName: " & ObjectTypeName

	' First, attempt to open the parent path and add the new path.
	Set IIsObject = GetObject (FullAdsParentPath)
	if Err.Number <> 0 then
		OpenErr = Err.Number
		OpenErrDesc = Err.Description
		Err.Clear
		' Attempt to get the Computer Object (IIS://LocalHost)
		Set IIsObject = GetObject ("IIS://" & MachineName)
		If Err.Number <> 0 Then
			WScript.Echo
			ReportError ()
			WScript.Echo "Error accessing the object: " & IIsObjectPath
			WScript.Quit(Err.Number)
		End If
	End If

	'Now, attempt to add the new object.
	If (OpenErr <> 0) Then
		Set NewObject = IIsObject.Create (ObjectTypeName, IIsObjectPath)
	Else
		Set NewObject = IIsObject.Create (ObjectTypeName, IIsObjectRelativePath)
	End If

	If Err.Number <> 0 Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error creating the object: " & IIsObjectPath
		WScript.Quit(Err.Number)
	End If

	NewObject.SetInfo

	If Err.Number <> 0 Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error creating the object: " & IIsObjectPath
		WScript.Quit(Err.Number)
	End If


	' Now, if the parent object was not created, generate a warning.
	If OpenErr <> 0 Then
		WScript.Echo
		WScript.Echo "WARNING: The parent path (" & ParentObjPath & ") was not already created."
		WScript.Echo "    This means that some of the intermediate objects will not have an accurate"
		WScript.Echo "    Object Type. You should fix this by setting the KeyType on the intermediate"
		WScript.Echo "    objects."
		WScript.Echo
		CreateCommandParam = GENERAL_WARNING
	End If

	If UCase(ObjectTypeName) = "IISOBJECT" Then
		WScript.Echo
		WScript.Echo "WARNING: The Object Type of this object was not specified or was specified as"
		WScript.Echo "    IIsObject.  This means that you will not be able to set or get properties"
		WScript.Echo "    on the object until the KeyType property is set."
		WScript.Echo
		CreateCommandParam = GENERAL_WARNING
	End If

	WScript.Echo "created """ & IIsObjectPath & """"
End Function

''''''''''''''''''''''''''
'
' Delete Function
'
' Deletes a path in the metabase.
'
''''''''''''''''''''''''''
Function DeleteCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath

	Dim ObjectPath
	Dim ObjectParam
	Dim MachineName

	Dim DummyVariant
	Dim DeletePathOnly
	Redim DummyVariant (0)
	DummyVariant (0) = "Crap"

	' Set the return code - assume success
	DeleteCommand = 0

	' Setup the parameters
	If (ArgObj.Count <> 2) Then
		WScript.Echo "Error: Wrong number of Args for the DELETE command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)

	' Check and see if the user is specifically asking to delete the path
	DeletePathOnly = False
	If Right (ObjectPath, 1) = "/" Then
		DeletePathOnly = True
	End If

	' Sanitize the path and split parameter and path
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParam = SplitParam (ObjectPath)

	' Open the parent object
	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	if Err.Number <> 0 then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error deleting the object: " & ObjectPath & "/" & ObjectParam
		WScript.Quit(Err.Number)
	End If

	' If they did not specifically ask to delete the path, then attempt to delete the property
	If Not DeletePathOnly Then
		' Try to delete the property

		' ADS_PROPERTY_CLEAR used to be defined, but it isn't anymore.
		'IIsObject.PutEx ADS_PROPERTY_CLEAR, ObjectParam, DummyVariant
		IIsObject.PutEx "1", ObjectParam, DummyVariant

		' If it succeeded, then just return, else continue and try to delete the path
		if Err.Number = 0 then
			WScript.Echo "deleted property """ & ObjectParam & """"
			Exit Function
		End If
		Err.Clear
	End If

	' Try to just delete the path
	IIsObject.Delete "IIsObject", ObjectParam

	if Err.Number <> 0 then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error deleting the object: " & ObjectPath & "/" & ObjectParam
		WScript.Quit(Err.Number)
	End If

	WScript.Echo "deleted path """ & ObjectPath & "/" & ObjectParam & """"

	Exit Function

End Function


''''''''''''''''''''''''''
'
' EnumAllCommand
'
' Enumerates all data and all properties in the metabase under the current path.
'
''''''''''''''''''''''''''
Function EnumAllCommand ()
	On Error Resume Next

	WScript.Echo "ENUM_ALL Command not yet supported"

End Function


''''''''''''''''''''''''''
'
' CopyMoveCommand
'
' Copies a path in the metabase to another path.
'
''''''''''''''''''''''''''
Function CopyMoveCommand (bCopyFlag)
	On Error Resume Next

	Dim SrcObjectPath
	Dim DestObjectPath
	Dim DestObject

	Dim ParentObjectPath
	Dim ParentRelativePath
	Dim ParentObject

	Dim MachineName

	Dim TmpDestLeftPath
	Dim TmpSrcLeftPath

	CopyMoveCommand = 0 ' Assume Success

	If ArgObj.Count <> 3 Then
		WScript.Echo "Error: Wrong number of Args for the Copy/Move command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	SrcObjectPath = ArgObj.Item (1)
	DestObjectPath = ArgObj.Item (2)

	SanitizePath SrcObjectPath
	SanitizePath DestObjectPath
	MachineName = SeparateMachineName (SrcObjectPath)
	ParentObjectPath = "IIS://" & MachineName

	' Extract the left part of the paths until there are no more left parts to extract
	Do
		TmpSrcLeftPath = SplitLeftPath (SrcObjectPath)
		TmpDestLeftPath = SplitLeftPath (DestObjectPath)

		If (SrcObjectPath = "") Or (DestObjectPath = "") Then
			SrcObjectPath = TmpSrcLeftPath & "/" & SrcObjectPath
			DestObjectPath = TmpDestLeftPath & "/" & DestObjectPath
			Exit Do
		End If

		If (TmpSrcLeftPath <> TmpDestLeftPath) Then
			SrcObjectPath = TmpSrcLeftPath & "/" & SrcObjectPath
			DestObjectPath = TmpDestLeftPath & "/" & DestObjectPath
			Exit Do
		End If

		ParentObjectPath = ParentObjectPath & "/" & TmpSrcLeftPath
		ParentRelativePath = ParentRelativePath & "/" & TmpSrcLeftPath

	Loop

	SanitizePath SrcObjectPath
	SanitizePath DestObjectPath
	SanitizePath ParentObjectPath

	' Now, open the parent object and Copy/Move the objects
	Set ParentObject = GetObject (ParentObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to open the object: " & ParentObjectPath
		WScript.Quit (Err.Number)
	End If

	If (bCopyFlag) Then
		Set DestObject = ParentObject.CopyHere (SrcObjectPath, DestObjectPath)
	Else
		Set DestObject = ParentObject.MoveHere (SrcObjectPath, DestObjectPath)
	End If

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to Copy/Move Source to Dest."
		WScript.Quit (Err.Number)
	End If

	If (bCopyFlag) Then
		WScript.Echo "copied from " & ParentRelativePath & "/" & SrcObjectPath & " to " & ParentRelativePath & "/" & DestObjectPath
	Else
		WScript.Echo "moved from " & ParentRelativePath & "/" & SrcObjectPath & " to " & ParentRelativePath & "/" & DestObjectPath
	End If

End Function

''''''''''''''''''''''''''
'
' StartServerCommand
'
' Starts a server in the metabase.
'
''''''''''''''''''''''''''
Function StartServerCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName
	Dim FunctionName

	FunctionName = "StartServerCommand"
	StartServerCommand = 0 ' Assume Success.

	If ArgObj.Count <> 2  Then
		message "Error", False, FunctionName & ": Wrong number of Args for the START_SERVER command"
		StartServerCommand = GENERAL_FAILURE
		Exit Function
	End If

	ObjectPath = ArgObj.Item (1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		message "Error", True, FunctionName & ": trying to open the object: " & ObjectPath
		StartServerCommand = GENERAL_FAILURE
		Exit Function
	End If

	IIsObject.Start
	If (Err.Number <> 0) Then
		message "Error", True, FunctionName & ": trying to START the server: " & ObjectPath
		StartServerCommand = GENERAL_FAILURE
		Exit Function
	End If
	message "Info", False, "Server " & ObjectPath & " Successfully STARTED"

End Function

' StartServerCommand with parameters.
Function StartServerCommandParam(ObjectPath)

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim MachineName

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to open the object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	Err.Clear
	IIsObject.Start
	If (Err.Number <> 0) Then
		Message "Error", True, "Error trying to START the server: " & ObjectPath
		if (Err.Number = &h1B6) Then '  Determined empirically
			Message "Error", False, "This error may be a result of not having the"
			Message "Error", False, """World Wide Web Publishing Service"" (W3SVC) service running"
			Message "Error", False, "when attempting to start the webserver."
		End If
		if (Err.Number = &h8007041D) Then ' Determined empirically
			Message "Error", False, "This error may be caused by having another webserver started on"
			Message "Error", False, "Windows NT Workstation. Windows NT Workstation only supports ONE"
			Message "Error", False, "running webserver."
		End If
		StartServerCommandParam = GENERAL_FAILURE
		Exit Function
	End If
	Message "Info", False, "Server " & ObjectPath & " Successfully STARTED"

End Function

''''''''''''''''''''''''''
'
' StopServerCommand
'
' Stops a server in the metabase.
'
''''''''''''''''''''''''''
Function StopServerCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	If ArgObj.Count <> 2  Then
		WScript.Echo "Error: Wrong number of Args for the STOP_SERVER command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to open the object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.Stop
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to STOP the server: " & ObjectPath
		WScript.Quit (Err.Number)
	End If
	Message "Info", False, "Server " & ObjectPath & " Successfully STOPPED"

End Function

' Identical to StopServerCommand but with parameters.
Function StopServerCommandParam(ObjectPath)

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim MachineName

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Err.Clear
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		Message "Error", True, "Trying to open the object: " & ObjectPath
		StopServerCommandParam = GENERAL_FAILURE
		Exit Function
	End If

	Err.Clear
	IIsObject.Stop
	If (Err.Number <> 0) Then
		Message "Error", True, "Trying to STOP the server: " & ObjectPath
		StopServerCommandParam = GENERAL_FAILURE
		Exit Function
	End If
	Message "Info", False, "Server " & ObjectPath & " Successfully STOPPED"

End Function

''''''''''''''''''''''''''
' StopWServerAllCommand
' Stops ALL web servers in the metabase.
''''''''''''''''''''''''''
Function StopWServerAllCommand()

	On Error Resume Next
	Dim Return

	StopWServerAllCommand = 0 ' Assume success

	If ArgObj.Count <> 1  Then
		Message "Error", False, "Wrong number of Args for the STOP_WSERVER_ALL command"
		Exit Function
	End If

	Return = StopWServerAllCommandParam()
	StopWServerAllCommand = Return

End Function

''''''''''''''''''''''''''
' StopWServerAllCommandParam
' Stops ALL web servers in the metabase.
'   No parameters, since we know who to stop, ALL WEBSERVERS, HEHE!
''''''''''''''''''''''''''
Function StopWServerAllCommandParam()

	On Error Resume Next

	Dim IIsObjectPath
	Dim IIsObject
	Dim ChildObject
	Dim ChildObjectName

	IIsObjectPath = "IIS://LocalHost/W3SVC"
	Err.Clear
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		WScript.Echo
		ReportError ()
		WScript.Echo "Error Trying To ENUM the Object (GetObject Failed): " & IIsObjectPath
		Exit Function
	End If

	' Now, enumerate the data paths
	For Each ChildObject in IIsObject
		' Chop leading leading 6 characters, presumably "IIS://"
		ChildObjectName = Right (ChildObject.Adspath, Len (ChildObject.AdsPath) - 6)
                ' Chop characters before first "/", presumably the machine name.
		ChildObjectName = Right (ChildObjectName, Len (ChildObjectName) - InStr (ChildObjectName, "/") + 1)
		' Chop the leading character, presumably "/"
		ChildObjectName = Right (ChildObjectName, Len (ChildObjectName) - 1)

		if ( ChildObject.KeyType = "IIsWebServer" ) then
			StopServerCommandParam ChildObjectName
		End If
	Next
End Function

''''''''''''''''''''''''''
'
' PauseServerCommand
'
' Pauses a server in the metabase.
'
''''''''''''''''''''''''''
Function PauseServerCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	If ArgObj.Count <> 2  Then
		WScript.Echo "Error: Wrong number of Args for the PAUSE_SERVER command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to open the object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.Pause
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to PAUSE the server: " & ObjectPath
		WScript.Quit (Err.Number)
	End If
	WScript.Echo "Server " & ObjectPath & " Successfully PAUSED"

End Function

''''''''''''''''''''''''''
'
' ContinueServerCommand
'
' Continues a server in the metabase.
'
''''''''''''''''''''''''''
Function ContinueServerCommand()

	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	If ArgObj.Count <> 2  Then
		WScript.Echo "Error: Wrong number of Args for the CONTINUE_SERVER command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to open the object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.Continue
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to CONTINUE the server: " & ObjectPath
		WScript.Quit (Err.Number)
	End If
	WScript.Echo "Server " & ObjectPath & " Successfully CONTINUED"

End Function


Function FindData ()
	' FindData will accept 1 parameter from the command line - the node and 
	' property to search for (i.e. W3SVC/1/ServerComment)

	On Error Resume Next

	Dim ObjectPath
	Dim ObjectParameter
	Dim NewObjectparameter
	Dim MachineName

	Dim IIsObjectpath
	Dim IIsObject

	Dim Path
	Dim PathList
	Dim I

	FindData = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the FIND_DATA command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item (1)

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)
	ObjectParameter = SplitParam (ObjectPath)

	' Since people may still want to use MDUTIL parameter names
	' we should still do the GET translation of parameter names.
	NewObjectParameter = MapSpecGetParamName (ObjectParameter)
	ObjectParameter = NewObjectParameter

	If ObjectPath = "" Then
		IIsObjectPath = "IIS://" & MachineName
	Else
		IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to find data paths for the Object (GetObject Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Now, list out all the places where this property exists.
	PathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_INHERIT)
	If Err.Number <> 0 Then PathList = IIsObject.GetDataPaths (ObjectParameter, IIS_DATA_NO_INHERIT)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get a path list (GetDataPaths Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	If UBound (PathList) < 0 then
		WScript.Echo "Property " & ObjectParameter & " was not found at any node beneath " & ObjectPath
	Else
		WScript.Echo "Property " & ObjectParameter & " found at:"

		For Each Path in PathList
			Path = Right (Path, Len(Path) - 6)
			Path = Right (Path, Len(Path) - InStr (Path,"/"))
			WScript.Echo "  " & Path
		Next
	End If

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error listing the data paths (_newEnum Failed): " & ObjectPath
		WScript.Quit (Err.Number)
	End If

End Function	

'''''''''''''''''''''
' 
' MimeMapGet
'
' Special function for displaying a MimeMap property
'
'''''''''''''''''''''
Function MimeMapGet(ObjectPath, MachineName)
	On Error Resume Next

	Dim MimePath

	Dim MimeMapList
	Dim MimeMapObject
	Dim MimeEntry
	Dim MimeEntryIndex

	Dim MimeStr
	Dim MimeOutPutStr

	Dim DataPathList
	Dim DataPath

	MimeMapGet = 0 ' Assume Success

	MimePath = "IIS://" & MachineName
	If ObjectPath <> "" Then MimePath = MimePath & "/" & ObjectPath

	' Get the object that contains the mimemap
	Set MimeMapObject = GetObject (MimePath)
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the Object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Test to see if the property is ACTUALLY set at this node
	DataPathList = MimeMapObject.GetDataPaths ("MimeMap", IIS_DATA_INHERIT)
	If Err.Number <> 0 Then DataPathList = IIsObject.GetDataPaths (MimeMap, IIS_DATA_NO_INHERIT)
	Err.Clear

	' If the data is not set anywhere, then stop the madness
	If (UBound (DataPathList) < 0) Then
		MimeMapGet =  &h80005006 ' end with property not set error
		Exit Function
	End If

	DataPath = DataPathList (0)
	SanitizePath DataPath

	' Test to see if the item is actually set HERE
	If UCase (DataPath) <> UCase (MimePath) Then
		MimeMapGet =  &h80005006 ' end with property not set error
		Exit Function
	End If

	' Get the mime map list from the object
	MimeMapList = MimeMapObject.Get ("MimeMap")
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the Object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	MimeOutPutStr = "MimeMap                         : (MimeMapList) "

	' Enumerate the Mime Entries
	For MimeEntryIndex = 0 to UBound (MimeMapList)
		Set MimeEntry = MimeMapList (MimeEntryIndex)
		MimeOutPutStr = MimeOutPutStr & """" & MimeEntry.Extension & "," & MimeEntry.MimeType & """ "
	Next

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to Create the Mime Map List."
		WScript.Quit (Err.Number)
	End If

	WScript.Echo MimeOutPutStr

End Function



Function MimeMapSet(ObjectPath, ObjectParameter, MachineName)
	On Error Resume Next

	Dim MimePath

	Dim MimeEntryIndex
	Dim MimeMapList ()
	Dim MimeMapObject
	Dim MimeEntry

	Dim MimeStr
	Dim MimeOutPutStr

	MimeMapSet = 0 ' Assume Success

	' First, check the number of args
	If ArgObj.Count < 3 Then
		WScript.Echo "Error: Wrong number of Args for the Set MIMEMAP command"
		WScript.Quit (GENERAL_FAILURE)
	End If


	MimePath = "IIS://" & MachineName
	If ObjectPath <> "" Then MimePath = MimePath & "/" & ObjectPath

	' Get the object that contains the mimemap
	Set MimeMapObject = GetObject (MimePath)
	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the Object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	' Create a new MimeMapList of Mime Entries
	ReDim MimeMapList (ArgObj.Count - 3)

	MimeOutPutStr = "MimeMap                         : (MimeMapList) "

	' Fill the list with mime entries
	For MimeEntryIndex = 0 to UBound (MimeMapList)

		MimeStr = ArgObj.Item (2 + MimeEntryIndex)
		MimeOutPutStr = MimeOutPutStr & """" & MimeStr & """ "

		Set MimeEntry = CreateObject ("MimeMap")

		MimeEntry.MimeType = Right (MimeStr, InStr (MimeStr, ",") - 1)
		MimeEntry.Extension = Left (MimeStr, InStr (MimeStr, ",") - 1)

		Set MimeMapList (MimeEntryIndex) = MimeEntry
	Next

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to Create the Mime Map List."
		WScript.Quit (Err.Number)
	End If

	MimeMapObject.MimeMap = MimeMapList
	MimeMapObject.SetInfo

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying to set the Object's ""MimeMap"" property to the new mimemap list."
		WScript.Quit (Err.Number)
	End If

	WScript.Echo MimeOutPutStr

End Function

''''''''''''''''''''''''''
'
' IsSpecialGetProperty
'
' Checks to see if the property requires special processing in order to 
' display its contents.
'
''''''''''''''''''''''''''
Function IsSpecialGetProperty (ObjectParameter)

	On Error Resume Next

	Select Case UCase(ObjectParameter)
		Case "MIMEMAP"
			IsSpecialGetProperty = True
		Case Else
			IsSpecialGetProperty = False
	End Select

End Function

''''''''''''''''''''''''''
'
' DoSpecialGetProp
'
' Checks to see if the property requires special processing in order to 
' display its contents.
'
''''''''''''''''''''''''''
Function DoSpecialGetProp (ObjectPath, ObjectParameter, MachineName)

	On Error Resume Next

	Select Case UCase(ObjectParameter)
		Case "MIMEMAP"
			DoSpecialGetProp = MimeMapGet(ObjectPath, MachineName)
		Case Else
			DoSpecialGetProp = False
	End Select

End Function



''''''''''''''''''''''''''
'
' IsSpecialSetProperty
'
' Checks to see if the property is a type that needs to be handled
' specially for compatibility with mdutil
'
''''''''''''''''''''''''''
Function IsSpecialSetProperty (ObjectParameter)

	On Error Resume Next

	Select Case UCase(ObjectParameter)
		Case "SERVERCOMMAND"
			IsSpecialSetProperty = True
		Case "ACCESSPERM"
			IsSpecialSetProperty = True
		Case "VRPATH"
			IsSpecialSetProperty = True
		Case "AUTHORIZATION"
			IsSpecialSetProperty = True
		Case "MIMEMAP"
			IsSpecialSetProperty = True
		Case Else
			IsSpecialSetProperty = False
	End Select
End Function

''''''''''''''''''''''''''
'
' DoSpecialSetProp
'
' Handles datatypes that need to be handled
' specially for compatibility with mdutil
'
''''''''''''''''''''''''''
Function DoSpecialSetProp (ObjectPath, ObjectParameter, MachineName)
	Dim IIsObjectPath
	Dim IIsObject
	Dim ValueList
	Dim ValueDisplay
	Dim PermIndex

	On Error Resume Next

	DoSpecialSetProp = 0 ' Assume Success
	Select Case UCase (ObjectParameter)
		Case "SERVERCOMMAND"

			IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
			Set IIsObject = GetObject (IIsObjectPath)

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Get the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			ValueList = CLng(ArgObj.Item (2))
			Select Case ValueList
				Case 1
					IIsObject.Start
					If (Err.Number <> 0) Then
						ReportError ()
						WScript.Echo "Error Trying To Start the server: " & ObjectPath
						WScript.Quit (Err.Number)
					End If
					WScript.Echo "Server " & ObjectPath & " Successfully STARTED"
				Case 2
					IIsObject.Stop
					If (Err.Number <> 0) Then
						ReportError ()
						WScript.Echo "Error Trying To Stop the server: " & ObjectPath
						WScript.Quit (Err.Number)
					End If
					WScript.Echo "Server " & ObjectPath & " Successfully STOPPED"
				Case 3
					IIsObject.Pause
					If (Err.Number <> 0) Then
						ReportError ()
						WScript.Echo "Error Trying To Pause the server: " & ObjectPath
						WScript.Quit (Err.Number)
					End If
					WScript.Echo "Server " & ObjectPath & " Successfully PAUSED"
				Case 4
					IIsObject.Continue
					If (Err.Number <> 0) Then
						ReportError ()
						WScript.Echo "Error Trying To Continue the server: " & ObjectPath
						WScript.Quit (Err.Number)
					End If
					WScript.Echo "Server " & ObjectPath & " Successfully Continued"
				Case Else
					WScript.Echo "Invalid ServerCommand: " & ValueList
					DoSpecialSetProp = GENERAL_FAILURE
			End Select
			Exit Function

		Case "ACCESSPERM"
			IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
			Set IIsObject = GetObject (IIsObjectPath)

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Get the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Set the access flags to None, first, and then add them back, as necessary
			IIsObject.AccessFlags = 0

			' Set up the display output
			ValueDisplay = "AccessFlags (AccessPerm)" & (Right (Spacer, SpacerSize - Len("AccessFlags (AccessPerm)")) & ": " & "(" & TypeName (IIsObject.AccessFlags) & ") ")

			' Attempt to convert parameter to number
			Dim APValue
			Dim TempValStr

			TempValStr = ArgObj.Item(2)

			' Check for Hex
			If (UCASE(Left (ArgObj.Item(2), 2)) = "0X") Then
				TempValStr = "&H" & Right (TempValStr, Len (TempValStr) - 2)
			End If

			APValue = CLng (TempValStr)

			If (Err.Number = 0) Then
				IIsObject.AccessFlags = APValue
				ValueDisplay = ValueDisplay & " " & APValue & " (0x" & Hex(APValue) & ")"
			Else
				Err.Clear
				For PermIndex = 2 to ArgObj.Count - 1
					Select Case UCase (ArgObj.Item (PermIndex))
						Case "READ"
							IIsObject.AccessRead = True
							ValueDisplay = ValueDisplay & " Read"
						Case "WRITE"
							IIsObject.AccessWrite = True
							ValueDisplay = ValueDisplay & " Write"
						Case "EXECUTE"
							IIsObject.AccessExecute = True
							ValueDisplay = ValueDisplay & " Execute"
						Case "SCRIPT"
							IIsObject.AccessScript = True
							ValueDisplay = ValueDisplay & " Script"
						Case Else
							WScript.Echo "Error: Setting not supported: " & ArgObj.Item (PermIndex)
							WScript.Quit (GENERAL_FAILURE)
					End Select
				Next
			End If

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			IIsObject.Setinfo

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Send the current settings to the screen
			WScript.Echo ValueDisplay

		Case "VRPATH"
			IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
			Set IIsObject = GetObject (IIsObjectPath)

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Get the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Set the access flags to None, first, and then add them back, as necessary
			IIsObject.Path = ArgObj.Item (2)

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Set up the display output
			ValueDisplay = "Path (VRPath)" & (Right (Spacer, SpacerSize - Len("Path (VRPath)")) & ": " & "(" & TypeName (IIsObject.Path) & ") " & IIsObject.Path)

			IIsObject.Setinfo

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Send the current settings to the screen
			WScript.Echo ValueDisplay

		Case "AUTHORIZATION"
			IIsObjectPath = "IIS://" & MachineName & "/" & ObjectPath
			Set IIsObject = GetObject (IIsObjectPath)

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Get the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Set the auth flags to None, first, and then add them back, as necessary
			IIsObject.AuthFlags = 0

			' Set up the display output
			ValueDisplay = "Authorization" & (Right (Spacer, SpacerSize - Len("Authorization")) & ": " & "(" & TypeName (IIsObject.AuthFlags) & ") ")

			For PermIndex = 2 to ArgObj.Count - 1
				Select Case UCase (ArgObj.Item (PermIndex))
					Case "NT"
						IIsObject.AuthNTLM = True
						ValueDisplay = ValueDisplay & " NT"
					Case "ANONYMOUS"
						IIsObject.AuthAnonymous = True
						ValueDisplay = ValueDisplay & " Anonymous"
					Case "BASIC"
						IIsObject.AuthBasic = True
						ValueDisplay = ValueDisplay & " Basic"
					Case Else
						WScript.Echo "Error: Setting not supported: " & ArgObj.Item (PermIndex)
						WScript.Quit (GENERAL_FAILURE)
				End Select
			Next

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			IIsObject.Setinfo

			If (Err.Number <> 0) Then
				ReportError ()
				WScript.Echo "Error Trying To Set data on the Object: " & ObjectPath
				WScript.Quit (Err.Number)
			End If

			' Send the current settings to the screen
			WScript.Echo ValueDisplay

		Case "MIMEMAP"
			DoSpecialSetProp = MimeMapSet(ObjectPath, ObjectParameter, MachineName)
'		Case "FILTER"
'			DoSpecialSetProp = FiltersSet()
		Case Else
			DoSpecialSetProp = GENERAL_FAILURE
	End Select
End Function

''''''''''''''''''''''''''''''
'
' Function SeparateMachineName
'
' This function will get the machine name from the Path parameter
' that was passed into the script.  It will also alter the passed in
' path so that it contains only the rest of the path - not the machine 
' name.  If there is no machine name in the path, then the script
' will assume LocalHost.
'
''''''''''''''''''''''''''''''	
Function SeparateMachineName (Path)
	On Error Resume Next

	' Temporarily, just return LocalHost
	SeparateMachineName = "LocalHost"

	Exit Function
End Function

''''''''''''''''''''''''''''''
'
' Function MapSpecGetParamName
'
' Some parameters in MDUTIL are named differently in ADSI.
' This function maps the improtant parameter names to ADSI
' names.
'
''''''''''''''''''''''''''''''	
Function MapSpecGetParamName (ObjectParameter)
	On Error Resume Next

	Select Case UCase(ObjectParameter)
		Case "ACCESSPERM"
			WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AccessFlags"
			WScript.Echo "      Check individual perms using ""GET AccessRead"", ""GET AccessWrite"", etc."
			MapSpecGetParamName = "AccessFlags"
		Case "VRPATH"
			'WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to PATH"
			MapSpecGetParamName = "Path"
		Case "AUTHORIZATION"
			WScript.Echo "Note: Your parameter """ & ObjectParameter & """ is being mapped to AuthFlags"
			WScript.Echo "      Check individual auths using ""GET AuthNTLM"", ""GET AuthBasic"", etc."
			MapSpecGetParamName = "AuthFlags"
		Case Else
			' Do nothing - the parameter doesn't map to anything special
			MapSpecGetParamName = ObjectParameter
	End Select
End Function

' Calls to ReportError need to be replaced with calls to Message "Error", True, ""
Sub ReportError ()
' DO NOT put an "On Error Resume Next" statement in this code. It will
'   clear the Err object information before we get a chance to print it out.

	Message "Error", True, ""

End Sub

' This routine is private to Message(). Do not call it directly!
Sub ReportErrObject(MsgTypePadded)
' DO NOT put an "On Error Resume Next" statement in this code. It will
'   clear the Err object information before we get a chance to print it out.
'indev - future other codes to add? Some are elsewhere in this file.

	Dim ErrorDescription, ErrorSource

	Select Case (Err.Number)
		Case &h80070003
			ErrorDescription = "The path requested could not be found."
		Case &h80070005
			ErrorDescription = "Access is denied for the requested path or property."
		Case &h80070094
			ErrorDescription = "The requested path is being used by another application."
		Case Else
			ErrorDescription = Err.Description
	End Select


	If (ErrorDescription <> "") Then
		WScript.Echo MsgTypePadded & ErrorDescription
	End If

	If (Err.Source <> "") Then
		ErrorSource = "Source: " & Err.Source & " "
	Else
		ErrorSource = ""
	End If

	WScript.Echo MsgTypePadded & ErrorSource & "Code: " & Err.Number & " (0x" & Hex(Err.Number) & ") "

End Sub

Function SplitParam (ObjectPath)
' Note: Assume the string has been sanitized (no leading or trailing slashes)
	On Error Resume Next

	Dim SlashIndex
	Dim TempParam
	Dim ObjectPathLen

	SplitParam = ""  ' Assume no parameter
	ObjectPathLen = Len (ObjectPath)

	' Separate the path of the node from the parameter
	SlashIndex = InStrRev (ObjectPath, "/")

	If (SlashIndex = 0) Or (SlashIndex = ObjectPathLen) Then
		TempParam = ObjectPath
		ObjectPath = "" ' ObjectParameter is more important
	Else
		TempParam = ObjectPath
		ObjectPath = Left (ObjectPath,  SlashIndex- 1)
		TempParam = Right (TempParam, Len (TempParam) - SlashIndex)
	End If

	SplitParam = TempParam

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to Split the parameter from the object: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

End Function



Function SplitLeftPath (ObjectPath)
' Note: Assume the string has been sanitized (no leading or trailing slashes)
	On Error Resume Next

	Dim SlashIndex
	Dim TmpLeftPath
	Dim ObjectPathLen

	SplitLeftPath = ""  ' Assume no LeftPath
	ObjectPathLen = Len (ObjectPath)

	' Separate the left part of the path from the remaining path
	SlashIndex = InStr (ObjectPath, "/")

	If (SlashIndex = 0) Or (SlashIndex = ObjectPathLen) Then
		TmpLeftPath = ObjectPath
		ObjectPath = ""
	Else
		TmpLeftPath = Left (ObjectPath,  SlashIndex- 1)
		ObjectPath = Right (ObjectPath, Len (ObjectPath) - SlashIndex)
	End If

	SplitLeftPath = TmpLeftPath

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to split the left part of the path: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

End Function


Sub SanitizePath (ObjectPath)
	On Error Resume Next

	' Remove WhiteSpace
	Do While (Left (ObjectPath, 1) = " ")
		ObjectPath = Right (ObjectPath, Len (ObjectPath) - 1)
	Loop

	Do While (Right (ObjectPath, 1) = " ")
		ObjectPath = Left (ObjectPath, Len (ObjectPath) - 1)
	Loop

	If Left (ObjectPath, 1) = "/" Then
		ObjectPath = Right (ObjectPath, Len (ObjectPath) - 1)
	End If

	If Right (ObjectPath, 1) = "/" Then
		ObjectPath = Left (ObjectPath, Len (ObjectPath) - 1)
	End If

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error Trying To Sanitize the path: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

End Sub


'''''''''''''''''''''''''''''
' AppCreateCommand
'''''''''''''''''''''''''''''
Function AppCreateCommand (InProcFlag)
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	AppCreateCommand = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the APPCREATE command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item(1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the path of the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.AppCreate (InProcFlag)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to create the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	WScript.Echo "Application Created."

End Function

' AppCreateCommand with parameters.
Function AppCreateCommandParam(ObjectPath, InProcFlag)
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim MachineName

	AppCreateCommandParam = 0 ' Assume Success

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the path of the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.AppCreate (InProcFlag)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to create the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	WScript.Echo "Application Created."

End Function

'''''''''''''''''''''''''''''
' AppDeleteCommand
'''''''''''''''''''''''''''''
Function AppDeleteCommand ()
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	AppDeleteCommand = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the APPDELETE command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item(1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the path of the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.AppDelete

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to DELETE the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	WScript.Echo "Application Deleted."

End Function

'''''''''''''''''''''''''''''
' AppDeleteCommandParam
'''''''''''''''''''''''''''''
Function AppDeleteCommandParam (ObjectPath)
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim MachineName
	Dim FunctionName

	FunctionName = "AppDeleteCommandParam"
	AppDeleteCommandParam = 0 ' Assume Success

	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Err.Clear
	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Trying to get the path of the application: " & ObjectPath
		AppDeleteCommandParam = GENERAL_FAILURE
		Exit Function
	End If

	Err.Clear
	IIsObject.AppDelete

	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Trying to DELETE the application: " & ObjectPath
		AppDeleteCommandParam = GENERAL_FAILURE
		Exit Function
	End If

	Message "Info", False, FunctionName & ": Application Deleted."

End Function ' AppDeleteCommandParam

'''''''''''''''''''''''''''''
' AppUnloadCommand
'''''''''''''''''''''''''''''
Function AppUnloadCommand ()
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName

	AppUnloadCommand = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the APPUNLOAD command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item(1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the path of the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	IIsObject.AppUnload

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to UNLOAD the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	WScript.Echo "Application Unloaded."

End Function


'''''''''''''''''''''''''''''
' AppGetStatusCommand
'''''''''''''''''''''''''''''
Function AppGetStatusCommand ()
	On Error Resume Next

	Dim IIsObject
	Dim IIsObjectPath
	Dim ObjectPath
	Dim MachineName
	Dim Status

	AppGetStatusCommand = 0 ' Assume Success

	If ArgObj.Count <> 2 Then
		WScript.Echo "Error: Wrong number of Args for the APPGETSTATUS command"
		WScript.Quit (GENERAL_FAILURE)
	End If

	ObjectPath = ArgObj.Item(1)
	SanitizePath ObjectPath
	MachineName = SeparateMachineName (ObjectPath)

	IIsObjectPath = "IIS://" & MachineName
	If ObjectPath <> "" Then
		IIsObjectPath = IIsObjectPath & "/" & ObjectPath
	End If

	Set IIsObject = GetObject (IIsObjectPath)

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to get the path of the application: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	Status = IIsObject.AppStatus

	If (Err.Number <> 0) Then
		ReportError ()
		WScript.Echo "Error trying to retrieve the application STATUS: " & ObjectPath
		WScript.Quit (Err.Number)
	End If

	WScript.Echo "Application Status: " & Status

End Function

		

'winnt\system32\inetsrv\adminsamples\mkw3site.vbs copied and changed below....

' Modified to return instead of quit on error conditions.
Sub ASTCreateWebSite(IPAddress, RootDirectory, ServerComment, HostName, PortNum, Computers, Start)
	Dim w3svc, WebServer, NewWebServer, NewDir, Bindings, BindingString, NewBindings, ComputerIndex, Index, SiteObj, bDone
	Dim comp
	Dim FunctionName
	On Error Resume Next

	FunctionName = "ASTCreateWebSite"
	For ComputerIndex = 0 To UBound(Computers)
		comp = Computers(ComputerIndex)
		If ComputerIndex <> UBound(Computers) Then
			Trace "Creating web site on " & comp & "."
		End If
'debug
'Wscript.echo  "IPAddress:        " & IPAddress
'Wscript.echo  "RootDirectory:    " & RootDirectory
'Wscript.echo  "ServerComment:    " & ServerComment 
'Wscript.echo  "HostName:         " & HostName 
'Wscript.echo  "PortNum:          " & PortNum
'Wscript.echo  "UBound(Computers) " & UBound(Computers)
'Wscript.echo  "Computers(0):     " & Computers(0)
'Wscript.echo  "Start:            " & Start
		' Grab the web service object
		Err.Clear
		Set w3svc = GetObject("IIS://" & comp & "/w3svc")
		If Err.Number <> 0 Then
			Display "Unable to open: "&"IIS://" & comp & "/w3svc"
		End If
		BindingString = IpAddress & ":" & PortNum & ":" & HostName
		Trace "Making sure this web server doesn't conflict with another..."
		For Each WebServer in w3svc
			If WebServer.Class = "IIsWebServer" Then
				Bindings = WebServer.ServerBindings
				If BindingString = Bindings(0) Then

					If (WebServer.ServerComment = ServerComment) Then
						' Found previous version of site we're trying to create??
						' InstallShield handles the re-install case by calling
						'   ESSENTIALSUNINSTALL first.
						Message "Error", False, FunctionName & ": The server bindings you specified are duplicated"
						Message "Error", False, "in another virtual web server with the same ServerComment """ & WebServer.ServerComment & """."
						Message "Error", False, """" & ServerComment & """ web virtual server already created / installed?"
						WScript.Quit (1)
					Else
						' Someone else has our bindings. Not for long... Take 'em
						Message "Warning", False, FunctionName & ": The server bindings """ & BindingString & """ you specified"
						Message "Warning", False, "are duplicated in the virtual web server """ & WebServer.ServerComment & """."
						Message "Warning", False, "The web virtual server """ & WebServer.ServerComment & """ will be stopped so that"
						Message "Warning", False, "the """ & ServerComment & """ web virtual server can assume its bindings."
						Message "Warning", False, "If you want to restart the virtual web server """ & WebServer.ServerComment & ""","
						Message "Warning", False, "change its bindings to a unique value with the"
						Message "Warning", False, "Internet Service Manager and then start it."
						WebServer.Stop
					End If

				End If
			End If
		Next

		Index = 1
		bDone = False
		Trace "Creating new web server..."

		' Test successive numbers under w3svc until an unoccupied slot is found
		While (Not bDone)
			Err.Clear
			Set SiteObj = GetObject("IIS://"&comp&"/w3svc/" & Index)
			If (Err.Number = 0) Then
				' A web server is already defined at this position so increment
				Index = Index + 1
			Else
				Err.Clear
				Set NewWebServer = w3svc.Create("IIsWebServer", Index)
				If (Err.Number <> 0) Then
					' If call to Create failed then try the next number
					Index = Index + 1
				Else
					Err.Clear
					' Verify that the newly created site can be retrieved
					Set SiteObj = GetObject("IIS://"&comp&"/w3svc/" & Index)
					If (Err.Number = 0) Then
						bDone = True
						Trace "Web server created. Path is - "&"IIS://"&comp&"/w3svc/" & Index
					Else
						Index = Index + 1
					End If
				End If
			End If

			' sanity check
			If (Index > 10000) Then
				Trace "Seem to be unable to create new web server.  Server number is "&Index&"."
				WScript.Quit (1)
			End If
		Wend

		NewBindings = Array(0)
		NewBindings(0) = BindingString
		NewWebServer.ServerBindings = NewBindings
		NewWebServer.ServerComment = ServerComment
'		NewWebServer.KeyType = "IIsWebServer"
		NewWebServer.SetInfo

		' Now create the root directory object.
		Trace "Setting the home directory..."
		Set NewDir = NewWebServer.Create("IIsWebVirtualDir", "ROOT")
		NewDir.Path = RootDirectory
		NewDir.AccessRead = true
		Err.Clear
		NewDir.SetInfo
		If (Err.Number = 0) Then
			Trace "Home directory set."
		Else
			Message "Error", True, "Setting home directory."
		End If
	
		Trace "Web site created!"

		If Start = True Then
			Trace "Attempting to start new web server..."
			Err.Clear
			Set NewWebServer = GetObject("IIS://" & comp & "/w3svc/" & Index)
			NewWebServer.Start
			If Err.Number <> 0 Then
				Message "Error", True, "Starting web server!"
				Err.Clear
			Else
				Trace "Web server started succesfully!"
			End If
		End If	
	Next
End Sub


' Message()
' All messages should eventually go through this routine.
'
'   MsgType           ("Info", "Warning", "Error", "Debug")
'                     is the type of the message.
'   PrintErrorObject  (True, False)
'                     Controls whether or not the Err object information is printed.
'   Msg               Application specific text for the message.
'
Sub Message(MsgType, PrintErrorObject, Msg)
' DO NOT put an "On Error Resume Next" statement in this code. It will
'   clear the Err object information before we get a chance to print it out.

	Dim MsgTypePadded

	'Enforce MsgType
	If ((MsgType <> "Info") And (MsgType <> "Warning") And (MsgType <> "Error") And (MsgType <> "Debug")) Then
		MsgType = "Error"
		WScript.Echo "Error:   Message(MsgType) called with case sensitive MsgType other than ""Info"", ""Warning"", ""Error"", ""Debug""."
	End If

	MsgTypePadded = MsgTypePad(MsgType)

	' Print Caller's message
	If (Msg <> "") Then
		WScript.Echo MsgTypePadded & Msg
	End If

	' Print Error object if caller thinks it's valid. 
	If ((PrintErrorObject = True) And (Err.Number <> 0)) Then
		ReportErrObject(MsgTypePadded)
	End If

End Sub

' Return a formatted, padded version of MsgType so message line up and look purty.
' ie. so that whatever follows MsgTypePad is aligned assuming a monospaced font.
Function MsgTypePad(MsgType)
' DO NOT put an "On Error Resume Next" statement in this code. It will
'   clear the Err object information before we get a chance to print it out.

	Select Case MsgType

		Case "Info"
			MsgTypePad = "Info:    "
		Case "Warning"
			MsgTypePad = "Warning: "
		Case "Error"
			MsgTypePad = "Error:   "
		Case "Debug"
			MsgTypePad = "Debug:   "
		Case Else
			MsgTypePad = "Error:   "

	End Select

End Function


'calls to Display() should be converted to Message().
Sub Display(Msg)
' DO NOT put an "On Error Resume Next" statement in this code. It will
'   clear the Err object information before we get a chance to print it out.
	if Err = 0 then
		Message "Info",  False, Msg
	else
		Message "Error", True,  Msg
	end if
End Sub

Sub Trace(Msg)
	if verbose = True then
		Message "Debug", False, Msg
	end if
End Sub

'winnt\system32\inetsrv\adminsamples\mkw3site.vbs end.

'winnt\system32\inetsrv\adminsamples\delwebsv.vbs copied and changed below....

Sub ASTDeleteWebSite(ServerList)
	Dim ServerNum, oServer
	Dim w3svc

	Err.clear
	ServerNum = 0
	While ServerNum <= UBound(ServerList)
		Display "Deleting W3SVC/" & ServerList(ServerNum)
		Set w3svc = GetObject("IIS://LocalHost/w3svc")
		Set oServer = GetObject("IIS://LocalHost/w3svc/" & ServerList(ServerNum))
		w3svc.Delete oServer.Class, oServer.Name
		If Err <> 0 Then
			Message "Error", True, "Couldn't delete server " & ServerList(ServerNum) & "!"
			WScript.Quit (1)
		End If
		ServerNum = ServerNum + 1
	Wend 
End Sub

'winnt\system32\inetsrv\adminsamples\delwebsv.vbs end.

'winnt\system32\inetsrv\adminsamples\mkwebdir.vbs copied and changed below....

'Removed website lookup and the ability to map more than one VirtualWebDir
'  from original routine.
Sub ASTCreateVirtualWebDir(WebSite,DirName,DirPath)
	Dim WebSiteID, vRoot, vDir
	On Error Resume Next

	Err.Clear
	set vRoot = webSite.GetObject("IIsWebVirtualDir", "Root")
	Trace "Accessing root for " & webSite.ADsPath
	If (Err <> 0) Then
		Message "Error", True, "Unable to access root for " & webSite.ADsPath
	Else
		'Create the new virtual directory
		Err.Clear
		Set vDir = vRoot.Create("IIsWebVirtualDir", DirName)
		If (Err <> 0) Then
			Message "Error", True, "Unable to create " & vRoot.ADsPath & "/" & DirName &"."
		Else
			'Set the new virtual directory path
			Err.Clear
			vDir.AccessRead = true
			vDir.Path = DirPath
			If (Err <> 0) Then
				Message "Error", True, "Unable to bind path " & DirPath & " to " & vRootName & "/" & DirName & ". Path may be invalid."
			Else
				'Save the changes
				Err.Clear
				vDir.SetInfo
				If (Err <> 0) Then
					Message "Error", True, "Unable to save configuration for " & vRootName & "/" & DirName &"."
				Else
					Trace "Web virtual directory " & vRootName & "/" & DirName & " created successfully."
				End If
			End If
		End If
	End If
End Sub


Function findWebFromServerComment(computer, webname)
	On Error Resume Next

	Dim websvc, site

	set websvc = GetObject("IIS://"&computer&"/w3svc")
	if (Err <> 0) then
		exit function
	end if
	for each site in websvc
		if site.class = "IIsWebServer" then
			' Check to see if the ServerComment matches
			If site.ServerComment = webname Then
				set findWebFromServerComment = site
				exit function
			End If
		end if
	next
End Function

'winnt\system32\inetsrv\adminsamples\mkwebdir.vbs end

'''''''''''''''''''''''''''''''''''
' TempFileCreate Create a temp file
'   TempFilePath - fully qualifed path of created temporary file.
'''''''''''''''''''''''''''''''''''
Function TempFileCreate(TempFilePath)

	Dim FunctionName, TempPath, oFileSystem, TempRandomName

	On Error Resume Next

	TempFileCreate = 0 ' Assume Success
	FunctionName = "TempFileCreate"

	' Create FileSytemObject for file operations.
	Err.clear
	Set oFileSystem = CreateObject("Scripting.FileSystemObject")
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't get Scripting.FileSystemObject object."
		TempFileCreate = GENERAL_FAILURE
		Exit Function
	End If

	' Get path to temporary directory to create the file in.
	Err.clear
	TempPath = oFileSystem.GetSpecialFolder(TemporaryFolder)
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Can't get path to temporary folder."
		TempFileCreate = GENERAL_FAILURE
		Exit Function
	End If

	TempRandomName = oFileSystem.GetTempName	
	TempFilePath =  TempPath & "\CW2000InstW3svc" & TempRandomName

	Err.clear
	oFileSystem.CreateTextFile TempFilePath
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't create temporary file " & TempFilePath
		TempFileCreate = GENERAL_FAILURE
		Exit Function
	End If

	Set oFileSystem = Nothing

End Function 'TempFileCreate()


'''''''''''''''''''''''''''''''''''
' ServiceState returns the state of interesting web services.
'   IISADMINRunning True if IISADMIN service is running, False otherwise.
'   W3SVCRunning    True if W3SVC    service is running, False otherwise.
'''''''''''''''''''''''''''''''''''
Function ServiceState(IISADMINRunning, W3SVCRunning)

	Const ForReading = 1, ForWriting = 2, ForAppending = 3
	Const TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0

	Dim WshShell
	Dim oFileSystem, oTempFile, oTempStream, TempLine, TempFilePath
	Dim ShellCommand, Return
	Dim CharPosition

	On Error Resume Next

	ServiceState = 0 ' Assume Success

	Return = TempFileCreate(TempFilePath)

	Err.clear
	Set oFileSystem = CreateObject("Scripting.FileSystemObject")
	If (Err.Number <> 0) Then
		Message "Error", True, "ServiceState: Couldn't get Scripting.FileSystemObject object."
		Exit Function
	End If

	Err.clear
	Set WshShell = Wscript.CreateObject("Wscript.Shell")
	If (Err.Number <> 0) Then
		Message "Error", True, "ServiceState: Couldn't get Wscript.Shell object."
		Exit Function
	End If

	ShellCommand = "%SystemRoot%\system32\cmd.exe /c %SystemRoot%\system32\net.exe start > "
        ShellCommand = ShellCommand & TempFilePath & " 2>&1 "
	Return = WshShell.Run(ShellCommand, 7, True)

	' Parse output of net start command to determine if W3SVC of IISADMIN are running.
	IISADMINRunning = False
	W3SVCRunning    = False

	Err.clear
	Set oTempFile   = oFileSystem.GetFile(TempFilePath)
	If (Err.Number <> 0) Then
		Message "Error", True, "ServiceState: Couldn't find temporary output file from net start command."
		Exit Function
	End If

	Err.clear
	Set oTempStream = oTempFile.OpenAsTextStream(ForReading, TristateUseDefault)
	If (Err.Number <> 0) Then
		Message "Error", True, "ServiceState: Couldn't open temporary output file from net start command."
		Exit Function
	End If

	TempLine = oTempStream.ReadLine
	CharPosition = InStr(1, TempLine, "These Windows NT services are started:",1)

	if (CharPosition <> 0) Then
		oTempStream.SkipLine
		Do While (oTempStream.AtEndOfStream <> True)
			TempLine = oTempStream.ReadLine
			CharPosition = InStr(1, TempLine, "IIS Admin Service",1)
			If (CharPosition <> 0) Then
				IISADMINRunning = True
			End If
			CharPosition = InStr(1, TempLine, "World Wide Web Publishing Service",1)
			If (CharPosition <> 0) Then
				W3SVCRunning = True
			End If
		Loop
	Else
		Message "Error", True, "Could not parse net start command output to determine which services are running."
	End If
	oTempStream.Close

        'free objects ie. Set ObjectHandle = Nothing
	oTempStream = Nothing
	oTempFile   = Nothing
	WshShell    = Nothing
	oFileSystem = Nothing

End Function 'ServiceState()


'''''''''''''''''''''''''''''
' CW2000URLShortcutCreate
' Create desktop Internet Shortcut to CW2000
' WebHost       - Hostname of CW2000 installation.
' Port          - http Port for CW2000.
' ServerComment - the ServerComment for the CW2000 website.
'''''''''''''''''''''''''''''
Function CW2000URLShortcutCreate (WebHost, Port, ServerComment)

	' Create desktop shortcut like:
	'[InternetShortcut]
	'URL=http://LocalHost:1741/

	On Error Resume Next
	Dim FunctionName, CW2000URLShortcutPath, URL, Return

	FunctionName = "CW2000URLShortcutCreate"
	CW2000URLShortcutCreate = 0 'Assume Success.

	Return = CW2000URLShortcutPathGet(ServerComment, CW2000URLShortcutPath)
	URL = "http://" & WebHost & ":" & Port & "/"

	Return = DesktopURLShortcut(CW2000URLShortcutPath, URL)

End Function 'CW2000URLShortcutCreate()


'''''''''''''''''''''''''''''
' CW2000URLShortcutDelete(ServerComment)
' Calculate the path to the Essantials URL Shortcut.
' ServerComment - the ServerComment for the CW2000 website.
'''''''''''''''''''''''''''''
Function CW2000URLShortcutDelete (ServerComment)
	On Error Resume Next
	Dim FunctionName, CW2000URLShortcutPath, oFileSystem, Return

	FunctionName = "CW2000URLShortcutDelete"
	CW2000URLShortcutDelete = 0 'Assume Success.

	Return = CW2000URLShortcutPathGet(ServerComment, CW2000URLShortcutPath)

	Err.clear
	Set oFileSystem = CreateObject("Scripting.FileSystemObject")
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't get Scripting.FileSystemObject object."
		CW2000URLShortcutDelete = GENERAL_FAILURE
		Exit Function
	End If

	Err.clear
	oFileSystem.DeleteFile CW2000URLShortcutPath
	If (Err.Number <> 0) Then
		Message "Warning", True,  FunctionName & ": Couldn't delete CW2000 internet shortcut."
		Message "Warning", False, FunctionName & ": Path:" & CW2000URLShortcutPath
		CW2000URLShortcutDelete = GENERAL_WARNING
		Exit Function
	End If

	Set oFileSystem = Nothing

End Function 'CW2000URLShortcutDelete()


'''''''''''''''''''''''''''''
' CW2000URLShortcutPathGet(ServerComment, CW2000URLShortcutPath)
' Calculate the path to the CW2000 URL Shortcut.
' ServerComment IN - the ServerComment for the CW2000 website.
' CW2000URLShortcutPath OUT - Full path of CW2000URLShortcut file.
'''''''''''''''''''''''''''''
Function CW2000URLShortcutPathGet(ServerComment, CW2000URLShortcutPath)
	On Error Resume Next

	Dim FunctionName, WshShell, MenuAllUsersPrograms, CW2000Group

	const CW2000GroupRegistryPath = "HKEY_LOCAL_MACHINE\SOFTWARE\Cisco\Resource Manager\CurrentVersion\setup\Folder"
	FunctionName = "CW2000URLShortcutPathGet"
	CW2000URLShortcutPathGet = 0 'Assume Success.

	Set WshShell = Wscript.CreateObject("Wscript.Shell")
	MenuAllUsersPrograms = WshShell.SpecialFolders("AllUsersPrograms")

	Err.clear
	CW2000Group = WshShell.RegRead(CW2000GroupRegistryPath)
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't read registry key:"
		Message "Error", False, CW2000GroupRegistryPath
		CW2000URLShortcutPathGet = GENERAL_FAILURE
		Exit Function
	End If

	CW2000URLShortcutPath = MenuAllUsersPrograms & "\" & CW2000Group & "\" & ServerComment & " Essentials.URL"

	WshShell = Nothing

End Function 'CW2000URLShortcutPathGet()


'''''''''''''''''''''''''''''
' DesktopURLShortcut Create a URL shortcut.
' URLShortcutFilePath is the full path name of the
'   URLShortcut including the path where the
'   URLShortcut resides and the file name of the shortcut
'   which appears in the directory or on the desktop. This
'   parameter MUST end in the file extension ".URL" or
'   it will not be properly recognized as a URLShortcut .
' URL is the full URL target of the URLShortcut .
'
'''''''''''''''''''''''''''''
Function DesktopURLShortcut (URLShortcutFilePath, URL)
	On Error Resume Next

	Const ForReading = 1, ForWriting = 2, ForAppending = 3
	Const TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0

	Dim ServerComment

	Dim oFileSystem, oURLShortcutFile, oURLShortcutStream, Line
	Dim FunctionName, Return

	FunctionName = "DesktopURLShortcut"
	DesktopURLShortcut = 0 'Assume Success.

	Err.clear
	Set oFileSystem = CreateObject("Scripting.FileSystemObject")
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't get Scripting.FileSystemObject object."
		DesktopURLShortcut = GENERAL_FAILURE
		Exit Function
	End If

	Err.clear
	oFileSystem.CreateTextFile URLShortcutFilePath
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't create file for internet shortcut."
		DesktopURLShortcut = GENERAL_FAILURE
		Exit Function
	End If

	Err.clear
	Set oURLShortcutFile   = oFileSystem.GetFile(URLShortcutFilePath)
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't find file for internet shortcut."
		DesktopURLShortcut = GENERAL_FAILURE
		Exit Function
	End If

	Err.clear
	Set oURLShortcutStream = oURLShortcutFile.OpenAsTextStream(ForWriting, TristateUseDefault)
	If (Err.Number <> 0) Then
		Message "Error", True, FunctionName & ": Couldn't open file for internet shortcut."
		DesktopURLShortcut = GENERAL_FAILURE
		Exit Function
	End If

	oURLShortcutStream.WriteLine "[InternetShortcut]"
	oURLShortcutStream.WriteLine "URL=" & URL

	oURLShortcutStream.Close

	Set oURLShortcutStream = Nothing
	Set oURLShortcutFile   = Nothing
	Set oFileSystem        = Nothing

End Function 'DesktopURLShortcut()
