﻿using PageAdmin.BLL;
using PageAdmin.Common;
using PageAdmin.Utils;
using PageAdmin.Web.Areas.Member.Controllers.Reg;
using System.Collections.Specialized;
using System.Web.Mvc;

namespace PageAdmin.Web.Areas.Member.Controllers
{

    [AllowAnonymous]
    public class RegController : BaseController
    {
        [Config]
        [HttpGet]
        public ActionResult Index()
        {
            DetailBLL detailBLL = new DetailBLL();
            dynamic detailData = detailBLL.GetEmptyModel("pa_member",DbHelper.DbContext());
            string model = JsonHelper.JsonParse(detailData);
            return View((object)model);
        }

        [Validate]
        [HttpPost] 
        public JsonResult Index(FormCollection form)
        {
           MemberRegBLL memberRegBLL = new MemberRegBLL();
           var tipsInfo = memberRegBLL.Reg(form, (int)ViewBag.DefaultState, (byte)ViewBag.EmailState, (byte)ViewBag.MobileState);
            if (tipsInfo.State == 1)
            {
                SmsCodeBLL smsCodeBLL = new SmsCodeBLL();
                smsCodeBLL.Remove(form["mobile"]);
                EmailCodeBLL emailCodeBLL = new EmailCodeBLL();
                emailCodeBLL.Remove(form["email"]);
            }
            VerificationCodeBLL verificationCodeBLL = new VerificationCodeBLL();
            verificationCodeBLL.Remove();
            return Json(tipsInfo);
        }

        /// <summary>
        /// 自动注册，支持post和get请求
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [Config]
        public ActionResult Auto()
        {
            return View();
        }

        /// <summary>
        /// 自动注册，支持post和get请求
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [Config]
        public ActionResult Auto(FormCollection form)
        {
            TipsInfo tipsInfo = new TipsInfo();
            if (ViewBag.Open==0)
            {
                tipsInfo.State = 0;
                tipsInfo.Msg = "注册功能已关闭!";
            }
            else
            {
                string openId = form["openid"];
                MemberRegBLL memberRegBLL = new MemberRegBLL();
                tipsInfo = memberRegBLL.AutoReg(openId, (int)ViewBag.DefaultState, (int)ViewBag.DefaultMemberGroupId);
            }
            return base.Json(tipsInfo);
        }

        [HttpGet]
        public ActionResult Success()
        {
            return View();
        }

        [HttpGet]
        public ActionResult RegAgreement()
        {
            string content = XmlHelper.NodeValue("/configuration/content", "/Config/MemberRegAgreement.config");
            return View((object)content);
        }

    }
}
