/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.core;

import com.dbeaver.ee.runtime.internal.core.EntRuntimeMessages;
import com.dbeaver.lm.core.PublicLicenseValidator;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMKeyProvider;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class DBeaverEnterpriseLM {
    public static final LMProduct EE_PRODUCT;
    public static final LMLicenseManager LICENSE_MANAGER;
    private static final Log log;
    public static final String DBEAVER_EE_PRODUCT_ID = "dbeaver-ee";

    static {
        String pathToLicenseFile;
        log = Log.getLog(DBeaverEnterpriseLM.class);
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        Version bundleVersion = application.getContributorBundle().getVersion();
        String version = String.valueOf(bundleVersion.getMajor()) + "." + bundleVersion.getMinor();
        EE_PRODUCT = new LMProduct(DBEAVER_EE_PRODUCT_ID, "DB", application.getName(), application.getDescription(), version, GeneralUtils.getProductReleaseDate());
        LICENSE_MANAGER = new LMLicenseManager((LMKeyProvider)new LicenseKeyProvider(), PublicLicenseValidator.PUBLIC_LICENSE_VALIDATOR);
        IProduct product = Platform.getProduct();
        if (product != null && !CommonUtils.isEmpty((String)(pathToLicenseFile = product.getProperty("productLicense")))) {
            try {
                URL url = FileLocator.toFileURL((URL)new URL(pathToLicenseFile));
                File localFile = new File(url.getFile());
                LMLicenseManager.setLicenseCustomPath((String)localFile.getAbsolutePath());
            }
            catch (Throwable e) {
                log.warn((Object)"Error opening product license", e);
            }
        }
    }

    public static boolean hasLicense(String clientId) {
        try {
            return LICENSE_MANAGER.hasProductLicense(clientId, EE_PRODUCT);
        }
        catch (LMValidateException e) {
            log.debug((Object)("Error validating license: " + e.getMessage()));
            return false;
        }
    }

    private static class LicenseKeyProvider
    implements LMKeyProvider {
        LicenseKeyProvider() {
        }

        public Key getEncryptionKey(LMProduct product) {
            return null;
        }

        public Key getDecryptionKey(LMProduct product) {
            String id = product.getId();
            String resourceName = "keys/" + id + "-public.key";
            URL keyURL = this.getClass().getClassLoader().getResource(resourceName);
            if (keyURL != null) {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream keyStream = keyURL.openStream();){
                        byte[] keyData = LMUtils.readEncryptedString((InputStream)keyStream);
                        return LMEncryption.generatePublicKey((byte[])keyData);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return null;
                }
            }
            String message = NLS.bind((String)EntRuntimeMessages.DBeaverEnterpriseLM_e_key_not_found, (Object)id);
            log.error((Object)message);
            return null;
        }
    }
}

