--What are you looking at, meatbag? Beat it!
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/bender.zip" ),
}

local prefabs =
{
}

local function onupdate(inst, dt)
	inst.charge_time = inst.charge_time - dt
	if inst.charge_time <= 0 then
		inst.charge_time = 0
		if inst.charged_task then
			inst.charged_task:Cancel()
		end
		inst.charged_task = nil
		inst.Light:Enable(false)
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED 
		inst.AnimState:SetBloomEffectHandle( "" )
		inst.components.temperature.mintemp = -20
		inst.components.talker:Say("That's over.", 4)
		--inst.SoundEmitter:KillSound("overcharge_sound")
	else
    	local runspeed_bonus = .5
    	local rad = 3
    	if inst.charge_time < 60 then
    		rad = math.max(.1, rad * (inst.charge_time / 60))
    		runspeed_bonus = (inst.charge_time / 60)*runspeed_bonus
    	end

    	inst.Light:Enable(true)
    	inst.Light:SetRadius(rad)
		inst.AnimState:SetBloomEffectHandle( "data/shaders/anim.ksh" )
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*(1+runspeed_bonus)
		inst.components.temperature.mintemp = 10
	end

end

local function onload(inst, data)
		if data.charge_time then
			onupdate(inst, 0)
			inst.charged_task = inst:DoPeriodicTask(1, onupdate, nil, 1)
		end
end

local function onsave(inst, data)
	data.charge_time = inst.charge_time
end

local function onlightingstrike(inst)
	inst.charge_time = inst.charge_time + TUNING.TOTAL_DAY_TIME*(.5 + .5*math.random())

	inst.components.health:DoDelta(TUNING.HEALING_SUPERHUGE)
	inst.components.sanity:DoDelta(-TUNING.SANITY_LARGE)
	inst.components.talker:Say("Feels GOOD!!!", 4)

	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/charged", "overcharge_sound")
	if not inst.charged_task then
		onupdate(inst, 0)
		inst.charged_task = inst:DoPeriodicTask(1, onupdate, nil, 1)
	end
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wx78"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wx78.png" )

	-- todo: Add an example special power here.
	--inst:AddComponent("firebug")
	--inst.components.firebug.prefab = "willowfire"
	inst.charge_time = 0
	inst:AddComponent("playerlightningtarget")
	inst:ListenForEvent("lightningstrike", onlightingstrike)	
	inst.components.health.fire_damage_scale = 0
	inst.components.health.absorb = 0.7
	inst.components.eater.ignoresspoilage = true
	inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH * 1.5 )
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * 1.5 )
	inst.components.combat.damagemultiplier = 1.5
	inst.components.temperature.inherentinsulation = 30*12
	inst:AddTag("fridge")
	--inst:AddTag("penguin")
    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
	inst.Light:SetRadius(2)
    inst.Light:SetFalloff(0.75)
    inst.Light:SetIntensity(.9)
    inst.Light:SetColour(96/255,227/255,255/255)
    --inst.Light:SetColour(1,0,0)
	inst.OnLongUpdate = function(inst, dt) 
		inst.charge_time = math.max(0, inst.charge_time - dt)
	end

	inst.OnSave = onsave
	inst.OnLoad = onload
end


-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.bender = "Bending Unit 22"
STRINGS.CHARACTER_NAMES.bender = "Bender"
STRINGS.CHARACTER_DESCRIPTIONS.bender = "* 40% Dolomite.\n* Resistant to extreme temperatures.\n* Can function like a fridge."
STRINGS.CHARACTER_QUOTES.bender = "\"Bite my shiny metal ass!\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.BENDER = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.GUANO = "You never heard of a toilet?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.AMULET = "That's a fine pimp amulet!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.ASH = "My cigar leaves a lot of these."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ARMORSNURTLESHELL = "Good for Halloween."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BABYBEEFALO = "You're getting bald?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEBOX = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEBOX.GENERIC = "They work for Bender now!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEBOX.FULLHONEY = "Living on other's spoils!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEBOX.NOHONEY = "Get back to work!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEBOX.SOMEHONEY = "Bender needs more!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEMINE = "The mine is mine."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BATWING = "I stole his wings!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUNNYMAN = "Massive bonehead!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BLOWDART_FIRE = "Burn, baby!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BLUEPRINT = "That's how I was made."
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.EMBERS = "It will run out soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.GENERIC = "Let's say Bender stories around it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.HIGH = "Don't try this at home!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.LOW = "No fire soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.NORMAL = "Let's say Bender stories around it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAMPFIRE.OUT = "It's done."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FLOWER_CAVE = "You light the way."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FLOWER_CAVE_DOUBLE = "You light the way."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FLOWER_CAVE_TRIPLE = "You light the way."
STRINGS.CHARACTERS.BENDER.DESCRIBE.MUSHTREE_TALL = "Neat!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MUSHTREE_MEDIUM = "Neat!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MUSHTREE_SMALL = "Neat!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_BANANA_TREE = "Will monkeys come now?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_BANANA = "Monkey bussiness!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_BANANA_COOKED = "I made it better."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ROCKY = "Zoidberg?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.HOUNDSTOOTH = "They made holes in my ass!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BAT = "You don't scare Bender!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BATBAT = "Vampirism, bleh!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.LIGHTBULB = "Lightballs."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SLURTLE = "Slowpoke!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SLURTLE_SHELLPIECES = "It broke."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SLURTLESLIME = "I'm not disgusted."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SLURTLEHAT = "I look ridiculous in this!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SLURTLEHOLE = "Damn biological creatures!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SNURTLE = "Slowpoke!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDER_HIDER = "You can't hide from me, Bender!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDER_SPITTER = "Shut your noise hole!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDERHOLE = "There's a party in there!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_ENTRANCE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_ENTRANCE.GENERIC = "Does it bury some treasures?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CAVE_ENTRANCE.OPEN = "I hope it's full of diamonds and gold!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CANE = "Go Bender! Go Bender!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CARROT_PLANTED = "It's for rabbits."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BOOMERANG = "That's how you bend things right."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ADVENTURE_PORTAL = "Hey other universe, bite my shiny metal ass!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.ANIMAL_TRACK = "This will lead to a bigger meatbag." 
STRINGS.CHARACTERS.BENDER.DESCRIBE.ARMORGRASS = "It will break soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ARMORMARBLE = "Bite my durable marble armor!" 
STRINGS.CHARACTERS.BENDER.DESCRIBE.ARMORWOOD = "No termites, please."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ARMOR_SANITY = "It's stronger than it looks."
STRINGS.CHARACTERS.BENDER.DESCRIBE.AXE = "Chop all trees!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BANDAGE = "Stops my leakage."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEARDHAIR = "Where did this come from?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEE.GENERIC = "Your stinger will break on me!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEE.HELD = "Makes me buzzzzz..."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALO = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALO.GENERIC = "That's a big meatbag."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALO.FOLLOWER = "Attracted by my greatness."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALO.NAKED = "You know, it's funny."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALO.SLEEPING = "I can do that all day."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALOHAT = "I'm even grater than I tought I was!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEFALOWOOL = "I hope it has static electricity."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEHAT = "Bring it on!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BEEHIVE = "It's better to be lazy."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BERRYBUSH = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BERRYBUSH.GENERIC = "It's full of balls!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BERRYBUSH.PICKED = "Useless now."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BIRDCAGE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BIRDCAGE.GENERIC = "I don't know, do I want a pet?" 
STRINGS.CHARACTERS.BENDER.DESCRIBE.BIRDCAGE.OCCUPIED = "Someone to watch how great I am!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BIRDCAGE.SLEEPING = "Dream on, skin tube."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BIRDTRAP = "Stupid birds will fall for it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BISHOP = "Hit me with your best shot!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BLUEGEM = "I'm rich, in yo face!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.REDGEM = "It's mine!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BLUE_CAP = "I like these."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BOARDS = "Bending will break them."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUSHHAT = "Stealth mode!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUTTERFLY = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUTTERFLY.GENERIC = "I want to zap it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUTTERFLY.HELD = "You're going nowhere!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BUTTERFLYWINGS = "Let's see you fly now, haha!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CHARCOAL = "Burns nicely."
STRINGS.CHARACTERS.BENDER.DESCRIBE.CHESTER = "Neat!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.COOKEDMEAT = "It goes well with some beer."
STRINGS.CHARACTERS.BENDER.DESCRIBE.COOKEDSMALLMEAT = "Bender deserves more than this!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.COOKEDMANDRAKE = "Poor bastard!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.COOKEDMONSTERMEAT = "I still didn't improved it."
STRINGS.CHARACTERS.BENDER.DESCRIBE.CORN_COOKED = "Let's watch a movie!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.CUTSTONE = "I bend those rocks like a pro!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.DEERCLOPS = "GET OFF MY BACK!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.DEERCLOPS_EYEBALL = "In yo face, Deerclops!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.DRUMSTICK = "Can't run now, moron!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.DRUMSTICK_COOKED = "You loss, my friend!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.DURIAN = "Spiky."
STRINGS.CHARACTERS.BENDER.DESCRIBE.DURIAN_COOKED = "Softer now."
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN.GENERIC = "I thought they were extinct."
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN.CHOPPED = "Bender is great!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN.BURNING = "You're boned!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN.BURNT = "It's not comming back."
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN_SPARSE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN_SPARSE.CHOPPED = "Bender is great!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN_SPARSE.GENERIC = "These will be extinct soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN_SPARSE.BURNING = "You're boned!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.EVERGREEN_SPARSE.BURNT = "It's not comming back."
STRINGS.CHARACTERS.BENDER.DESCRIBE.EYEPLANT = "What are you looking at?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.EARMUFFSHAT = "I don't need to hear your noise hole!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FEATHERHAT = "Do I look like a bird in this?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FLOWER = "It's full of bugs."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FOOTBALLHAT = "Talking about being hard headed!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.EMBERS = "It will run out soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.GENERIC = "Let's say Bender stories around it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.HIGH = "Don't try this at home!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.LOW = "No fire soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.NORMAL = "Let's say Bender stories around it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIREPIT.OUT = "I can bring it back."
STRINGS.CHARACTERS.BENDER.DESCRIBE.FIRESTAFF = "I'm Bender, the fire wizard of Cornwood!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.FROG = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.FROG.GENERIC = "Could be a frog, or a toad, or yo mama!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.GHOST = "Back to limbo with you!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.GREEN_CAP = "Can be a good ingredient."
STRINGS.CHARACTERS.BENDER.DESCRIBE.GEARS = "Bender is great!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.GOLDNUGGET = "Bite my glorious golden nugget!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.GUNPOWDER = "Blow them up!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.HAMBAT = "Meatstick made from a meatbag."
STRINGS.CHARACTERS.BENDER.DESCRIBE.HAMMER = "Whack a building! "
STRINGS.CHARACTERS.BENDER.DESCRIBE.HOUND = "Bite my... nevermind."
STRINGS.CHARACTERS.BENDER.DESCRIBE.HEALINGSALVE = "I can repair myself cause I'm cool."
STRINGS.CHARACTERS.BENDER.DESCRIBE.HOUNDBONE = "Not impressed."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ICEBOX = "My internal refrigerator does the same."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ICESTAFF = "I'm Bender, the ice wizard of Cornwood!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.KNIGHT = "These guys are seriously outdated!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.KOALEFANT_SUMMER = "A bigger meatbag!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.KOALEFANT_WINTER = "A warm big meatbag!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.KRAMPUS = "Only Bender steals here!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.KRAMPUS_SACK = "A bigger container." 
STRINGS.CHARACTERS.BENDER.DESCRIBE.LEIF = "Oooh!" 
STRINGS.CHARACTERS.BENDER.DESCRIBE.LEIF_SPARSE = "Oooh"
STRINGS.CHARACTERS.BENDER.DESCRIBE.LIGHTNING_ROD = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.LIGHTNING_ROD.CHARGED = "Touching that will be a fun on a bun!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.LIGHTNING_ROD.GENERIC = "Don't worry, I don't have an addictive personality."
STRINGS.CHARACTERS.BENDER.DESCRIBE.LIVINGLOG = "Haha, look at your face!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.LOG = "Glad I'm not made from wood."
STRINGS.CHARACTERS.BENDER.DESCRIBE.LUREPLANT = "Strange plant."
STRINGS.CHARACTERS.BENDER.DESCRIBE.MANDRAKE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.MANDRAKE.DEAD = "A dead little guy."
STRINGS.CHARACTERS.BENDER.DESCRIBE.MANDRAKE.GENERIC = "I should pick it."
STRINGS.CHARACTERS.BENDER.DESCRIBE.MANDRAKE.PICKED = "Would you kindly shut your noise hole?" 
STRINGS.CHARACTERS.BENDER.DESCRIBE.MAXWELL = "Kill all humans!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MEAT = "Meat from a meatbag."
STRINGS.CHARACTERS.BENDER.DESCRIBE.MINERHAT = "Let's mine more gold!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MONSTERMEAT = "Only Elzar could make this good. "
STRINGS.CHARACTERS.BENDER.DESCRIBE.MOSQUITO = "Where's my pesticide?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MONKEY = "You shouldn't learn stealing from me!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MOUND = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.MOUND.GENERIC = "I should pillage this grave for loot!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MOUND.DUG = "Hey dead guy, thanks for your belongings"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MAXWEELTHRONE = "Found you, meatbag! You're boned now!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.MERM = "These guys are boneheads!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.NIGHTMAREFUEL = "What kind of black matter is this?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.NIGHTSWORD = "My enemies can bite my shiny metal ass!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.ORANGEAMULET = "I'm rich and lazy!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PERD = "I should poison your berries, bonehead!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PETALS = "They will die soon."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PENGUIN = "I still have the penguin personality."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGKING = "Where you keep your gold?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGMAN = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGMAN.GENERIC = "Another kind of meatbag."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGMAN.FOLLOWER = "Let's go get drunk!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGMAN.GUARD = "You believe in something that doesn't exist!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGMAN.WEREPIG = "I've been through that too."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PITCHFORK = "I should give it to Robot Devil."
STRINGS.CHARACTERS.BENDER.DESCRIBE.POOP = "Good thing I don't have a nose."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PURPLEGEM = "It's worth a fortune."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PURPLEAMULET = "I'm crazy rich! Muhahaha!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PICKAXE = "I should mine more loot."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGHOUSE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGHOUSE.GENERIC = "Too fancy for some pigs."
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGHOUSE.FULL = "Can you let me in?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.PIGHOUSE.LIGHTSOUT = "Fine, I'll make my own house, with blackjack, and hookers!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RABBIT = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.RABBIT.GENERIC = "Bite my nutritious tasty carrot!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RABBIT.HELD = "Don't you dare chew my wires!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RAZOR = "Gimme your throat!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RED_CAP = "Doesn't look great."
STRINGS.CHARACTERS.BENDER.DESCRIBE.RESURRECTIONSTATUE = "I lifeless wood robot."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ROPE = "Now I can strangle some humans!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RAINOMETER = "When it rains?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.RABBITHOLE = "Come out!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.ROCK = "I should mine it for gold."
STRINGS.CHARACTERS.BENDER.DESCRIBE.ROOK = "Chill dude!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SAPLING = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.SAPLING.PICKED = "In yo face!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SILK = "It's not even that sticky."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SKELETON = "Life goes on, except for you! Hahaha!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPEAR = "Uncle Bender will show you how to fight."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDER = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDER.GENERIC = "I consider them a pest!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDERQUEEN = "You're an ugly fat queen!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SHOVEL = "I can dig your grave with this!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SMALLMEAT = "From a small meatbag."
STRINGS.CHARACTERS.BENDER.DESCRIBE.SMALLBIRD = "Do I look like a babysitter? Beat it!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPIDERGLAND = "What's this organ?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.SPOILED_FOOD = "Just trash."
STRINGS.CHARACTERS.BENDER.DESCRIBE.STATUEMAXWELL = "Why I don't have a statue?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.STRAWHAT = "Reminds me of another bending unit."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TAFFY = "Sweet."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TENTACLE = "Yivo?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TENTACLESPIKE = "They're so boned now!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TENTACLESPOTS = "You wicked biological creature!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TOPHAT = "Like a gentlebender!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TREASURECHEST = "Extra storage unit to put my excess loot."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TURF_WOODFLOOR = "I prefer metal flooring."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BASE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BASE.GENERIC = "I must assamble it to escape."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BASE.ACTIVE = "Ready to timetravel?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BASE.LOCKED = "Need's unlocking."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BASE.PARTIAL = "Not done yet."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_BOX = "Give me power!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_CRANK = "It's unbendable!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_POTATO = "A robot potato?"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELEPORTATO_RING = "It's magnetic and makes me sing!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TELESTAFF = "I'm Bender, the magnificient wizard of Cornwood!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TORCH = "Burn all humans!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRAP = "Let's see whose smarter!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TENT = "I feel lazy."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_1 = "My balls!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_2 = "100% fake."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_3 = "Real tight."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_4 = "Hello, chump!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_5 = "I wish the ship was here."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_6 = "I'm 40% wires."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_7 = "A little amusement."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_8 = "Solves my leaking problems."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_9 = "Buttons..."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_10 = "The professor would need this."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_11 = "This robot is just a toy."
STRINGS.CHARACTERS.BENDER.DESCRIBE.TRINKET_12 = "Not moving anymore."
STRINGS.CHARACTERS.BENDER.DESCRIBE.UMBRELLA = "Bending in the rain!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.WINTEROMETER = "That's a big ass thermometer!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.WORMHOLE = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.WORMHOLE.OPEN = "Those teeth can't scratch me."
STRINGS.CHARACTERS.BENDER.DESCRIBE.WALRUS_CAMP = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.WALRUS_CAMP.EMPTY = "Damn you campers!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.WALRUS_CAMP.GENERIC = "They won't let me in."
STRINGS.CHARACTERS.BENDER.DESCRIBE.YELLOWGEM = "Shiny!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.YELLOWSTAFF = "I'm Bender, the light wizard or Cornwood!"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BENDER = {}
STRINGS.CHARACTERS.BENDER.DESCRIBE.BENDER.COOKING_LONG = "I enjoy cooking"
STRINGS.CHARACTERS.BENDER.DESCRIBE.BENDER.COOKING_SHORT = "Almost done."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BENDER.DONE = "My delicious meal is done."
STRINGS.CHARACTERS.BENDER.DESCRIBE.BENDER.EMPTY = "I'm Bender the Magnificient!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_ADVENTUREFAIL = "You didn't hear the last of me, Bender!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_BOOMERANG = "Ow, my head!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_DUSK = "I need to make light soon."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_HUNT_BEAST_NEARBY = "The big meat source is near."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_WORMHOLE = "What a trip!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_BEES = "Cheese it!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_COLD = "Lick my frozen metal ass!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_DEERCLOPS = "I'm boned!" 
STRINGS.CHARACTERS.BENDER.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.BENDER.ANNOUNCE_EAT.PAINFUL = "Yuck, it scattered in me!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_EAT.SPOILED = "It lost taste."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_EAT.STALE = "Not a good food."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_ENTER_DARK = "Light's out."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_ENTER_LIGHT = "I'm back, baby!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_FREEDOM = "In yo face, Maxwell!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_HUNGRY = "I need fuel..."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_HOUNDS = "I hear trouble."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_INV_FULL = "60% storage unit isn't enough!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_KNOCKEDOUT = "Ahhh..."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_MOSQUITOS = "Get off my back!"
STRINGS.CHARACTERS.BENDER.ANNOUNCE_NODANGERSLEEP = "Not here."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_NODAYSLEEP = "Not now."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_NOHUNGERSLEEP = "Not a good idea."
STRINGS.CHARACTERS.BENDER.ANNOUNCE_QUAKE = "Sound's like I'm boned!"
STRINGS.CHARACTERS.BENDER.BATTLECRY = {}
STRINGS.CHARACTERS.BENDER.BATTLECRY.GENERIC = "You're pending for a bending!"
STRINGS.CHARACTERS.BENDER.BATTLECRY.PREY = "Life waste!"
STRINGS.CHARACTERS.BENDER.BATTLECRY.SPIDER = "Get lost!!"
STRINGS.CHARACTERS.BENDER.BATTLECRY.SPIDER_WARRIOR = "Beat it!"




return MakePlayerCharacter("bender", prefabs, assets, fn)
