PrefabFiles = {
	"winnifred",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/winnifred.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/winnifred.xml" ),


    Asset( "IMAGE", "images/selectscreen_portraits/winnifred.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winnifred.xml" ),


    Asset( "IMAGE", "images/selectscreen_portraits/winnifred_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/winnifred_silho.xml" ),


    Asset( "IMAGE", "bigportraits/winnifred.tex" ),
    Asset( "ATLAS", "bigportraits/winnifred.xml" ),
}


-- Grue override
function ModGrueInit(inst)
	-- Override a class function, changed to only modify grue for winnifred
	inst.Start = function(self)
		self.inst:StartUpdatingComponent(self) 
		local player=GLOBAL.GetPlayer()
		if player:HasTag("winnifred") then
			self.nextHitTime = 10+math.random()*5 -- The Grue will strike within 10 to 15 seconds of the player entering the dark (up from 5 to 10)
		else
			self.nextHitTime = 5+math.random()*5
		end
		self.nextSoundTime = self.nextHitTime* (.4 + math.random()*.4)
	end
end

local function ModSanityInit(Sanity)
	function Sanity:GetMax()
		return self.max
	end
	function Sanity:SetMax(amount, keepcurrent)
	    self.max = amount
	    if not keepcurrent then
		    self.current = amount
		else
			if self.penaltypercent then
				self.penaltypercent=amount/200
			end
		end
	end
end

AddComponentPostInit("grue", ModGrueInit)
AddComponentPostInit("sanity", ModSanityInit)
AddModCharacter("winnifred")