
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/winnifred.zip" ),
}
local prefabs = {}


local function OnSave(inst, data)
	data.maxsanity=inst.maxsanity
	data.damagemultiplier=inst.components.combat.damagemultiplier
end

local function OnLoad(inst, data)
	if data.maxsanity then
		inst.maxsanity=data.maxsanity
	else
		inst.maxsanity=200
	end
	inst.components.sanity:SetMax(inst.maxsanity,true)
	inst.components.combat.damagemultiplier=data.damagemultiplier
end

local fn = function(inst)
	inst:AddTag("winnifred")

	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wendy.png" )
	
	-- centralizing of used variables for convenience only
	local time=1 -- time between LightChecks and thus buffs/debuffs
	local daylight=1.25 -- Lightvalue of daylight, approximated to be 1.25, might be considered overcast already
	local dusklight=0.7 -- Lightvalue of dusklight
	local dark_thresh = 2 -- how long the player needs to be in the dark before they start healing
	local light_thresh = 10 -- how long the player needs to be in the light before they start getting mad
	local healthregen = 5 -- Percent of Maxhealth healed in darkness
	local SanityDeltaPlus = 10 -- how much sanity you gain per LightCheck
	local SanityDeltaMinus = 0.3 -- how much sanity you lose per LightCheck
	local MinSanity = 50 -- how low sanity can fall
	local MaxSanity = 200 -- how high sanity can rise
	local FastRunSpeed = 7 -- how fast you are during night
	local StrongCombat = 1.2 -- how strong you are at night
	local SlowRunSpeed = 5.5 -- how slow you are at day
	local WeakCombat = 0.8 -- how weak you are at day

	-- When in the dark, regen health
	local function LightCheck(inst)
		-- Change
		if inst.components.sanity
			and not inst.is_teleporting
			and not GetSeasonManager():IsRaining()
			and inst.LightWatcher:GetTimeInLight() >= light_thresh
			and inst.LightWatcher:GetLightValue() >= daylight
			and GetClock():IsDay() then

			inst.maxsanity=math.max(inst.maxsanity-SanityDeltaMinus,MinSanity)
			inst.components.sanity:SetMax(inst.maxsanity,true)
			--Change end
		elseif inst.components.health 
			and not inst.components.health:IsDead()
			and inst.components.sanity
			and not inst.is_teleporting 
			and inst.LightWatcher:GetTimeInDark() >= dark_thresh then

			inst.components.health:DoDelta(healthregen) -- The player heals 5% of their max health
			-- Change
			inst.maxsanity=math.min(inst.maxsanity+SanityDeltaPlus,MaxSanity)
			inst.components.sanity:SetMax(inst.maxsanity,true)
			-- Change end
		end
		if inst.LightWatcher:GetLightValue() > dusklight 
			and not GetClock():IsDay()then

			inst.components.combat.damagemultiplier = 1
	        inst.components.locomotor.walkspeed=4
	        inst.components.locomotor.runspeed=6
	    elseif inst.LightWatcher:GetLightValue() < dusklight then
	    	inst.components.combat.damagemultiplier = StrongCombat
	        inst.components.locomotor.walkspeed=FastRunSpeed-2
	        inst.components.locomotor.runspeed=FastRunSpeed
		end
	end

	inst.OnLoad = OnLoad
	inst.OnSave = OnSave

	inst:DoPeriodicTask(time, function() LightCheck(inst) end)

	-- Do not gain sanity bonus from worn / carried items (you can lose sanity though)
	inst:ListenForEvent("equip", function(inst, data) 
		if data.item.components.dapperness and data.item.components.dapperness.dapperness > 0 then
			data.item:RemoveComponent("dapperness")
		end
		if data.item.components.dapperness and data.item.components.dapperness.mitigates_rain and GetClock():IsDay() then
			inst.components.combat.damagemultiplier = 1
	        inst.components.locomotor.walkspeed=4
	        inst.components.locomotor.runspeed=6
		end
	end)
	inst:ListenForEvent("unequip", function(inst, data) 
		if data.item.components.dapperness and data.item.components.dapperness.mitigates_rain and (GetClock():IsNight() or GetClock():IsDusk()) then
			inst.components.combat.damagemultiplier = StrongCombat
	        inst.components.locomotor.walkspeed=FastRunSpeed-2
	        inst.components.locomotor.runspeed=FastRunSpeed
		elseif data.item.components.dapperness and data.item.components.dapperness.mitigates_rain and GetClock():IsDay() then
			inst.components.combat.damagemultiplier = WeakCombat
	        inst.components.locomotor.walkspeed=SlowRunSpeed-2
	        inst.components.locomotor.runspeed=SlowRunSpeed
		end
	end)  

	--Get stronger in the night
	inst:ListenForEvent( "dusktime", function()
        inst.components.combat.damagemultiplier = StrongCombat
        inst.components.locomotor.walkspeed=FastRunSpeed-2
        inst.components.locomotor.runspeed=FastRunSpeed
    end, GetWorld())
    --and weaker during day
	inst:ListenForEvent( "daytime", function()
        inst.components.combat.damagemultiplier = WeakCombat
        inst.components.locomotor.walkspeed=SlowRunSpeed-2
        inst.components.locomotor.runspeed=SlowRunSpeed
    end, GetWorld())
    

	-- Tune sanity so that it is gained at night instead of being lost
	TUNING.SANITY_NIGHT_LIGHT = 5/60 -- Sanity gain of 5 per minute when close to a campfire
	TUNING.SANITY_NIGHT_MID = 5/60 -- Sanity gain of 5 per minute during dusk or when on the edge of a campfire's light
	TUNING.SANITY_NIGHT_DARK = 10/60 -- Sanity gain of 10 per minute when it the dark

	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * .75 )
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .9 )
end


-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.winnifred = "The Backroom Poet"
STRINGS.CHARACTER_NAMES.winnifred = "Winnifred"
STRINGS.CHARACTER_DESCRIPTIONS.winnifred = "*Loves the dark.\n*The sun burns out her enthusiasm. \n*Extremely pretentious."
STRINGS.CHARACTER_QUOTES.winnifred = "\"Darkness like a shroud of liquid bliss envelops my soul.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WINNIFRED = {}
STRINGS.CHARACTERS.WINNIFRED.DESCRIBE = {}
STRINGS.CHARACTERS.WINNIFRED.DESCRIBE.EVERGREEN = "A silent guardian, a humble oxygen factory."
STRINGS.CHARACTERS.WINNIFRED.ACTIONFAIL_GENERIC = "We may try, but we are doomed to fail."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_ADVENTUREFAIL = "And yet my journey continues."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_BOOMERANG = "OW! That was uncool!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_CHARLIE = "Errr, maybe this is a bit TOO dark..."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_CHARLIE_ATTACK = "HEY! Get out of my darkness!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_COLD = "It's so cold it's uncool!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_CRAFTING_FAIL = "Perhaps I was unprepared?"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_DUSK = "Ahh.. Sweet sundown."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_EAT =
	{
		GENERIC = "A pitiable vice.",
		PAINFUL = "Eugh! Food is evil!",
		SPOILED = "I'm overcome with disgust in myself.",
		STALE = "A disappointment if ever there was one.",
	}
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_ENTER_DARK = "Fill my soul with the dark!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_ENTER_LIGHT = "And it was over far too soon."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_HOUNDS = "They are coming for me, will I be ready?"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_HUNGRY = "The hollow feeling inside is bigger then usual."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_HUNT_BEAST_NEARBY = "The colossus has traversed these lands."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_HUNT_LOST_TRAIL = "The colossus lives another day."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_INV_FULL = "Yeah, that's not happening."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_PECKED = "His beak is worse then his gaze!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_TORCH_OUT = "This beacon of luminance has perished!"
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_WORMHOLE = "Not even the underworld wants me."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_NODANGERSLEEP = "I'm not terribly interested in dying in my sleep."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_NODAYSLEEP = "The sun's oppressive light wont allow that."
STRINGS.CHARACTERS.WINNIFRED.ANNOUNCE_NOHUNGERSLEEP = "I might try to eat the pillow."
STRINGS.CHARACTERS.WINNIFRED.BATTLECRY =
	{
		GENERIC = "You cannot escape the inevitable!",
		PIG = "Your oppression ends now, swine!",
		PREY = "We must all make sacrifices.",
		SPIDER = "Ravage the earth no more!",
		SPIDER_WARRIOR = "Your reinforcements are of no use!",
	}
STRINGS.CHARACTERS.WINNIFRED.COMBAT_QUIT =
	{
		GENERIC = "Ok, nevermind.",
	}
STRINGS.CHARACTERS.WINNIFRED.DESCRIBE =
	{
		CAVE_BANANA = "The salvation of my ancestors.",
		CAVE_BANANA_COOKED = "A new twist on an old classic.",
		CAVE_BANANA_TREE = "This tree's got the right idea.",
		ROCKY = "And me without my matching towel.",
		MONKEY = "He is yet uncorrupted by evolution.",
		MONKEYBARREL = "I'm pretty sure that's not the cradle of humanity.",
		BLUEAMULET = "Its cold like the hearts of those who covet it.",
		PURPLEAMULET = "People are often driven mad with greed.",
		HOUNDSTOOTH="A trophy, plucked from the jaw of my foe.",
		ARMORSNURTLESHELL="Slimy protection, or a portable darkroom?",
		BAT="Perhaps we could have been friends?",
		BATBAT = "My winged friend's death was not in vain.",
		BATWING="From one dark thing to another.",
		BATWING_COOKED="Well, he's still with me in spirit.",
		BEDROLL_FURRY="Ugh, I hope no one's watching this.",
		BUNNYMAN="This rabbit is cramping my style.",
		FLOWER_CAVE="Flower in the dark, how apt.",
		FLOWER_CAVE_DOUBLE="Flower in the dark, how apt.",
		FLOWER_CAVE_TRIPLE="Flower in the dark, how apt.",
		GUANO="It's still better then those filthy surface dwellers'.",
		LANTERN="A tiny prison, flickering with my burning despair",
		LIGHTBULB="Even in this place, I can't avoid your tyranny.",
		MANRABBIT_TAIL="Eugh, I'd rather have it's scat.",
		MUSHTREE_TALL  ="The darkness can bear the largest rewards.",
		MUSHTREE_MEDIUM="Yes, let the shadows bring you to life.",
		MUSHTREE_SMALL ="Frankly, you disappoint me.",
		RABBITHOUSE="Ugh, really? REALLY?!.",
		SLURTLE="Its existence is a metaphor for capitalism.",
		SLURTLE_SHELLPIECES="The broken pieces of society it leaves behind.",
		SLURTLEHAT="Its shield is what protects the world from true freedom.",
		SLURTLEHOLE="A den of greed and hatred.",
		SLURTLESLIME="Behold, the spoils of the free market.",
		SNURTLE="Is that you Mr President?",
		SPIDER_HIDER="Yes flee, flee from the truth.",
		SPIDER_SPITTER="This thing represents the media... or something.",
		SPIDERHOLE="So this is where the corruption gushes from.",
		STALAGMITE="The stone flows with determined vigor.",
		STALAGMITE_FULL="The stone flows with determined vigor.",
		STALAGMITE_LOW="The stone flows with determined vigor.",
		STALAGMITE_MED="The stone flows with determined vigor.",
		STALAGMITE_TALL="A joyous abundance of rocks!",
		STALAGMITE_TALL_FULL="A joyous abundance of rocks!",
		STALAGMITE_TALL_LOW="A joyous abundance of rocks!",
		STALAGMITE_TALL_MED="A joyous abundance of rocks!",
		TURF_FUNGUS="I walk over it like a tyrant.",
		TURF_MUD="I walk over it like a tyrant.",
		TURF_SINKHOLE="I walk over it like a tyrant.",
		TURF_UNDERROCK="I walk over it like a tyrant.",
		POWCAKE = "There are SO many preservatives in this thing.",		
		CAVE_ENTRANCE = 
		{
			GENERIC="It blocks my path to the land of the shadows.",
			OPEN = "I think I'm gunna like this place.",
		},
        CAVE_EXIT = "A return to the land of light and misery.",
		BOOMERANG = "An unwilling participant in the game of death.",
		MAXWELLPHONOGRAPH = "If he's heard of it, it's too mainstream for me.",
		ABIGAIL = "Wait, WHAT?! I call hacks!",
		PIGGUARD = "This is how the man keeps us down.",
		ADVENTURE_PORTAL = "Perhaps this device will lead me down the path of vengeance.",
		AMULET = "It contains a piece of my soul, it should be blacker.",
		ANIMAL_TRACK = "The mark of the colossus has scarred the earth",
		ARMORGRASS = "Have I really stooped this low?",
		ARMORMARBLE = "The weight of my shame is far greater.",
		ARMORWOOD = "I'm sure the termites will be just as safe.",
		ARMOR_SANITY = "Lightweight, fashionable, and only slightly demonic.",
		AXE = "Red rum, RED RUM!",
		BACONEGGS = "I made a little face that reflects the situation.",
		BABYBEEFALO = "The child has yet to discover the horrors of his own being.",
		BANDAGE = "It only serves to cover up the wounds that can never heal.",
		BASALT = "A monolith to the futility of it all.",
		BEARDHAIR = "I would ask where this came from... but it would be pointless.",
		BEDROLL_STRAW = "It's hard to say I'd rather be awake when I'm asleep.",
		BEE =
		{
			GENERIC = "A worker, shackled to the chains of industry.",
			HELD = "I have rescued you from your imprisonment.",
		},
		BEEBOX =
		{
			GENERIC = "Good god, I've become a capitalist!",
			READY = "The fruits of their toil is like blood on my hands.",
		},
		BEEFALO =
		{
			FOLLOWER = "Observe the follower, without free will or dignity.",
			GENERIC = "A revolting factory, creating unrest and feces.",
			NAKED = "Turns out I was wrong, they CAN become more unpleasant.",
			SLEEPING = "They're even horrible when they are at rest.",
		},
		BEEFALOHAT = "On second thought I'd rather freeze.",
		BEEFALOWOOL = "The mere fact that I have this disgusts me.",
		BEEHIVE = "A factory where young bees have their spirits broken.",
		BERRIES = "This fruit is at once meagre and substantial.",
		BERRIES_COOKED = "This will probably stain my sweater.",
		BERRYBUSH =
		{
			BARREN = "The life has been plucked from it.",
			GENERIC = "Perhaps an offering from some higher power",
			PICKED = "It has fallen victim to my greed.",
		},
		BIRDCAGE =
		{
			GENERIC = "Wow, I'm a monster.",
			OCCUPIED = "I'll tell myself it's for his own protection.",
			SLEEPING = "How can he sleep with what I've done to him?",
		},
		BIRDTRAP = "If I can't fly, then why should they?",
		BIRD_EGG = "A box without hinges, key or lid.",
		BIRD_EGG_COOKED = "I would not eat them on a train.",
		BISHOP = "I told you lightbulbs where evil!",
		BLOWDART_FIRE = "Hellfire, ready to be delivered.",
		BLUEGEM = "The color of sadness.",
		BLUEPRINT = "Why should I have to decide my own fate?",
		BLUE_CAP = "Why would I kill one of my own?",
		BLUE_CAP_COOKED = "I am such a hypocrite.",
		BLUE_MUSHROOM =
		{
			GENERIC = "A fungus after my own heart.",
			INGROUND = "I'm not the only one who hates the sun.",
			PICKED = "Who would do such a thing?",
		},
		BOARDS = "It bores me, maybe I should burn it.",
		BONESTEW = "Wow, this is like anti-vegetarianism.",
		BUGNET = "An instrument of abduction.",
		BUSHHAT = "This isn't what I meant by 'at one with nature'.",
		BUTTER = "Ewww, trans fats.",
		BUTTERFLY =
		{
			GENERIC = "An innocent, free of thought and misery.",
			HELD = "Oh how its life hangs by my whim.",
		},
		BUTTERFLYMUFFIN = "That'll teach you to fly beautiful and free!",
		BUTTERFLYWINGS = "And so ends the life of the innocent.",
		CAMPFIRE =
		{
			EMBERS = "Still clinging to light, still clinging to life.",
			GENERIC = "As painful to me as it is to the logs.",
			HIGH = "It's hunger will not be satiated.",
			LOW = "I can feel myself willing it to death.",
			NORMAL = "It burns as if to spite me.",
			OUT = "And good riddance.",
		},
		CANE = "The dead travel fast, what does that say of me?",
		CARROT = "Hmm, what rhymes with orange?",
		CARROT_COOKED = "Hmm, what rhymes with orange?",
		CARROT_PLANTED = "The earth tempts my thieving nature.",
		CAVE_FERN = "The darkness shows its true beauty.",
		CHARCOAL = "A remnant of a life long lost.",
		CHESTER = "He better not drool on my sweater.",
		CHESTER_EYEBONE =
		{
			GENERIC = "Quick lookin' at me.",
			WAITING = "I still don't miss him.",
		},
		COOKEDMANDRAKE = "The final nail in my sinful coffin.",
		COOKEDMEAT = "An innovation millions of years in the making.",
		COOKEDMONSTERMEAT = "Not even the fire can cleanse its soul.",
		COOKEDSMALLMEAT = "He probably deserved it.",
		COOKPOT =
		{
			COOKING_LONG = "Maybe I'll starve before it's done.",
			COOKING_SHORT = "This wont take long.",
			DONE = "Well, suppose I have to eat it now.",
			EMPTY = "Oh, of COURSE I have to do the cooking, misogynists.",
		},
		CROW =
		{
			GENERIC = "No, that one's too easy.",
			HELD = "He'll be flying nevermore.",
		},
		CORN = "I don't recognize it when its not in syrup form.",
		CORN_COOKED = "No nutritional value whatsoever.",
		CUTGRASS = "I have taken it's body, and used it for my own purposes.",
		CUTREEDS = "It's choice of dwelling suits its usefulness",
		CUTSTONE = "I have moulded the earth to my favour",
		DEERCLOPS = "HOLY MOTHER OF-!",
		DEERCLOPS_EYEBALL = "I guess if it bleeds...",
		DEVTOOL = "I'm not commenting on that.",
		DIRTPILE = "I... got nothin'.",
		DRAGONFRUIT = "It represents the danger in standing out.",
		DRAGONFRUIT_COOKED = "And that's what happens to those with unique ideals.",
		DRAGONPIE = "Yup, I just baked a pie.",
		DRUMSTICK = "I used to play the drums, well bongos anyway.",
		DRUMSTICK_COOKED = "Finger lickin' cruel!",
		DURIAN = "This fruit doesn't trust me, can't imagine why.",
		DURIAN_COOKED = "And that's why it was right not to trust me.",
		DIVININGROD =
		{
			COLD = "My course is far off.",
			GENERIC = "It seeks the unknown and the corrupt.",
			HOT = "It has found it's quarry!",
			WARM = "It leads me ever closer",
			WARMER = "I approach the device's destination",
		},
		EARMUFFHAT = "I have to turn in my animal rites badge now.",
		EGGPLANT = "I hate purple things.",
		EGGPLANT_COOKED = "It's like it's wrapped in a purple balloon.",
		EVERGREEN =
		{
			BURNING = "I probably shouldn't have done that.",
			BURNT = "Another blow to environmentalism.",
			CHOPPED = "I can feel myself running out of air already.",
			GENERIC = "A silent guardian, a humble oxygen factory.",
		},
		EVERGREEN_SPARSE =
		{
			BURNING = "I probably shouldn't have done that.",
			BURNT = "Another blow to environmentalism.",
			CHOPPED = "I can feel myself running out of air already.",
			GENERIC = "Mankind is responsible for this, somehow.",
		},
		EYEPLANT = "Mother earth's giving me that look again.",
		FARMPLOT =
		{
			GENERIC = "New life shall rise from the excrement.",
			GROWING = "Well at least the plant likes it.",
			NEEDSFERTILIZER = "It's hungry for crap.",
		},
		FEATHERHAT = "I don't want to wear that... thing.",
		FEM_PUPPET = "Oh what? I thought I was the first one here!",
		FIREFLIES =
		{
			GENERIC = "You would not believe your eyes.",
			HELD = "Their fading glow represents their spirit, imprisoned in my pocket.",
		},
		FIREHOUND = "Keep that thing away from me!",
		FIREPIT =
		{
			EMBERS = "Still clinging to light, still clinging to life.",
			GENERIC = "As painful to me as it is to the logs.",
			HIGH = "It's hunger will not be satiated.",
			LOW = "I can feel myself willing it to death.",
			NORMAL = "It burns as if to spite me.",
			OUT = "And good riddance.",
		},
		FIRESTAFF = "A tool of useless destruction.",
		FISH = "The Freakishly Fragrant Fish Flounders in the Foam.",
		FISHINGROD = "I'll exploit the hunger of others to satiate my own.",
		FISHSTICKS = "Plegh, reminds me of highschool.",
		FISHTACOS = "The innuendo is strong in this one.",
		FISH_COOKED = "This doesn't really count as meat.",
		FLINT = "As if the earth itself wants me to do harm.",
		FLOWER = "Roses are red, violets are... nope, can't finish that.",
		FLOWERHAT = "This is stupid.",
		FLOWER_EVIL = "Murders are red, cadavers are blue.",
		FOLIAGE = "Somewhere, Adam and Eve are naked.",
		FOOTBALLHAT = "What a barbaric sport.",
		FROG =
		{
			DEAD = "Croaked... hehe.",
			GENERIC = "He's hopping, but he's not happy.",
			SLEEPING = "Good night, sweet prince.",
		},
		FROGGLEBUNWICH = "I've Americanized them.",
		FROGLEGS = "It's French, so it's automatically better.",
		FROGLEGS_COOKED = "I cooked all the class out of them.",
		FRUITMEDLEY = "Finely, something I can eat without being a hypocrite.",
		GEARS = "The fruits of technological corruption.",
		GHOST = "Well, he completely destroys my ideology.",
		GOLDENAXE = "This is getting way too symbolic.",
		GOLDENPICKAXE = "Inexplicably hard gold? Or bizarrely soft rocks?",
		GOLDENPITCHFORK = "This is just silly.",
		GOLDENSHOVEL = "Now I can desecrate the earth is style.",
		GOLDNUGGET = "Here lies the root of all evil.",
		GRASS =
		{
			BARREN = "Only feces can breath new life into it.",
			BURNING = "One less source of life in the world.",
			GENERIC = "It's life is far more noble then mine.",
			PICKED = "Like the phoenix it shall rise again.",
		},
		GREEN_CAP = "Why would I kill one of my own?",
		GREEN_CAP_COOKED = "I am such a hypocrite.",
		GREEN_MUSHROOM =
		{
			GENERIC = "A fungus after my own heart.",
			INGROUND = "I'm not the only one who hates the sun.",
			PICKED = "Who would do such a thing?",
		},
		GUNPOWDER = "Excellent, now I can oppress the natives.",
		HAMBAT = "Meat is murder.",
		HAMMER = "What it cannot create it can only destroy.",
		HEALINGSALVE = "The suffering of the corrupt serves to ease that of the innocent.",
		HEATROCK =
		{
			COLD = "Now it's as useless as you'd expect.",
			GENERIC = "A rock filled with potential is still a rock.",
			HOT = "It burns with anger for what I've done to it.",
			WARM = "It still carries the memory of the flame.",
		},
		HOMESIGN = "Why is this thing so useless?",
		HONEY = "The golden spoils of a thousand broken workers.",
		HONEYCOMB = "You can feel the toil this structure has seen.",
		HONEYHAM = "How gluttonous of me.",
		HONEYNUGGETS = "Would you like fries with that?",
		HORN = "Poached for their ivory.",
		HOUND = "Everyone's a critic!",
		HOUNDBONE = "What remains of those who opposed the beasts.",
		HOUNDMOUND = "I bet they listen to thrash metal.",
		ICEBOX = "I bet Maxwell wants me to make him a sandwich.",
		ICEHOUND = "I hate you all so much!",
		INSANITYROCK =
		{
			ACTIVE = "What is this, I don't even...",
			INACTIVE = "Eh, I got nothin'.",
		},
		JAMMYPRESERVES = "This will probably stain my sweater.",
		KABOBS = "Skewered.",
		KILLERBEE =
		{
			GENERIC = "The cowardly enforcer bees, doing the queen's tyrannical bidding.",
			HELD = "You'll never hurt another worker.",
		},
		KNIGHT = "A knight in rusted armor, galloping across the wasteland.",
		KOALEFANT_SUMMER = "Please don't make me kill that thing.",
		KOALEFANT_WINTER = "Evolution shows its teeth once again.",
		KRAMPUS = "What... the F***... is THAT?!",
		KRAMPUS_SACK = "Huh, I like that goat thing's style.",
		LEIF = "What gives?! I stood up for you guys!",
		LEIF_SPARSE = "What gives?! I stood up for you guys!",
		LIGHTNING_ROD =
		{
			CHARGED = "It cringes with the pain of my continued survival.",
			GENERIC = "It exists to draw pain away from those more deserving.",
		},
		LITTLE_WALRUS = "A new generation of killers and thieves.",
		LIVINGLOG = "Nature is trying to guilt-trip me.",
		LOCKEDWES = "He's French, I think I'm in love.",
		LOG = "To think of all the time I spent protesting the logging industry.",
		LUREPLANT = "Mother nature takes back.",
		LUREPLANTBULB = "Natures wrath will never die.",
		MALE_PUPPET = "Oh what? I thought I was the first one here!",
		MANDRAKE =
		{
			DEAD = "It is now as I should be.",
			GENERIC = "It represents the fragility of innocence in nature.",
			PICKED = "And I shall lead it down the path of destruction.",
		},
		MANDRAKESOUP = "The final nail in my sinful coffin.",
		MANDRAKE_COOKED = "The final nail in my sinful coffin.",
		MARBLE = "Smooth and cold, hard and soulless.",
		MARBLEPILLAR = "It represents the slow decay of man's civilization.",
		MARBLETREE = "The hubris of man cannot replicate the miracle of nature.",
		MARSH_BUSH =
		{
			BURNING = "The Burning Brambles Blister in the Bog.",
			GENERIC = "It represents how my greed will only lead to pain.",
			PICKED = "OW! Do I even listen to myself?",
		},
		MARSH_PLANT = "And yet, still not as pointless as my own life.",
		MARSH_TREE =
		{
			BURNING = "The Burning Brambles Blister in the Bog.",
			BURNT = "Not really that upset about this one.",
			CHOPPED = "Nature's defences where of no use.",
			GENERIC = "This tree thinks itself safe from the forces of man.",
		},
		MAXWELL = "Time to dispense some poetic justice!",
		MAXWELLHEAD = "And people say I have an ego.",
		MAXWELLLIGHT = "Glowing with the hatred of the light it casts.",
		MAXWELLLOCK = "I wonder what fits in the hole.",
		MAXWELLTHRONE = "Well... that was anticlimactic.",
		MEAT = "Say goodbye to being vegan.",
		MEATBALLS = "Why do you keep making me eat this?",
		MEATRACK =
		{
			DONE = "I should take it before some random truckers steal it.",
			DRYING = "It's having the last of it's life breathed out of it.",
			GENERIC = "Now I can torture dead things.",
		},
		MEAT_DRIED = "I can feel myself getting dumber already.",
		MERM = "Jeez nature, what where you thinking?",
		MERMHEAD = "Even the savages can be savage.",
		MERMHOUSE = "Frankly I'm shocked its even that nice.",
		MINERHAT = "Great, bow I can ware my shame on my head.",
		MONSTERLASAGNA = "This is probably the worst thing I've ever cooked.",
		MONSTERMEAT = "Sometimes they deserve it.",
		MONSTERMEAT_DRIED = "A double-whammy of horribleness.",
		MOSQUITO =
		{
			GENERIC = "It cares not for the pain that it causes.",
			HELD = "At this point I deserve malaria.",
		},
		MOUND =
		{
			DUG = "A landfill, thoroughly unfilled",
			GENERIC = "That better be biodegradable.",
		},
		NIGHTLIGHT = "Bright, and yet dark, I like it.",
		NIGHTMAREFUEL = "The implications of this are nightmarish enough.",
		NIGHTSWORD = "HAHA! The power of darkness in the palm of my hand!",
		NITRE = "It may lead to my own destruction, but now it's completely useless.",
		ONEMANBAND = "Well, it's official, I've hit rock bottom.",
		PANFLUTE = "This is still animal cruelty, somehow.",
		PAPYRUS = "I should save this for my next poetry slam.",
		PENGUIN = "The Pack of Polar Penguins Pranced across the Prairie.",
		PERD = "He's still waiting for that Thanksgiving pardon.",
		PETALS = "It was far too gaudy for its own good.",
		PETALS_EVIL = "This are FAR less gaudy.",
		PICKAXE = "I shall rob the earth of it's natural resources.",
		PIGGYBACK = "I deserve a bucket of red paint for this.",
		PIGHEAD = "The Sombre Swine Skull Sticks Straight from the... sssssssssomthing.",
		PIGHOUSE =
		{
			FULL = "The pigs hide themselves from the nature they ravage.",
			GENERIC = "Why are my accommodations worse then the pigs?",
			LIGHTSOUT = "They fear what they cannot destroy and cannot control.",
		},
		PIGKING = "This is exactly what I was expecting.",
		PIGMAN =
		{
			DEAD = "In the end, nature retakes her claim.",
			FOLLOWER = "You're a tool to be used, nothing more.",
			GENERIC = "How metaphorical.",
			GUARD = "This is how the man keeps us down.",
			WEREPIG = "AHA! The beast of man shows its true form!",
		},
		PIGSKIN = "What can I do with this? It's pink!",
		PIGTORCH = "As if I didn't hate them enough.",
		PINECONE = 
		{
		    GENERIC = "I am unworthy to decide the fate of this creature.",
		    PLANTED = "The first positive thing I've done all day.",
		},
		PITCHFORK = "This isn't the kind of 'gothic' I had in mind.",
		PLANTMEAT = "Err, is this vegan?",
		PLANTMEAT_COOKED = "This is just weird.",
		PLANT_NORMAL =
		{
			GENERIC = "Nature offers her continued support.",
			GROWING = "Nature doesn't operate on my time frame.",
			READY = "Nature offers her continued support.",
		},
		POMEGRANATE = "It means to tempt me to the underworld.",
		POMEGRANATE_COOKED = "Hades is waiting with bated breath.",
		POND = "The origin of life, and mosquitoes",
		POOP = "Ew, ew, ew, ew, ew, no.",
		PUMPKIN = "I hate orange things.",
		PUMPKINCOOKIE = "Just like grandma used to make, before she was detained.",
		PUMPKIN_COOKED = "That just made it slimier.",
		PUMPKIN_LANTERN = "That's a bit blunt don't you think?",
		PURPLEGEM = "The color of... purple.",
		RABBIT =
		{
			GENERIC = "This wont end well for you.",
			HELD = "He probably hopes I'm taking him to a reserve.",
		},
		RABBITHOLE = "The miracle of birth has become less miraculous in there.",
		RAINOMETER = "En garde Misure Sole!",
		RATATOUILLE = "I'd prefer an autumn salad.",
		RAZOR = "I'm not allowed around razor blades anymore.",
		REDGEM = "The color of rage.",
		RED_CAP = "Well, this one deserved it.",
		RED_CAP_COOKED = "Not much of a mushroom in life or death.",
		RED_MUSHROOM =
		{
			GENERIC = "How can you stand this light?",
			INGROUND = "OI! Get up here and enjoy the darkness!",
			PICKED = "Who would do such a thing?",
		},
		REEDS =
		{
			BURNING = "It's seen worse.",
			GENERIC = "They grow amidst the mud and the evil.",
			PICKED = "It's seen worse.",
		},
		RESEARCHLAB = "And so begins my decent into industrialism.",
		RESEARCHLAB2 = "I descend further down the path of selfish creation.",
		RESEARCHLAB3 = "This has gotten kind of out of hand.",
		RESURRECTIONSTATUE = "That doesn't even look like me.",
		RESURRECTIONSTONE = "I've destroyed even my own mortality.",
		ROBIN =
		{
			GENERIC = "It represents the crimson lifeblood of the earth.",
			HELD = "I'm bleeding nature dry.",
		},
		ROBOT_PUPPET = "Should have known technology was behind this.",
		ROCK = "A testament to millions of years of erosion.",
		ROCKS = "It's hard to say something profound about rocks okay?.",
		ROPE = "Too bad these are all pine trees, and I don't have a chair.",
		ROTTENEGG = "Plegh, smells like capitalism.",
		SANITYROCK =
		{
			ACTIVE = "What is this, I don't even.",
			INACTIVE = "I... got nothin'.",
		},
		SAPLING =
		{
			BURNING = "It probably didn't deserve that.",
			GENERIC = "It's dreams of adulthood are ambitious at best.",
			PICKED = "It would do the same to me.",
		},
		SEEDS = "They will never know what horrors will befall them.",
		SEWING_KIT = "Oh, should I get an ironing board too? Maybe put on a dress?",
		SHOVEL = "Time to dig up some incriminating evidence.",
		SILK = "NOT. WORTH. THE EFFORT.",
		SKELETON = "His bones shine whiter then even the purest soul.",
		SKULLCHEST = "I should save that for my apartment.",
		SMALLBIRD =
		{
			GENERIC = "You're not cute, you're just oddly proportioned",
			HUNGRY = "Oh great, it wants me to keep it alive.",
			STARVING = "Must... resist... urge to feed...",
		},
		SMALLMEAT = "There goes my vegetarianism.",
		SMALLMEAT_DRIED = "I should just open a gas station and get it over with.",
		SPEAR = "So long conscientious objector status.",
		SPIDER =
		{
			DEAD = "Nope, can't be sad about this one.",
			GENERIC = "A creature of pure iccyness",
			SLEEPING = "Uhg.",
		},
		SPIDERDEN = "The corruption spreads through the land like a plague.",
		SPIDEREGGSACK = "Horribleness, from concentrate.",
		SPIDERGLAND = "Do I want my wounds healed THAT badly?",
		SPIDERHAT = "Well, it's not the worst thing I've put on my head.",
		SPIDERQUEEN = "Wow, ok, can I NOT get near that please?",
		SPIDER_WARRIOR =
		{
			DEAD = "Its armor was to no avail.",
			GENERIC = "Because that's what I needed, something worse then spiders.",
			SLEEPING = "Aww how adorable... that was sarcasm.",
		},
		SPOILED_FOOD = "Nature reclaims her bounty.",
		STATUEHARP = "Plegh, tacky.",
		STATUEMAXWELL = "And they said I was full of myself.",
		STUFFEDEGGPLANT = "It's like a groady water balloon.",
		STINGER = "The prosperity of the hive means the death of the worker.",
		STRAWHAT = "Why would I ware this?",
		TAFFY = "Comfort food for the uncomfortable.",
		SUNKBOAT = "I'm not sure whether to be mad at or proud of the irony.",
		TALLBIRD = "Evolution plays cruel tricks on it's creations",
		TALLBIRDEGG = "I should cook this before my maternal instinct kicks in.",
		TALLBIRDEGG_COOKED = "Whew, dodged an awkward bullet there.",
		TALLBIRDEGG_CRACKED =
		{
			COLD = "It can't handle the darkness, weakling.",
			GENERIC = "Oh-no, maternal instinct... kicking in.",
			HOT = "I hate the fire too.",
			LONG = "This might take longer then I thought.",
			SHORT = "There's still time, I can still back out of this!",
		},
		TEENBIRD =
		{
			GENERIC = "*snif* He's grown up so fast...",
			HUNGRY = "Don't worry child, I'll provide for you!",
			STARVING = "AH JEEZ! That's what I get for learning to love!",
		},
		TELEPORTATO_BASE =
		{
			ACTIVE = "Hopefully this next world has a coffee house.",
			GENERIC = "New beginnings will only lead to new endings.",
			LOCKED = "Whatever it is, it does not wish to involve me.",
			PARTIAL = "Its construction proceeds despite its reluctance.",
		},
		TELEPORTATO_BOX = "I can feel a force inside, wishing for my death.",
		TELEPORTATO_CRANK = "The machinations of pure evil are probably worth lugging around.",
		TELEPORTATO_POTATO = "Its importance isn't reflected in it's appearance.",
		TELEPORTATO_RING = "Sorry Maxwell, I'm already engaged to my ideals.",
		TELESTAFF = "What could go wrong?",
		TENT = "The closest thing to the indoors I'll see in a while.",
		TENTACLE = "As if the forces of hell where reaching through the earth.",
		TENTACLESPOTS = "You'd think a hellspawn would be too cool for polkadots.",
		TENTACLESPIKE = "Its destruction will now serve my own.",
        TENTACLE_PILLAR = "Well, this raises a few questions.",
        TENTACLE_PILLAR_ARM = "Its children are no less horrible!",
        TENTACLE_GARDEN = "This raises further questions.",
		TOPHAT = "This is way to vaudevillian for my tastes.",
		TORCH = "A tiny testament to my hatred.",
		TRAP = "Now I can abuse creatures smaller then me for my own gain.",
		TRAP_TEETH = "Those dogs will rue the day they grew teeth.",
		TRAP_TEETH_MAXWELL = "I shouldn't have to deal with this.",
		TREASURECHEST = "To store my worldly possessions.",
		TRINKET_1 = "Their unity betrays their purpose.",
		TRINKET_10 = "I hope I die before I get old.",
		TRINKET_11 = "It says 'Everyone loves your poetry'.",
		TRINKET_12 = "It's been a victim of scientific cruelty.",
		TRINKET_3 = "Its been imprisoned by its own self.",
		TRINKET_7 = "Great, now I can kill time until time kills me.",
		TRUNKVEST_SUMMER = "I deserve a bucket of red paint for this.",
		TRUNKVEST_WINTER = "This way I can live long enough to kill more innocent animals.",
		TRUNK_COOKED = "I guess it would have been worse if I didn't.",
		TRUNK_SUMMER = "Wait, where'd the rest of it go?.",
		TRUNK_WINTER = "Welp, that makes me a poacher.",
		TWIGS = "The severed limbs of a small child.",
		UMBRELLA = "To protect myself from nature's tears of pain.",
		WALL_HAY = "Not only is it wasteful, it's also useless.",
		WALL_STONE = "Designed to keep the world at a safe distance.",
		WALL_WOOD = "A warning to trees to beware my selfishness.",
		WALRUS = "His taste in fashion is just as deadly.",
		WALRUSHAT = "My taste in fashion has just taken a major downturn.",
		WALRUS_CAMP =
		{
			EMPTY = "They're out, having their way with the world.",
			GENERIC = "I mustn't disturb the bitterness of their life.",
		},
		WALRUS_TUSK = "His tooth will serve as a memorial to his cruelty.",
		WASPHIVE = "That's less of a factory, and more of an militia",
		WINTERHAT = "I feel warmer, but also dumber.",
		WINTEROMETER = "The meter reflects my hopefulness for my future.",
		WORMHOLE =
		{
			GENERIC = "The beast feeds on the minds of the impatient.",
			OPEN = "Maybe I should wrap myself in plastic first.",
		},
	}

return MakePlayerCharacter("winnifred", prefabs, assets, fn)