local Screen = require "widgets/screen"
local Button = require "widgets/animbutton"
require "widgets/image"
require "components/uianim"

local assets=
{

	Asset("IMAGE", "images/global.tex"),
	Asset("ATLAS", "images/global.xml"),

	Asset("IMAGE", "scripts/images/wall_cave_01.tex"),
	Asset("ATLAS", "scripts/images/wall_cave_01.xml"),

}

KeyScreen = Class(Screen, function(self, buttons, texthalign, additionaltext, textsize, timeout)
	Screen._ctor(self, "KeyScreen")


	--below uses Klei's gray background with tint:
    self.bg = self:AddChild(Image("images/ui.xml", "bg_plain.tex"))
	self.bg:SetTint(BGCOLOURS.RED[1],BGCOLOURS.RED[2],BGCOLOURS.RED[3], 1)
    --self.bg = self:AddChild(Image("mods/Test Tools/scripts/images/bg_red.xml", "bg_red.tex"))
    self.bg:SetVRegPoint(ANCHOR_MIDDLE)
    self.bg:SetHRegPoint(ANCHOR_MIDDLE)
    self.bg:SetVAnchor(ANCHOR_MIDDLE)
    self.bg:SetHAnchor(ANCHOR_MIDDLE)
    self.bg:SetScaleMode(SCALEMODE_FILLSCREEN)
    
	self.root = self:AddChild(Widget("ROOT"))
    self.root:SetVAnchor(ANCHOR_MIDDLE)
    self.root:SetHAnchor(ANCHOR_MIDDLE)
    self.root:SetPosition(0,0,0)
    self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)

	menu
	local button_w = 200
	local space_between = 20
	local spacing = button_w + space_between
	
	self.menu = self:AddChild(Widget("menu"))
	local total_w = #buttons*button_w
	if #buttons > 1 then
		total_w = total_w + space_between*(#buttons-1) 
	end
	
	self.menu:SetHAnchor(ANCHOR_MIDDLE)
	self.menu:SetVAnchor(ANCHOR_MIDDLE)
	self.menu:SetPosition(-(total_w / 2) + button_w/2, -120,0) 

	-- buttons
	local pos = Vector3(400,-210,0)
	for k,v in ipairs(buttons) do
		local button = self.menu:AddChild(AnimButton("button"))
	    button:SetPosition(pos)
	    button:SetText(v.text)
	    if v.nopop == true then
	    	button:SetOnClick( function() v.cb() end )
	    else
	    	button:SetOnClick( function() TheFrontEnd:PopScreen(self) v.cb() end )
	    end
		button.text:SetColour(0,0,0,1)
	    button:SetFont(BUTTONFONT)
	    button:SetTextSize(40)    
	    pos = pos + Vector3(spacing, 0, 0)  
	end

	if timeout then
		self.timeout = timeout
	end
	
	self.buttons = buttons
	
	-- footer text
	local footer = self:AddChild(Text(NUMBERFONT, 28))
	footer:SetHAnchor(ANCHOR_MIDDLE)
	footer:SetVAnchor(ANCHOR_BOTTOM)
    footer:SetPosition(0, 150, 0)
    footer:SetString("Please note: map hiding requires saving to the main menu and reloading the save game.")
	
	-- commands text
	local commands = self:AddChild(Text(DIALOGFONT, 22))
	commands:SetHAnchor(ANCHOR_MIDDLE)
	commands:SetVAnchor(ANCHOR_BOTTOM)
	commands:SetRegionSize(1000, 100)
	commands:EnableWordWrap(true)
    commands:SetPosition(0, 275, 0)
    commands:SetString("Console commands: UnlockCharacters(), Spawn(name, count), SpawnInv(name,count), OpenMenu(), ToggleGodMode(), ToggleRain(), ToggleSpeed(multiplier), ToggleTimeScale(), Freebuild(), CharacterSelect(), MapHide(), MapReveal(), NextSeason(), NextDay(), NextPhase()")
	
	local spawning = {}
	table.insert(spawning, {"Ctrl + X = Spawn item"})
	table.insert(spawning, {"Ctrl + T = Spawn food"})
	table.insert(spawning, {"Shift + Z = Spawn entity"})
	table.insert(spawning, {"Shift + O = Spawn object"})	-- change from R to O -tehmug
	table.insert(spawning, {"Alt + L = Spawn Magic item"})	-- for magic items -tehmug
	table.insert(spawning, {"Shift + X/T = Spawn at mouse"})
	
	local toggles = {}
	table.insert(toggles, {"Ctrl + F = Free crafting"})
	table.insert(toggles, {"Ctrl + R = Speed boost"})
	table.insert(toggles, {"Ctrl + G = God mode"})
	table.insert(toggles, {"Ctrl + V = Time scale "})
	table.insert(toggles, {"Ctrl + I = Rain"})	
	
	local misc = {}
	table.insert(misc, {"Shift + C = Change character"})
	table.insert(misc, {"Shift+ G = Next phase"})
	table.insert(misc, {"Shift + F = Next day"})
	table.insert(misc, {"Ctrl + Z = Next season"})
	table.insert(misc, {"Shift + P = Delete under mouse"})	-- change from B to P -tehmug
	table.insert(misc, {"Alt+ R = Reveal map"})	
	table.insert(misc, {"Alt + T = Hide map"})	
	
	local teleport = {}
	table.insert(teleport, {"Ctrl + Shift + Left Click = Teleport to cursor"})
	table.insert(teleport, {"Ctrl + Right Click = Bookmark location"})
	table.insert(teleport, {"Shift + Right Click = Teleport to bookmark"})
	
	local spawningPos = {-450, 200, 0}
	self:AddGroups(spawning, spawningPos, "Spawning")
	
	local togglesPos = {-200, 200, 0}
	self:AddGroups(toggles, togglesPos, "Toggles")	
		
	local miscPos = {50, 200, 0}
	self:AddGroups(misc, miscPos, "Misc")
	
	local teleportPos = {400, 200, 0}
	self:AddGroups(teleport, teleportPos, "Teleporting")	
end)

function KeyScreen:AddGroups(data, offset, header)
	local position = { 0, 0, 0 }
	if offset then
		position[1] = position[1] + offset[1]
		position[2] = position[2] + offset[2]
		position[3] = position[3] + offset[3]
	end

	local master = self:AddChild(Text(TITLEFONT, 34, header))
	master:SetVAnchor(ANCHOR_MIDDLE)
	master:SetHAnchor(ANCHOR_MIDDLE)
	master:SetPosition(position[1], position[2], position[3])
	
	local group = master:AddChild( Widget( "TestGroup" ) )
	group:SetPosition(0, -20, 0) 
	
	local fontSize = 22
	local label_width = 275
	
	for index,entry in ipairs(data) do
		local text = group:AddChild( Text(DEFAULTFONT, fontSize, entry[1]))
		text:SetPosition( 0, index * -25, 0 )
		--text:SetRegionSize(label_width, 40)
		--text:EnableWordWrap(true)
	end
end

function KeyScreen:OnUpdate( dt )
	if self.timeout then
		self.timeout.timeout = self.timeout.timeout - dt
		if self.timeout.timeout <= 0 then
			self.timeout.cb()
		end
	end
	return true
end

function KeyScreen:OnKeyUp( key )
	if key == KEY_ENTER or key == KEY_ESCAPE then
		if self.buttons[1] then
			TheFrontEnd:PopScreen(self) self.buttons[1].cb()
		end
	end
end