local Screen = require("widgets/screen")
local Widget = require("widgets/widget")
local Spinner = require("widgets/spinner")
local NumericSpinner = require("widgets/numericspinner")
local Text = require("widgets/text")
local AnimButton = require("widgets/animbutton")
local UIAnim = require("widgets/uianim")
--require("util")
--require("widgets/button")
--require("widgets/animbutton")
--require("widgets/image")
--require("components/uianim")

--require("widgets/numericspinner")
--require("screens/popupdialog")

--require("widgets/toggle")
--require("screens/keyscreen")
local build_info = require "testtools.builds"
local spinner_atlas = "images/ui.xml"

local spinner_images = {
	arrow_normal = "spin_arrow.tex",
	arrow_over = "spin_arrow_over.tex",
	arrow_disabled = "spin_arrow_disabled.tex",
	bgtexture = "spinner.tex"
}

local text_font = DEFAULTFONT

local enableDisableOptions = { { text = "NO", data = false }, { text = "YES", data = true } }

local entityOptions = {
	{text = "ȸǶ", data = "abigail"},
	{text = "Сţ ", data = "babybeefalo"},
	{text = "", data = "bat"}, -- E
	{text = "۷", data = "bee"},
	{text = "Ƥ¦ţ", data = "beefalo"},
	{text = "Ȯ", data = "icehound"},
	{text = "", data = "butterfly"},
	{text = "˹", data = "chester"},
	{text = "", data = "bishop"},
	{text = "ʿ", data = "knight"},
	{text = "־廯1", data = "crawlinghorror"},
	{text = "ѻ", data = "crow"},
	{text = "¹", data = "deerclops"},
	{text = "ʳ˻", data = "eyeplant"},-- E
	{text = "Ȯ", data = "firehound"},
	{text = "", data = "frog"},
	{text = "", data = "ghost"},
	{text = "", data = "perd"},
	{text = "Ȯ", data = "hound"},
	{text = "ɱ˷", data = "killerbee"},
	{text = "˹", data = "krampus"},
	{text = "ʳ˻", data = "lureplant"},
	{text = "", data = "walrus"},
	{text = "", data = "mandrake"},
	{text = "˹", data = "maxwell"},	
	{text = "ķ", data = "merm"},
	{text = "", data = "monkey"},-- E
	{text = "Ͱ", data = "monkeybarrel"},-- E
	{text = "", data = "mosquito"},
	{text = "", data = "penguin"},-- E
	{text = "", data = "pigguard"},
	{text = "", data = "pigking"},
	{text = "", data = "pigman"},
	{text = "", data = "rabbit"},
	{text = "", data = "robin"},
	{text = "Ϻ", data = "rocky"},-- E
	{text = "־廯", data = "shadowskittish"},
	{text = "", data = "slurper"},
	{text = "ţ", data = "slurtle"}, -- E
	{text = "С", data = "smallbird"},
	{text = "֩ ", data = "spider"},
	{text = "֩", data = "spiderqueen"},
	{text = " ", data = "spider_warrior"},
	{text = "Ѩ", data = "spider_hider"}, -- E
	{text = "²۵", data = "spider_spitter"}, -- E
	{text = "", data = "koalefant_summer"},
	{text = "", data = "tallbird"},
	{text = "", data = "teenbird"},
	{text = "", data = "tentacle"},
	{text = "־廯", data = "terrorbeak"},
	{text = "С", data = "tentacle_pillar_arm"},-- E
	{text = "", data = "leif"},
	{text = "ܺ", data = "little_walrus"},
	{text = "", data = "koalefant_winter"},
	{text = "", data = "robin_winter"},
	{text = "ϡ", data = "leif_sparse"},
	{text = "𻵵Ļе1", data = "chessjunk1"},
	{text = "𻵵Ļе2", data = "chessjunk2"},
	{text = "𻵵Ļе3", data = "chessjunk3"},
} 

local uncraftableItemOptions = { 
	{text = "ҽ", data = "ash"},
	{text = "Ѫ֮", data = "batbat"}, -- I
	{text = "", data = "beardhair"},
	{text = "۷", data = "bee"},
	{text = "ţ", data = "horn"},
	{text = "ţë", data = "beefalowool"},
	{text = "ʯ", data = "bluegem"},
	{text = "ë", data = "manrabbit_tail"}, -- I
	{text = "", data = "butterfly"},
	{text = "ľ̿", data = "charcoal"},
	{text = "˹۹", data = "chester_eyebone"},
	{text = "", data = "compass"},-- I
	{text = "ѻë", data = "feather_crow"},
	{text = "", data = "cutgrass"},
	{text = "õ«έ", data = "cutreeds"},
	{text = "¹", data = "deerclops_eyeball"},
	{text = "̽ħ", data = "diviningrod"},
	{text = "ľ1", data = "dug_berrybush"},
	{text = "ľ2", data = "dug_berrybush2"},
	{text = "ݸ", data = "dug_grass"},
	{text = "", data = "dug_sapling"},
	{text = "ө", data = "fireflies"},
	{text = "ʯ", data = "flint"},
	{text = "", data = "gears"},
	{text = "", data = "goldnugget"},
	{text = "", data = "guano"}, -- I
	{text = "", data = "honeycomb"},
	{text = "", data = "houndstooth"},
	{text = "˹", data = "krampus_sack"},
	{text = "", data = "lantern"},-- I
	{text = "", data = "lightbulb"}, -- I
	{text = "", data = "lighter"},-- I
	{text = "֮ľ", data = "livinglog"},
	{text = "ľͷ", data = "log"},
	{text = "˻", data = "lureplantbulb"},-- I
	{text = "L", data = "lucy"},-- I
	{text = "ʯ", data = "marble"},
	{text = "", data = "poop"},
	{text = "جƬ", data = "nightmarefuel"},
	{text = "ʯ", data = "nitre"},
	{text = "Ƥ", data = "pigskin"},
	{text = "ɹ", data = "pinecone"},
	{text = "챦ʯ", data = "redgem"},
	{text = "ë", data = "feather_robin"},
	{text = "ʯͷ", data = "rocks"},
	{text = "˿ ", data = "silk"},
	{text = "ţñ", data = "slurtlehat"}, -- I
	{text = "ţ", data = "armorsnurtleshell"}, -- I
	{text = "ճҺ", data = "slurtleslime"}, -- I
	{text = "֩뵰", data = "spidereggsack"},
	{text = "֩", data = "spidergland"},
	{text = "Ůñ", data = "spiderhat"},
	{text = "", data = "stinger"},
	{text = "", data = "trunk_summer"},
	{text = "ñ", data = "walrushat"},
	{text = "", data = "tent"}, 
	{text = "", data = "tentaclespike"},
	{text = "Ƥ", data = "tentaclespots"},
	{text = "ɭֵƤ", data = "turf_forest"},
	{text = "ݵصƤ", data = "turf_grass"},
	{text = "Ƥ", data = "turf_marsh"},
	{text = "صƤ", data = "turf_rocky"},
	{text = "ȴԭƤ", data = "turf_savanna"},
	{text = "֦", data = "twigs"},
	{text = "", data = "walrus_tusk"},
	{text = "", data = "trunk_winter"},
	{text = "ë", data = "feather_robin_winter"},
        {text = "ë", data = "manrabbit_tail"},
        {text = "׺ʳ֮Ƥ", data = "slurper_pelt"},
        {text = "ʯ", data = "thulecite"},
        {text = "Զػ߽", data = "minotaurhorn"},
        {text = "", data = "lightbulb"},
        {text = "ƽݲ", data = "goldenpitchfork"},
        {text = "๦ܹ", data = "multitool_axe_pickaxe"},
        {text = "ԶŶ̰", data = "ruins_bat"},
        {text = "", data = "armorruins"},
        {text = "", data = "armorslurper"},
        {text = "Զ", data = "ruinshat"},
        {text = "ҹħ", data = "armor_sanity"},
        {text = "ʯ", data = "armormarble"},
	{text = "Ӱ", data = "waxwelljournal"},
        {text = "ë", data = "featherfan"},
        {text = "ë", data = "beargervest"},
        {text = "ѿ", data = "armordragonfly"},
        {text = "Τͷ", data = "waxwelljournal"},
        {text = "ñ", data = "molehat"},
        {text = "", data = "raincoat"},
        {text = "άñ", data = "wathgrithrhat"},
        {text = "ñ", data = "catcoonhat"},
        {text = "ñ", data = "watermelonhat"},
        {text = "ñ", data = "icehat"},
        {text = "Զ", data = "bell"},
        {text = "ì", data = "spear_wathgrithr"},
}       

local foodItemOptions = {
	{text = "", data = "baconeggs"},
	{text = "Ѩ㽶", data = "cave_banana"},-- T
	{text = "Ѩ", data = "cave_banana_cooked"},-- T
	{text = "", data = "berries"},
	{text = "Ģ", data = "blue_cap"},
	{text = "", data = "eggplant_cooked"},
	{text = "ʵɱ", data = "butterflymuffin"},
	{text = "", data = "butterflywings"},
	{text = "", data = "butter"},
	{text = "ܲ", data = "carrot"},
	{text = "", data = "dragonfruit_cooked"},
	{text = "", data = "durian_cooked"},
	{text = "", data = "fish_cooked"},
	{text = "", data = "froglegs_cooked"},
	{text = "", data = "cookedmonstermeat"},
	{text = "", data = "cookedmandrake"},
	{text = "", data = "cookedmeat"},
	{text = "С", data = "cookedsmallmeat"},
	{text = "", data = "corn"},
	{text = "ħ", data = "petals_evil"},
	{text = "ʺʢ", data = "deadlyfeast"}, ---------------------------- no image
	{text = "", data = "dragonfruit"},
	{text = "", data = "dragonpie"},
	{text = "", data = "drumstick"},
	{text = "", data = "durian"},
	{text = "", data = "eggplant"},
	{text = "", data = "fish"},
	{text = "", data = "fishsticks"},
	{text = "ըױ", data = "fishtacos"},
	{text = "ը", data = "drumstick_cooked"},
	{text = "", data = "tallbirdegg_cooked"},
	{text = "", data = "froglegs"},
	{text = "", data = "frogglebunwich"},
	{text = "ˮɳ", data = "fruitmedley"},
	{text = "Ģ", data = "green_cap"},
	{text = "", data = "honey"},
	{text = "ۻ", data = "honeyham"},
	{text = "۽ש", data = "honeynuggets"},
	{text = "", data = "jammypreserves"},
	{text = "", data = "trunk_cooked"},
	{text = "⴮", data = "kabobs"},
	{text = "", data = "mandrake"},
	{text = "", data = "mandrakesoup"},
	{text = "", data = "meat"},
	{text = "", data = "meatballs"},
	{text = "", data = "bonestew"},
	{text = "", data = "monsterlasagna"},
	{text = "", data = "monstermeat"},
	{text = "С", data = "smallmeat"},
	--{text = "ʲô", data = "maxwelllock"},
	{text = "", data = "petals"},
	{text = "Բֱ", data = "perogies"},
	{text = "ʯ", data = "pomegranate"},
	{text = "׻", data = "corn_cooked"},
	{text = "֥ʿ", data = "powcake"}, -- T
	{text = "Ϲ", data = "pumpkin"},
	{text = "Ϲ", data = "pumpkincookie"},
	{text = "", data = "ratatouille"},
	{text = "Ģ", data = "red_cap"},
	{text = "", data = "berries_cooked"},
	{text = "ܲ", data = "carrot_cooked"},
	{text = "", data = "spoiled_food"},
	{text = "", data = "rottenegg"},
	{text = "", data = "seeds"},
	{text = "ӰԿ", data = "maxwellkey"},
	{text = "ʯ", data = "pomegranate_cooked"},
	{text = "ըѺ", data = "stuffedeggplant"},
	{text = "̫", data = "taffy"},
	{text = "", data = "tallbirdegg"},
	{text = "", data = "seeds_cooked"},
	{text = "𼦴", data = "turkeydinner"},
	{text = "", data = "waffles"},
	{text = "ʧ", data = "wetgoop"},
	{text = "ܲ", data = "carrot_seeds"},
	{text = "", data = "durian_seeds"},
	{text = "", data = "eggplant_seeds"},
	{text = "ʯ", data = "pomegranate_seeds"},
	{text = "", data = "dragonfruit_seeds"},
	{text = "Ϲ", data = "pumpkin_seeds"},
	{text = "", data = "eel"},
	{text = "", data = "eel_cooked"},
	{text = "Զųӹ", data = "wormlight"},
                    {text = "", data = "dragonfruit_seeds"},
                    {text = "", data = "acorn"},
                    {text = "", data = "cactus_meat"},
}

local objectOptions = {
	{text = "", data = "balloon"},-- O
	{text = "㽶", data = "cave_banana_tree"},-- O
	{text = "1", data = "basalt_pillar"},
	{text = "2", data = "basalt"},
	{text = "", data = "beehive"},
	{text = "۷", data = "beemine"},
	{text = "", data = "berrybush"},
	{text = "2", data = "berrybush2"},
	{text = "", data = "birdtrap"},
	--{text = "Bonfire", data = "bonfire"},
	{text = "ʯͷ1", data = "rock1"},
	{text = "ʯͷ2", data = "rock2"},
	{text = "ʯͷ3", data = "rock_flintless"}, 
	{text = "", data = "bunnyman"}, -- O
	{text = "", data = "rabbithouse"}, -- O
	{text = "Ѩ", data = "cave_entrance"}, -- O
	{text = "Ѩ", data = "flower_cave"}, -- O
	{text = "ħȵ", data = "diviningrodbase"},
	{text = "ħ", data = "diviningrodstart"},
	{text = "ս", data = "evergreen_burnt"},
	{text = "", data = "evergreen_normal"},
	{text = "С", data = "evergreen_short"},
	{text = "׮", data = "evergreen_stump"},
	{text = "", data = "evergreen_tall"},
	{text = "а", data = "flower_evil"},
	{text = "ާ", data = "cave_fern"},-- O
	{text = "ө", data = "fireflies"},
	{text = "", data = "flower"},
	{text = "", data = "grass"},
	{text = "Ĺ", data = "gravestone"},
	{text = "ʯ", data = "statueharp"},
	{text = "ʬ", data = "houndbone"},
	{text = "", data = "houndmound"},
	{text = "ɱ˷", data = "wasphive"},
	{text = "ж", data = "evergreen_sparse_normal"},
	{text = "С", data = "evergreen_sparse_short"},
	{text = "", data = "evergreen_sparse_tall"},
	{text = "סά˹", data = "lockedwes"},
	{text = "", data = "lightning_rod"}, 
	{text = "ʯ", data = "marblepillar"},
	{text = "ʯ", data = "marbletree"},
	{text = "̹ľ", data = "marsh_bush"},
	{text = "ߵֲ", data = "marsh_plant"},
	{text = "", data = "marsh_tree"},
	{text = "סm/waxwell", data = "maxwellendgame"},
	{text = "˹ĵ", data = "statuemaxwell"},
	{text = "ϵ˹", data = "maxwellthrone"},
	{text = "˹", data = "trap_teeth_maxwell"},
	{text = "˹֮", data = "adventure_portal"},
	--{text = "Maxwell Head", data = "maxwellhead"},
	{text = "˹֮", data = "maxwelllight"},
	{text = "˹", data = "maxwellphonograph"},
	{text = "", data = "resurrectionstatue"},
	{text = "ͷ", data = "mermhead"},
	{text = "", data = "mermhouse"},
	{text = "ض", data = "mound"},
	{text = "Ģ", data = "mushtree_tall"}, -- O
	{text = "Ģ", data = "mushtree_medium"}, -- O
	{text = "Ģ", data = "mushtree_small"}, -- O
	{text = "Ģ", data = "blue_mushroom"},
	{text = "Ģ", data = "green_mushroom"},
	{text = "Ģ", data = "red_mushroom"},
	{text = "ԲзⱮ", data = "sanityrock"},
	{text = "ԲзⱮ", data = "insanityrock"},
	{text = "ͷ", data = "pighead"},
	{text = "", data = "pighouse"},
	{text = "ͷ", data = "pigtorch"},
	{text = "ڵĺܲ", data = "carrot_planted"},
	{text = "ܳ", data = "pond"},
	{text = "ӳ", data = "pond_mos"},
        {text = "", data = "pond_cave"},
	{text = "Ӷ", data = "rabbithole"},
	{text = "", data = "rainometer"}, 
	{text = "«έ", data = "reeds"},
	{text = "Խʯ", data = "resurrectionstone"}, 
	{text = "֦", data = "sapling"},
	{text = "һԳ涴", data = "wormhole_limited_1"},
	{text = "Ǽ", data = "skeleton"},
	{text = "֩1", data = "spiderden"},
	{text = "֩2", data = "spiderden_2"},
	{text = "֩3", data = "spiderden_3"},
	{text = "Ѩʯ1", data = "stalagmite"}, -- O
	{text = "ʯ2", data = "stalagmite_tall"},-- O
	{text = "߽", data = "tallbirdnest"},
	{text = "͵", data = "teleportato_base"},
	{text = "Ǵͻ", data = "telebase"},-- O
	{text = "ͻ1", data = "teleportato_box"},
	{text = "ͻ2", data = "teleportato_crank"},
	--{text = "Teleportato End", data = "teleportato_checkmate"}, --no longer works
	{text = "ͻ3", data = "teleportato_potato"},
	{text = "ͻ4", data = "teleportato_ring"},
	{text = "", data = "tentacle_garden"},-- O
	{text = "", data = "trap_teeth"},
	{text = "Խʯ", data = "resurrectionstone"},
	{text = "ǽ", data = "wall_hay"},
	{text = "ʯǽ", data = "wall_stone"},
	{text = "ľǽ", data = "wall_wood"},
	{text = "", data = "walrus_camp"},
	{text = "¶ȼ", data = "winterometer"}, 
	{text = "涴", data = "wormhole"},
        {text = "𻵵Զż̳", data = "ancient_altar_broken"},
        {text = "Զż̳", data = "ancient_altar"},
	{text = "", data = "minotaurchest"},
	{text = "ʯ̨", data = "gemsocket"},
        {text = "", data = "eyeturret"},
        {text = "ɽ", data = "rock_light"},
        {text = "ܶ", data = "catcoonden"},
        {text = "ɽ", data = "rock_ice"},
        {text = "ŵ", data = "statueglommer"},
        {text = "ˮ", data = "pond_algae"},
        {text = "", data = "cactus"},
        {text = "", data = "tumbleweed"},
        {text = "¹Ѽ", data = "moose"},
        {text = "", data = "warg"},
        {text = "", data = "dragonfly"},
        {text = "", data = "bearger"},
        {text = "", data = "bigfoot"},
        {text = "۷ɳ", data = "glommer"},
        {text = "ɽ", data = "lightninggoat"},
        {text = "ʯͷ", data = "coldfirepit"},
        {text = "˯", data = "siestahut"},
}
local index_2_Options = {
	{text = "", data = "book_sleep"},-- M
	{text = "ʵ԰ѧ", data = "book_gardening"},-- M
	{text = "ĩ", data = "book_brimstone"},-- M
	{text = "", data = "book_birds"},-- M
	{text = "", data = "book_tentacles"},-- M
	{text = "ϱʯ", data = "purplegem"},-- M
	{text = "ʯ", data = "bluegem"},-- M
	{text = "챦ʯ", data = "redgem"},-- M
	{text = "ȱʯ", data = "orangegem"},--- M
	{text = "Ʊʯ", data = "yellowgem"},-- M
	{text = "̱ʯ", data = "greengem"},-- M
	{text = "ħ", data = "icestaff"},-- M
	{text = "ħ", data = "firestaff"},-- M
	{text = "ħ", data = "telestaff"},-- M
	{text = "˲ħ", data = "orangestaff"},-- M
	{text = "ƻ", data = "greenstaff"},-- M
	{text = "ٻ", data = "yellowstaff"},-- M
}
-- Updates --
local spinnerFont = {font = text_font, size = 24} --30
local spinnerHeight = 48 --64

TestScreen = Class(Screen, function(self, displayed)
	Screen._ctor(self, "TestScreen")

	local graphicsOptions = TheFrontEnd:GetGraphicsOptions()

	self.options = {
		entityPrefab = nil,
		itemPrefab = nil,
		foodPrefab = nil,
		objectPrefab = nil,
		item_2_Prefab = nil,
	}

	local indexTable = {}

	indexTable = self:RetrieveIndices()

	self.entityIndex = indexTable[1] or 1
	self.itemIndex = indexTable[2] or 1
	self.foodIndex = indexTable[3] or 1
	self.speedIndex = indexTable[4] or 1
	self.objectIndex = indexTable[5] or 1
	self.item_2_Index = indexTable[6] or 1 -- magic --
	self.displayed = displayed
	self.working = deepcopy(self.options)

	self:DoInit()
	self:InitializeSpinners()
end)

function string.starts(String,Start)
	Start = string.upper(Start)
	return string.sub(String,1,string.len(Start)) == Start
end

function TestScreen:OnTextInput(text)
	local spinner = TheFrontEnd:GetFocusWidget()
	
	local index = 1

	if spinner["options"] ~= nil then 
		for k,v in pairs(spinner.options) do
			if string.starts(v.text, text) then
				spinner:SetSelectedIndex(index)
				break
			end	
			
			index = index + 1
		end
	end
end

function TestScreen:OnKeyUp(key)
	if key == KEY_ESCAPE then
		self:Close()
	end
end

function TestScreen:OnKeyDown(key)
	if (key == KEY_TAB) and not TheInput:IsKeyDown(KEY_ALT) then
		self:AdvanceFocus( not TheInput:IsKeyDown(KEY_SHIFT) )
	end
end

function TestScreen:Accept()
	self:Save(function()
	self:Close()
	end)
end

function TestScreen:Save(cb)
	self.options = deepcopy(self.working)
	Profile:Save(function()
	if cb then
	  cb()
	end
	end)
end

function TestScreen:Close()
	TheSim:SetSetting("TEST_TOOLS", "entityIndex", self.entitySpinner:GetSelectedIndex())
	TheSim:SetSetting("TEST_TOOLS", "itemIndex", self.itemSpinner:GetSelectedIndex())
	TheSim:SetSetting("TEST_TOOLS", "foodIndex", self.foodSpinner:GetSelectedIndex())
	TheSim:SetSetting("TEST_TOOLS", "speedIndex", self.speedSpinner:GetSelectedIndex())
	TheSim:SetSetting("TEST_TOOLS", "objectIndex", self.objectSpinner:GetSelectedIndex())
	TheSim:SetSetting("TEST_TOOLS", "item_2_Index", self.item_2_Spinner:GetSelectedIndex()) -- magic --

	TheFrontEnd:PopScreen(self)
	self.displayed = false
	SetHUDPause(false)
end

function TestScreen:RetrieveIndices()
	local values = {}

	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "entityIndex") or 1)
	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "itemIndex") or 1)
	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "foodIndex") or 1)
	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "speedIndex") or 1)
	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "objectIndex") or 1)
	table.insert(values, TheSim:GetSetting("TEST_TOOLS", "item_2_Index") or 1) -- magic --

	return values
end

local MakeMenu = function(offset, menuitems)
	local menu = Widget("OptionsMenu")
	local pos = Vector3(0, 0, 0)
	
	for k, v in ipairs(menuitems) do
		local button = menu:AddChild(AnimButton("button"))
		button:SetPosition(pos)
		button:SetText(v.text)
		button.text:SetColour(0, 0, 0, 1)
		button:SetOnClick(v.cb)
		button:SetFont(BUTTONFONT)
		button:SetTextSize(40)
		pos = pos + offset
	end
	
	return menu
end

function TestScreen:AddSpinners(data, user_offset, bg_size)
	local master_group = self:AddChild(Widget("SpinnerGroup"))
	master_group:SetVAnchor(ANCHOR_TOP)
	master_group:SetHAnchor(ANCHOR_MIDDLE)
	
	local offset = {0, 0, 0}
	if user_offset then
		offset[1] = offset[1] + user_offset[1]
		offset[2] = offset[2] + user_offset[2]
		offset[3] = offset[3] + user_offset[3]
	end
	local centerV = -RESOLUTION_Y/4
	master_group:SetPosition(offset[1], offset[2] + centerV, offset[2]) --first offset = horizontal.  second offset is vertical
	
	local label_width = 200
	
	for idx, entry in ipairs(data) do
		local text = entry[1]
		local spinner = entry[2]
		local group = master_group:AddChild(Widget("SpinnerGroup"))
		group:SetPosition(0, (idx - 1) * -75 + 25, 0)
		local label = group:AddChild(Text(DEFAULTFONT, 30, text))
		label:SetPosition(0.5 * label_width, 0, 0)
		label:SetRegionSize(label_width, 50)
		label:SetHAlign(ANCHOR_RIGHT)
		group:AddChild(spinner)
		spinner:SetPosition(label_width + 32, 0, 0)
		spinner:SetWrapEnabled(true)
		spinner:SetOnClick(function() self:SetFocus(spinner) end)
	end
	
	return master_group
end

function TestScreen:DoInit()
	--below uses Klei's gray background with tint:
    self.bg = self:AddChild(Image("images/ui.xml", "bg_plain.tex"))
	self.bg:SetTint(BGCOLOURS.RED[1],BGCOLOURS.RED[2],BGCOLOURS.RED[3], 1)
    self.bg:SetVRegPoint(ANCHOR_MIDDLE)
    self.bg:SetHRegPoint(ANCHOR_MIDDLE)
    self.bg:SetVAnchor(ANCHOR_MIDDLE)
    self.bg:SetHAnchor(ANCHOR_MIDDLE)
    self.bg:SetScaleMode(SCALEMODE_FILLSCREEN)
    
	self.root = self:AddChild(Widget("ROOT"))
    self.root:SetVAnchor(ANCHOR_MIDDLE)
    self.root:SetHAnchor(ANCHOR_MIDDLE)
    self.root:SetPosition(0,0,0)
    self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)

-- ########################### Menu buttons ########################### --	
	local menu_items = {
		{ text = "Keys", cb = function() TheFrontEnd:PushScreen(KeyScreen({ {text="Back", cb = function() end}})) end },	
		{ text = "Close", cb = function() self:Accept() end }
	}

	if self.menu then
		self.menu:Kill()
	end
	
	local menu_spacing = 60
	local bottom_offset = 70
	local this = self
-- ########################### UnCraftables ########################### --
	self.itemSpinner = Spinner(uncraftableItemOptions, 180, spinnerHeight, spinnerFont )
	function self.itemSpinner:OnChanged(data)
			this.working.itemPrefab = data
			this:UpdateSelectedItem()
			self.image = self:AddChild(Image("images/ui.xml", "portrait_bg.tex"))
			self.image:SetScale(0.8,0.8,0.8)
			self.image:SetPosition(115,-75,0)
			self.image = self:AddChild(Image("images/inventoryimages.xml", data.. ".tex"))
			
			self.image:SetPosition(115,-75,0)
	  end
-- ########################### Food Items ########################### --
	self.foodSpinner = Spinner(foodItemOptions, 180, spinnerHeight, spinnerFont )
		function self.foodSpinner:OnChanged(data)
			this.working.foodPrefab = data
			this:UpdateSelectedFood()
			self.image = self:AddChild(Image("images/ui.xml", "portrait_bg.tex"))
			self.image:SetScale(0.8,0.8,0.8)
			self.image:SetPosition(115,-75,0)
			self.image = self:AddChild(Image("images/inventoryimages.xml", data.. ".tex"))
			self.image:SetPosition(115,-75,0)
		end
-- ########################### ENTITYS ########################### --
	self.entitySpinner = Spinner(entityOptions, 180, spinnerHeight, spinnerFont )
	self.objectSpinner = Spinner(objectOptions, 180, spinnerHeight, spinnerFont )
local entitySpinner = self.entitySpinner
local objectSpinner = self.objectSpinner


	function self.entitySpinner:OnChanged(data)
		this.working.entityPrefab = data
		this:UpdateSelectedEntity()


		------- clean up preview frames
		if self.bg then
			self.bg:Kill()
			self.bg = nil
		end
		if objectSpinner.bg_2 then
			objectSpinner.bg_2:Kill()
			objectSpinner.bg_2 = nil
		end
		if objectSpinner.entity_preview then
			objectSpinner.entity_preview:Kill()
			objectSpinner.entity_preview = nil
		end
		-- then load picture frame
		self.bg = self:AddChild(Image("scripts/images/panel.xml", "panel.tex")) -- new preview frame
		self.bg:SetScale(0.75,1,1)
		self.bg:SetPosition(450,0,0)
		------- clean up preview frame


		local info = build_info[data]
		if info then
			if self.entity_preview then
				self:RemoveChild(self.entity_preview)
				self.entity_preview:Kill()
			end


--$$$$$$$$$$$$$$$$$$$$$$$$$  pulls from builds.lua $$$$$$$$$$$$$$$$$$$$$$$$$--
			build_info.penguin.baseanim = "idle_loop"
			build_info.bat.baseanim = "fly_loop"
			build_info.bishop.baseanim = "idle_loop"
			build_info.knight.baseanim = "idle_loop"
			build_info.chester.baseanim = "idle_loop"
			build_info.pigman.baseanim = "idle_happy"
			build_info.merm.baseanim = "idle_happy"
			build_info.perd.baseanim = "idle_loop"
			build_info.walrus.baseanim = "idle_angry"
			build_info.tentacle.baseanim = "atk_loop"
			build_info.tentacle_pillar_arm.baseanim = "atk_loop"
			build_info.pigguard.baseanim = "idle_happy"
			build_info.lureplant.baseanim = "idle_out"
			build_info.eyeplant.baseanim = "atk"
			build_info.slurper.baseanim = "idle", true -- everything in SGslurper.lua tried - NOTHING works
			self.entity_preview = self:AddChild(UIAnim(data))
			self.entity_preview:GetAnimState():SetBank( info.bank )
			self.entity_preview:GetAnimState():SetBuild( info.build )
			self.entity_preview:GetAnimState():PlayAnimation( info.baseanim )
		else
			self.entity_preview:GetAnimState():SetBank(data)
			self.entity_preview:GetAnimState():SetBuild(data)
			self.entity_preview:GetAnimState():PlayAnimation("idle")
		end
		self.entity_preview:SetScale(0.25,0.25,0.25)
		self.entity_preview:SetPosition(450,-100,0)


	end


-- end ENTITY
-- ########################### OBJECTS ########################### --
	function self.objectSpinner:OnChanged(data)
		this.working.objectPrefab = data
		this:UpdateSelectedObject()
------- clean up preview frame
		if entitySpinner.entity_preview then
			entitySpinner.entity_preview:Kill()
			entitySpinner.entity_preview = nil
		end
		if entitySpinner.bg then
			entitySpinner.bg:Kill()
			entitySpinner.bg = nil
		end
		if self.bg_2 then
			self.bg_2:Kill()
			self.bg_2 = nil
		end
-- then load picture frame
		self.bg_2 = self:AddChild(Image("scripts/images/panel.xml", "panel.tex")) -- new preview frame
		self.bg_2:SetScale(0.75,1,1)
		self.bg_2:SetPosition(450,75,0)
------- clean up preview frame
			
		local info = build_info[data]


		if info then
			if self.entity_preview then
				self:RemoveChild(self.entity_preview)
				self.entity_preview:Kill()
			end
			self.entity_preview = self:AddChild(UIAnim(data))
			self.entity_preview:GetAnimState():SetBank( info.bank )
			self.entity_preview:GetAnimState():SetBuild( info.build )
			self.entity_preview:GetAnimState():PlayAnimation( info.baseanim )
		else
			self.entity_preview = self:AddChild(UIAnim(data))
			self.entity_preview:GetAnimState():SetBank(data)
			self.entity_preview:GetAnimState():SetBuild(data)
			self.entity_preview:GetAnimState():PlayAnimation("idle")
		end
		self.entity_preview:SetScale(0.25,0.25,0.25)
		self.entity_preview:SetPosition(450,-50,0)


	end

-- ########################### Magic items ########################### --
-- magic --
		self.item_2_Spinner = Spinner(index_2_Options, 180, spinnerHeight, spinnerFont )
		function self.item_2_Spinner:OnChanged(data)
			this.working.item_2_Prefab = data
			this:UpdateSelected_2_Index()
			self.image = self:AddChild(Image("images/ui.xml", "portrait_bg.tex"))
			self.image:SetScale(0.8,0.8,0.8)
			self.image:SetPosition(115,-75,0)
			self.image = self:AddChild(Image("images/inventoryimages.xml", data.. ".tex"))
			self.image:SetPosition(115,-75,0)
		end
-- magic --
	self.speedSpinner = NumericSpinner( 2, 10, 50, spinnerHeight, spinnerFont )
	self.speedSpinner.OnChanged =
		function( self, data )
			this:UpdateSpeedMultiplier()
		end 
		
	self.godmodeSpinner = Spinner(enableDisableOptions, 50, spinnerHeight, spinnerFont )
		function self.godmodeSpinner:OnChanged(data)
			this:UpdateGodMode()
		end

	local spawning_spinners = {}
	local option_spinners = {}
	local toggle_spinners = {}

	local spawn_pos, option_pos, toggle_pos, bg_pos, bg_size

        table.insert(spawning_spinners,{"(Ctrl-X)                                          ", self.itemSpinner })
        table.insert(spawning_spinners,{"", self.godmodeSpinner }) --makes a blank line
        table.insert(spawning_spinners,{"ʳ(Ctrl-T)                                          ", self.foodSpinner })
        table.insert(spawning_spinners,{"", self.godmodeSpinner }) --makes a blank line
        table.insert(spawning_spinners,{"(Shift-Z)                                         ", self.entitySpinner })
        table.insert(spawning_spinners,{"λ(Shift-O)                                         ", self.objectSpinner })
		
        table.insert(spawning_spinners, {"ϵģʽ                                             :", self.godmodeSpinner })
        table.insert(spawning_spinners, {"ٶ                                                 :", self.speedSpinner })
        table.insert(toggle_spinners, {"ħ(Alt-L)                                            ", self.item_2_Spinner }) -- magic --
	
	local centerH = -RESOLUTION_X/2.5 -- Horizontal position of 'prefab' column
	local centerO = RESOLUTION_X/15 -- Horizontal position of 'toggle' column

	spawn_pos = {centerH, 75, 0} --Vertical position of all prefab items table
	toggle_pos = {centerO,75,0} --Vertical postion of all 'toggle' items (right side)
	bg_pos = {640, 360,0}
	bg_size = {1000, 700}


	local spawn_group = self:AddSpinners(spawning_spinners, spawn_pos)
	local option_group = self:AddSpinners(option_spinners, option_pos)
	local toggle_group = self:AddSpinners(toggle_spinners, toggle_pos)
	
	--self:PushFocusWidget(self.entitySpinner)
	--self:PushFocusWidget(self.itemSpinner)
	--self:PushFocusWidget(self.foodSpinner)
	--self:PushFocusWidget(self.objectSpinner)
	--self:PushFocusWidget(self.item_2_Spinner)-- magic --

	self.soundmenu = self:AddChild(MakeMenu(Vector3(0, -menu_spacing, 0), menu_items))
--Keys and Close button placement:
	self.soundmenu:SetHAnchor(ANCHOR_RIGHT)
	self.soundmenu:SetPosition(-120, bottom_offset + menu_spacing * (#menu_items - 1), 0)
end

local EnabledOptionsIndex = function(enabled)
	if enabled then
		return 2
	else
		return 1
	end
end

local function GodModeIndex()
	if GetPlayer().components.health:IsInvincible() then
		return 2
	else
		return 1
	end
end

function TestScreen:UpdateSelectedEntity()
	if self.entitySpinner:GetSelected().data then
		GetPlayer().components.testtoolcontroller.entityPrefab = self.entitySpinner:GetSelectedData()
	end
end

function TestScreen:UpdateSelectedItem()
	if self.itemSpinner:GetSelected().data then
		GetPlayer().components.testtoolcontroller.itemPrefab = self.itemSpinner:GetSelectedData()
	end
end

function TestScreen:UpdateSelectedFood()
	if self.foodSpinner:GetSelected().data then
		GetPlayer().components.testtoolcontroller.foodPrefab = self.foodSpinner:GetSelectedData()
	end
end

function TestScreen:UpdateSelectedObject()
	if self.objectSpinner:GetSelected().data then
		GetPlayer().components.testtoolcontroller.objectPrefab = self.objectSpinner:GetSelectedData()
	end
end
-- magic --
function TestScreen:UpdateSelected_2_Index()
	if self.item_2_Spinner:GetSelected().data then
		GetPlayer().components.testtoolcontroller.item_2_Prefab = self.item_2_Spinner:GetSelectedData()
		end
end
-- magic --
function TestScreen:UpdateSpeedMultiplier()
	if self.speedSpinner:GetSelected() then
		GetPlayer().components.testtoolcontroller.speed_multiplier = self.speedSpinner:GetSelectedData()
	end
end

function TestScreen:UpdateGodMode()
	if self.godmodeSpinner:GetSelected() then
		local value = self.godmodeSpinner:GetSelectedData()
		GetPlayer().components.health:SetInvincible(value)
	end
end

----------------------------------------------------------------------
function TestScreen:InitializeSpinners()
	self.entitySpinner:SetSelectedIndex(self.entityIndex)
	self:UpdateSelectedEntity()

	self.itemSpinner:SetSelectedIndex(self.itemIndex)
	self:UpdateSelectedItem()

	self.foodSpinner:SetSelectedIndex(self.foodIndex)
	self:UpdateSelectedFood()

	self.objectSpinner:SetSelectedIndex(self.objectIndex)
	self:UpdateSelectedObject()
-- magic --
	self.item_2_Spinner:SetSelectedIndex(self.item_2_Index)
	self:UpdateSelected_2_Index()
-- magic --	
	self.speedSpinner:SetSelectedIndex(self.speedIndex)
	self:UpdateSpeedMultiplier()

	self.godmodeSpinner:SetSelectedIndex(GodModeIndex())
	self:UpdateGodMode()
end
