-- InfiniteTools
-- by tehMugwump
-- Upgraded by WrathOf to new mod system
-- v3.1 (bug fix for tent by WrathOf) and some new tools
-------------------------------------------------------------------------------
-- Support thread here: 
-- http://forums.kleientertainment.com/showthread.php?11400
--
-------------------------------------------------------------------------------
-- Description:
--
-- This mod makes your common tools last forever. 
--
-- Nothing is more aggravating than trying to collect resources and having your
-- tools break on you every 60 seconds. They're easy to remake, but it seems a 
-- bit pointless and just wastes your time, so this mod takes care of that.
--
-------------------------------------------------------------------------------
--
-- To install this mod, put this file in a new folder under
-- "...\Steam\steamapps\common\dont_starve\mods" called "InfiniteTools",
-- then open the "modsettings.lua" file in the mods folder and add the
-- following but without the beginning "--":
--
--ModManager:AddMod("InfiniteTools")
--
-- When you run the game you should see a screen pop up that lists this mod as
-- being loaded.
--
-------------------------------------------------------------------------------
--Callback function to remove the finite use component from a prefab
--inst:AddComponent("finiteuses")
function InfiniteTools_RemoveFiniteUses(inst)
	if inst.components.finiteuses then
		inst:RemoveComponent("finiteuses")
	end
end
--Callback function to remove fueled reference from a prefab
--inst:AddComponent("fueled")
function InfiniteTools_Removefueled(inst)
	if inst.components.fueled then
		inst:RemoveComponent("fueled")
	end
end

--WrathOf: Added workaround to address reference to finiteuses in
--OnSleep event of tent which caused game to crash.
function InfiniteTools_DisableUses(inst)

	local function EatUse(self, num)
    	--Do nothing
	end

	if inst.components.finiteuses then
		inst.components.finiteuses.Use = EatUse
	end

end

--Add a post init callback to the tool prefabs (and tent, torch)
--This will tell the game to run the function above after creating the prefab
--Comment out any of the lines below to disable this change if desired
AddPrefabPostInit("axe", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("hammer", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("nightsword", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("pickaxe", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("pitchfork", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("shovel", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("spear", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("tentaclespike", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("fishingrod", InfiniteTools_RemoveFiniteUses)

AddPrefabPostInit("goldenaxe", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("goldenpickaxe", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("goldenshovel", InfiniteTools_RemoveFiniteUses)

AddPrefabPostInit("tent", InfiniteTools_DisableUses)
AddPrefabPostInit("torch", InfiniteTools_Removefueled)

AddPrefabPostInit("boomerang", InfiniteTools_RemoveFiniteUses)
AddPrefabPostInit("icestaff", InfiniteTools_RemoveFiniteUses)


