/**
 * Copyright (c) 2016-present, DesDev, Inc.
 * All rights reserved.
 *
 * Official:http://dedeampz.dedecms.com
 *
 * Company:http://www.desdev.cn
 */

const electron = require('electron');
const app = electron.app;
const BrowserWindow = electron.BrowserWindow;
const dialog = electron.dialog;
const ipcMain = require('electron').ipcMain;

var mainWindow = null;

app.on('window-all-closed', function() {
	if (process.platform != 'darwin') {
		app.quit();
	}
});

app.on('ready', function() {
	mainWindow = new BrowserWindow({
		width: 650,
		height: 650,
		maximizable: false,
		resizable: false,
		'min-width': 500,
		'min-height': 400,
		'accept-first-mouse': true,
		'title-bar-style': 'hidden'
	});

	mainWindow.loadURL('file://' + __dirname + '/index.html');

	//mainWindow.openDevTools();

	mainWindow.on('closed', function() {
		mainWindow = null;
	});

	mainWindow.on('minimize', function() {
		mainWindow.hide();
	});

	ipcMain.on('closeWindow', function() { // closeWindow  可自己随意定义
		app.quit();
	});

	ipcMain.on('minimize', function() { //minimize 可自己随意定义
		mainWindow.hide();
	});

	ipcMain.on('show', function() { //minimize 可自己随意定义
		mainWindow.show();
	});

});