/**
 * Copyright (c) 2016-present, DesDev, Inc.
 * All rights reserved.
 *
 * Official:http://dedeampz.dedecms.com
 *
 * Company:http://www.desdev.cn
 */

var apacheconf = require('apacheconf')

var Websites = {

	__parseComment: function(comment) {
		var info = comment.split(":");
		if (!info[0] || !info[1]) return false;
		var key = info[0].replace(/^#/, "");
		var rs = {};
		rs[key] = info[1];
		return rs;
	},
	__getSiteinfoFromConf: function(ConfigFile, callback) {
		var SiteInfo = {};
		var SiteName = "";
		apacheconf(ConfigFile, (err, config, parser) => {
			if (err) throw err

			config.VirtualHost.forEach((vh) => {
				if (vh.ServerName) vh.ServerName.forEach((d) => {
					SiteInfo.ServerName = d;
				})
				if (vh.DocumentRoot) vh.DocumentRoot.forEach((d) => {
					SiteInfo.DocumentRoot = d.replace(/\"/g,"");
				})
			})
			if (config.VirtualHost.comments) config.VirtualHost.comments.forEach((cm) => {
				if (cm) cm.forEach((i) => {
					var BaseInfo = this.__parseComment(i);
					if (typeof BaseInfo.SiteName != 'undefined')
						SiteInfo.SiteName = BaseInfo.SiteName;
				})
			})
			if (typeof SiteInfo.SiteName == 'undefined') SiteInfo.SiteName = '未命名站点';
			SiteInfo.ConfigStr = fs.readFileSync(parser.file).toString();
			
			callback(SiteInfo);
		});
	},

	getWebsiteConfigString:function(WebsiteID,SiteName,ServerName,DocumentRoot){
		if (!fs.existsSync(ApacheVhostsINITemplate)) return false;
		var ApacheVhostsINITPLStr = fs.readFileSync(ApacheVhostsINITemplate).toString();
		var AddOpt = [{
			'~WebsiteID~': WebsiteID
		}, {
			'~SiteName~': SiteName
		}, 
		{
			'~ServerName~': ServerName
		}, 
		{
			'~DocumentRoot~': DocumentRoot
		}, 
		];
		return Util.parseConfig(ApacheVhostsINITPLStr, AddOpt);
	},

	createOne: function(WebsiteID, SiteName, ServerName,DocumentRoot, InitByDedeCMS) {
		var ApacheVhostsINIStr = this.getWebsiteConfigString(WebsiteID, SiteName, ServerName,DocumentRoot);
		var WebsiteINI = path.join(ConfigDir, 'vhosts', WebsiteID + '.conf');
		var WebsitePath = path.join(WebsitesDir, WebsiteID);

		if(InitByDedeCMS==true){
			
		}

		//console.log(ApacheVhostsINIStr);
		return fs.writeFileSync(WebsiteINI, ApacheVhostsINIStr);
	},

	updateOne:function(WebsiteID,SiteName,ServerName,DocumentRoot){
		var ApacheVhostsINIStr = this.getWebsiteConfigString(WebsiteID, SiteName, ServerName,DocumentRoot);
	},

	deleteOne: function(WebsiteID) {
		var WebsiteINI = path.join(ConfigDir, 'vhosts', WebsiteID + '.conf');
		fs.unlinkSync(WebsiteINI);
		loadWebsites();
		$("#addWebsite").click();
	},

	getSiteInfoFromConfigString:function(ConfigFile, callback){
		this.__getSiteinfoFromConf(ConfigFile, callback);
	},

	getOne: function(siteid, callback) {
		log.debug('call Websites.getOne');
		var dirList = fs.readdirSync(ConfigDir_vhosts);
		var SiteConfig = siteid + '.conf';
		var SiteInfo = null;
		dirList.forEach((item) => {
			log.debug('call Websites.getOne item:',item);
			if (fs.statSync(path.join(ConfigDir_vhosts, item)).isFile() && SiteConfig == item) {
				this.__getSiteinfoFromConf(path.join(ConfigDir_vhosts, item), function(SiteInfo) {
					SiteID = item.replace('.conf', '');
					SiteInfo.SiteID = SiteID;
					callback(SiteInfo);
				});
			}
		});
	},
	getAll: function(callback) {
		log.debug('call Websites.getAll');
		var dirList = fs.readdirSync(ConfigDir_vhosts);
		var Websites = [];
		dirList.forEach((item) => {
			log.debug('call Websites.getAll item:',item);
			if (fs.statSync(path.join(ConfigDir_vhosts, item)).isFile()) {
				this.__getSiteinfoFromConf(path.join(ConfigDir_vhosts, item), function(SiteInfo) {
					SiteID = item.replace('.conf', '');
					SiteInfo.SiteID = SiteID;
					callback(SiteInfo);
				});
				//Websites.push(SiteInfo);
			}
		});
		//return Websites;
	}
}