/**
 * Copyright (c) 2016-present, DesDev, Inc.
 * All rights reserved.
 *
 * Official:http://dedeampz.dedecms.com
 *
 * Company:http://www.desdev.cn
 */
var PackageJson = require('./package.json');

const path = require('path');
const os = require('os');
const fs = require('fs');
const net = require('net');
const Log = require('log');

const DedeAMPZ_Name = PackageJson.name;
const DedeAMPZ_Version = PackageJson.version;
const DedeAMPZ_Description = PackageJson.description;

var BaseDir = __dirname;
var BinDir = path.join(BaseDir, 'bin');
var ConfigDir = path.join(BaseDir, 'config');
var ConfigDir_vhosts = path.join(ConfigDir, 'vhosts');
var TempDir = path.join(BaseDir, 'temp');
var TempDir_uploads = path.join(TempDir, 'uploads');
var TempDir_sessions = path.join(TempDir, 'sessions');
var SrcDir = path.join(BaseDir, 'src');
var WebsitesDir = path.join(BaseDir, 'websites');

var log = new Log('debug', fs.createWriteStream(path.join(BaseDir, 'DedeAMPZ.log')));

var PHPDir = path.join(BinDir, 'PHP');
var ApacheDir = path.join(BinDir, 'Apache');
var MariadbDir = path.join(BinDir, 'Mariadb');

var DedeAMPZCli = path.join(PHPDir, 'DedeAMPZ.exe');
var PHPCli = path.join(PHPDir, 'php.exe');
var ApacheCli = path.join(ApacheDir, 'bin', 'httpd.exe');
var MariadbCli = path.join(MariadbDir, 'bin', 'mysqld.exe');

var SetEnvCmd = path.join(BaseDir, 'setenv.Cmd');

var UserInfo = {
	arch:os.arch(),
	cpus:os.cpus(),
	hostname:os.hostname(),
	freemem:os.freemem(),
	totalmem:os.totalmem(),
	platform:os.platform(),
	release:os.release(),
	type:os.type(),
	hostname:os.hostname(),
	networkInterfaces:os.networkInterfaces(),
	userInfo:os.userInfo(),
};

var Util = {
	slash:function (str) {
		var isExtendedLengthPath = /^\\\\\?\\/.test(str);
		var hasNonAscii = /[^\x00-\x80]+/.test(str);

		if (isExtendedLengthPath || hasNonAscii) {
			return str;
		}

		return str.replace(/\\/g, '/');
	},
	parseConfig : function(str,AddOption){
		str = str.replace(/~BaseDir~/g,this.slash(BaseDir));
		str = str.replace(/~BinDir~/g,this.slash(BinDir));
		str = str.replace(/~ConfigDir~/g,this.slash(ConfigDir));
		str = str.replace(/~TempDir~/g,this.slash(TempDir));
		str = str.replace(/~SrcDir~/g,this.slash(SrcDir));
		str = str.replace(/~PHPDir~/g,this.slash(PHPDir));
		str = str.replace(/~ApacheDir~/g,this.slash(ApacheDir));
		str = str.replace(/~MariadbDir~/g,this.slash(MariadbDir));
		str = str.replace(/~WebsitesDir~/g,this.slash(WebsitesDir));
		if(typeof AddOption == 'object')
		{
			AddOption.forEach((item)=>{
				var k = Object.keys(item)[0];
				var v = item[k];
				if(k == '~DocumentRoot~') v = this.slash(v);
				var re = new RegExp(k, "mg");
				str = str.replace(re,v);
			})
		}
		return str;
	},
	checkPort: function(Port,callback){
		var client;
	    function cleanUp() {
	        if (client) {
	            client.removeAllListeners('connect');
	            client.removeAllListeners('error');
	            client.end();
	            client.destroy();
	            client.unref();
	        }
	        //debug('listeners removed from client socket');
	    }
	    function onConnectCb() {
	        //debug('check - promise resolved - in use');
	        callback(true);
	        cleanUp();
	    }

	    function onErrorCb(err) {
	        if (err.code !== 'ECONNREFUSED') {
	            //debug('check - promise rejected, error: '+err.message);
	            deferred.reject(err);
	        } else {
	            callback(false);
	        }
	        cleanUp();
	    }
	    client = new net.Socket();
	    client.once('connect', onConnectCb);
	    client.once('error', onErrorCb);
	    client.connect({port: Port, host: '127.0.0.1'});
		
	    
	}
}