/**
 * Copyright (c) 2016-present, DesDev, Inc.
 * All rights reserved.
 *
 * Official:http://dedeampz.dedecms.com
 *
 * Company:http://www.desdev.cn
 */

global.$ = $;

const {
	Tray, BrowserWindow,app
} = require('electron').remote
const exec = require('child_process').exec;
const ipcRenderer = global.require('electron').ipcRenderer;

var ExePath = app.getPath("exe");
var DesktopPath = app.getPath("desktop");

//console.log(UserInfo);
var tray = null;
var win = BrowserWindow.getFocusedWindow();

var ApacheVersion = DedeAMPZ.getApacheVersion();
var MariadbVersion = DedeAMPZ.getMariadbVersion();
var PHPVersion = DedeAMPZ.getPHPVersion();

var loadWebsites;

$(document).ready(function() {
	//log.debug('create shortcuts');
	//if(!fs.existsSync(path.join(DesktopPath,"DedeAMPZ.lnk"))){
	//	var ws = require('windows-shortcuts');
	//	ws.create(path.join(DesktopPath,"DedeAMPZ.lnk"),ExePath);
	//}
	
	log.debug('make dirs');
	if (!fs.existsSync(BinDir)) fs.mkdirSync(BinDir);
	if (!fs.existsSync(ConfigDir)) fs.mkdirSync(ConfigDir);
	if (!fs.existsSync(ConfigDir_vhosts)) fs.mkdirSync(ConfigDir_vhosts);
	if (!fs.existsSync(TempDir)) fs.mkdirSync(TempDir);
	if (!fs.existsSync(TempDir_uploads)) fs.mkdirSync(TempDir_uploads);
	if (!fs.existsSync(TempDir_sessions)) fs.mkdirSync(TempDir_sessions);
	
	initAMP.initConfig(function(rs) {
		if (rs) {
			var CheckPHPInstall = initAMP.checkPHPInstall();
			var CheckApacheInstall = initAMP.checkApacheInstall();
			var CheckMariadbInstall = initAMP.checkMariadbInstall();
			if (!CheckPHPInstall || !CheckApacheInstall || !CheckMariadbInstall) {
				if (!CheckPHPInstall) {
					$("#ControlPHP").hide();
					$("#InstallPHPProcess").show();
				} else {
					$("#ControlPHP").show();
					$("#InstallPHPProcess").hide();
				}
				if (!CheckApacheInstall) {
					$("#ControlApache").hide();
					$("#InstallApacheProcess").show();
				} else {
					$("#ControlApache").show();
					$("#InstallApacheProcess").hide();
				}
				if (!CheckMariadbInstall) {
					$("#ControlMariadb").hide();
					$("#InstallMariadbProcess").show();
				} else {
					$("#ControlMariadb").show();
					$("#InstallMariadbProcess").hide();
				}

				var options = {
					title: 'DedeAMPZ',
					type: 'info',
					buttons: ['Ok'],
					message: 'DedeAMPZ',
					detail: '检查到DedeAMPZ有未安装的组件，需要在线获取并安装扩展'
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {
						$('#indexDedeAMPZ').click();
						if (!CheckPHPInstall) {
							log.debug('install PHP');
							initAMP.installPHP();
						}
						if (!CheckApacheInstall) {
							log.debug('install Apache');
							initAMP.installApache(function(rs) {
								if (rs) {
									loadWebsites();
								}
							});
						}
						if (!CheckMariadbInstall) {
							log.debug('install Mariadb');
							initAMP.installMariadb();
						}

					}
				});

			} else {
				if (CheckPHPInstall) {
					$("#ControlPHP").show();
					$("#InstallPHPProcess").hide();
				}
				if (CheckApacheInstall) {
					$("#ControlApache").show();
					$("#InstallApacheProcess").hide();
				}
				if (CheckMariadbInstall) {
					$("#ControlMariadb").show();
					$("#InstallMariadbProcess").hide();
				}
			}
		}

	});

	//console.log(Util.slash(BinDir));
	$('#showDedeAMPZ').val(DedeAMPZ.getControlLog()).scrollBottom();;

	var CurrentEditWebSite = '';

	loadWebsites = () => {
		log.debug('get websites');
		$("#_siteLists").html("");
		try {
			Websites.getAll((Site) => {
				var SiteNav = "";
				SiteNav = "<span class=\"sitenav nav-group-item\" id=\"Site_" + Site.SiteID + "\" onclick=\"editWebsite('" + Site.SiteID + "')\"><span class=\"icon icon-globe\"></span>" + Site.SiteName + "</span>";
				$("#_siteLists").append(SiteNav);
			});
			//var DefaultWebSites = Websites.getOne('default');
			editWebsite = (SiteID) => {
				Websites.getOne(SiteID, (SiteInfo) => {
					if (WebsiteConfigChanged) {
						var options = {
							title: 'DedeAMPZ',
							type: 'info',
							buttons: ['Yes', 'No'],
							message: 'DedeAMPZ',
							detail: '网站配置已经被更改，是否保存然后继续操作？'
						};
						dialog.showMessageBox(win, options, (response) => {
							if (response == 0) {
								console.log('response:', response);
								var ConfigStr = $("#ConfigStr").val();
								var WebsiteINI = path.join(ConfigDir, 'vhosts', CurrentEditWebSite + '.conf');
								fs.writeFileSync(WebsiteINI, ConfigStr);
								var options = {
									title: 'DedeAMPZ',
									type: 'info',
									buttons: ['Ok'],
									message: 'DedeAMPZ',
									detail: '成功保存站点配置，您需要重启Apache服务器才能生效'
								};
								dialog.showMessageBox(win, options, function(response) {
									if (response == 0) {
										$("#Site_" + CurrentEditWebSite).html($("#Site_" + CurrentEditWebSite).html().replace(/\*$/, ""));
										$("#SiteID").attr("disabled", "disabled");
										$("#SiteID").val(SiteInfo.SiteID);
										$("#SiteName").val(SiteInfo.SiteName);
										$("#ServerName").val(SiteInfo.ServerName);
										$("#DocumentRoot").val(SiteInfo.DocumentRoot);
										$("#ConfigStr").val(SiteInfo.ConfigStr);

										CurrentEditWebSite = SiteInfo.SiteID;

										$(".nav-group-item").removeClass("active");
										$("#Site_" + SiteID).addClass("active");
										$('#moduleSetting').hide();
										$('#websiteSetting').show();
										$('#indexSetting').hide();
										$('#IsInitByDedeCMS').hide();

										WebsiteConfigChanged = false;
										ChangeTime = 0;
									}
								});



							} else {
								$("#Site_" + CurrentEditWebSite).html(OldWebsiteTitle);

								$("#SiteID").attr("disabled", "disabled");
								$("#SiteID").val(SiteInfo.SiteID);
								$("#SiteName").val(SiteInfo.SiteName);
								$("#ServerName").val(SiteInfo.ServerName);
								$("#DocumentRoot").val(SiteInfo.DocumentRoot);
								$("#ConfigStr").val(SiteInfo.ConfigStr);

								CurrentEditWebSite = SiteInfo.SiteID;

								$(".nav-group-item").removeClass("active");
								$("#Site_" + SiteID).addClass("active");
								$('#moduleSetting').hide();
								$('#websiteSetting').show();
								$('#indexSetting').hide();
								$('#IsInitByDedeCMS').hide();

								WebsiteConfigChanged = false;
								ChangeTime = 0;
							}
						});
						return;
					}
					//console.log(SiteInfo);
					$("#SiteID").attr("disabled", "disabled");
					$("#SiteID").val(SiteInfo.SiteID);
					$("#SiteName").val(SiteInfo.SiteName);
					$("#ServerName").val(SiteInfo.ServerName);
					$("#DocumentRoot").val(SiteInfo.DocumentRoot);
					$("#ConfigStr").val(SiteInfo.ConfigStr);

					fs.writeFileSync(path.join(TempDir, 'httpd-vhosts.conf'), SiteInfo.ConfigStr);

					CurrentEditWebSite = SiteInfo.SiteID;

					$(".nav-group-item").removeClass("active");
					$("#Site_" + SiteID).addClass("active");
					$('#moduleSetting').hide();
					$('#websiteSetting').show();
					$('#indexSetting').hide();
					$('#IsInitByDedeCMS').hide();

					return true;
				});
			};
		} catch (e) {
			log.error(e);
		}
	}
	loadWebsites();

	var WebsiteConfigChanged = false;
	var OldWebsiteTitle = '';
	var ChangeTime = 0;

	var getSiteConfig = function() {
		return {
			WebsiteID: $("#SiteID").val(),
			SiteName: $("#SiteName").val(),
			ServerName: $("#ServerName").val(),
			DocumentRoot: $("#DocumentRoot").val(),
		};
	};

	var changeConfigString = function(IsConfigStr) {
		var SiteConfig = getSiteConfig();
		if (IsConfigStr) {
			fs.writeFileSync(path.join(TempDir, 'httpd-vhosts.conf'), $("#ConfigStr").val());
			Websites.getSiteInfoFromConfigString(path.join(TempDir, 'httpd-vhosts.conf'), (SiteInfo) => {
				//console.log(SiteInfo);
				$("#SiteName").val(SiteInfo.SiteName);
				$("#ServerName").val(SiteInfo.ServerName);
				$("#DocumentRoot").val(SiteInfo.DocumentRoot);
				SiteConfig.WebsiteID = CurrentEditWebSite;
				SiteConfig.SiteName = SiteInfo.SiteName;
				SiteConfig.ServerName = SiteInfo.ServerName;
				SiteConfig.DocumentRoot = SiteInfo.DocumentRoot;
				if (ChangeTime == 0) OldWebsiteTitle = $("#Site_" + CurrentEditWebSite).html();
				$("#Site_" + CurrentEditWebSite).html('<span class="icon icon-globe"></span>' + SiteConfig.SiteName + ' *');
				WebsiteConfigChanged = true;
				ChangeTime = ChangeTime + 1;
			});
		} else {
			var WebsiteConfigString = Websites.getWebsiteConfigString(
				SiteConfig.WebsiteID,
				SiteConfig.SiteName,
				SiteConfig.ServerName,
				SiteConfig.DocumentRoot);
			fs.writeFileSync(path.join(TempDir, 'httpd-vhosts.conf'), WebsiteConfigString);
			$("#ConfigStr").val(WebsiteConfigString);
		}

		if (ChangeTime == 0) OldWebsiteTitle = $("#Site_" + CurrentEditWebSite).html();
		$("#Site_" + CurrentEditWebSite).html('<span class="icon icon-globe"></span>' + SiteConfig.SiteName + ' *');
		WebsiteConfigChanged = true;
		ChangeTime = ChangeTime + 1;
	}

	$("#WebsiteID").change(function() {
		changeConfigString();
	});

	$("#ServerName").change(function() {
		changeConfigString();
	});

	$("#SiteName").change(function() {
		changeConfigString();
	});

	$("#DocumentRoot").change(function() {
		changeConfigString();
	});

	$("#ConfigStr").change(function() {
		changeConfigString(true);
	});


	$("#ViewPath").bind('click', function(event) {
		dialog.showOpenDialog(win, {
			properties: ['openDirectory']
		}, (DirName) => {
			if (DirName) {
				$("#DocumentRoot").val(DirName[0]);
				changeConfigString();
			};
		})
	});

	$("#ToolCli").bind('click', function(event) {
		$("#DedeAMPZCli").click();
	});

	$("#ToolHost").bind('click', function(event) {
		exec('start notepad C:/Windows/System32/drivers/etc/hosts');
	});

	$("#ToolDB").bind('click', function(event) {
		exec('start http://localhost/adminer.php');
	});

	$("#SaveWebsiteConfig").bind('click', function(event) {
		if (CurrentEditWebSite != '') {
			var ConfigStr = $("#ConfigStr").val();
			var WebsiteINI = path.join(ConfigDir, 'vhosts', CurrentEditWebSite + '.conf');
			fs.writeFileSync(WebsiteINI, ConfigStr);
			var options = {
				title: 'DedeAMPZ',
				type: 'info',
				buttons: ['Ok'],
				message: 'DedeAMPZ',
				detail: '成功保存站点配置，您需要重启Apache服务器才能生效'
			};
			dialog.showMessageBox(win, options, function(response) {
				if (response == 0) {
					$("#Site_" + CurrentEditWebSite).html($("#Site_" + CurrentEditWebSite).html().replace(/\*$/, ""));

					WebsiteConfigChanged = false;
					ChangeTime = 0;
				}
			});
		} else {
			var WebSiteID = $("#SiteID").val();
			var DocumentRoot = $("#DocumentRoot").val();
			var ConfigStr = $("#ConfigStr").val();
			var InitByDedeCMS = $("#InitByDedeCMS").is(':checked');
			// todo :校验id是否重复、站点配置是否合法
			var WebsiteINI = path.join(ConfigDir, 'vhosts', WebSiteID + '.conf');
			fs.writeFileSync(WebsiteINI, ConfigStr);
			if(InitByDedeCMS == true)
			{
				var DedeIndexFile = path.join(SrcDir,'initDede','index.php');
				var SiteIndexFile = path.join(DocumentRoot,'index.php');
				var DedeLoadingGifFile = path.join(SrcDir,'initDede','loading1.gif');
				var SiteLoadingGifFile = path.join(DocumentRoot,'loading1.gif');
				fs.createReadStream(DedeIndexFile).pipe(fs.createWriteStream(SiteIndexFile));
				fs.createReadStream(DedeLoadingGifFile).pipe(fs.createWriteStream(SiteLoadingGifFile));
			}
			var options = {
				title: 'DedeAMPZ',
				type: 'info',
				buttons: ['Ok'],
				message: 'DedeAMPZ',
				detail: '成功保存站点配置，您需要重启Apache服务器才能生效'
			};
			dialog.showMessageBox(win, options, function(response) {
				if (response == 0) {
					loadWebsites();
					$("#SiteID").val("");
					$("#SiteName").val("");
					$("#ServerName").val("");
					$("#DocumentRoot").val("");
					$("#ConfigStr").val("");
					WebsiteConfigChanged = false;
					ChangeTime = 0;
				}
			});

		}

	});


	$("#addWebsite").bind('click', function(event) {
		CurrentEditWebSite = '';
		$("#SiteID").val('');
		$("#SiteName").val('');
		$("#ServerName").val('');
		$("#DocumentRoot").val('');
		$("#ConfigStr").val('');
		$("#SiteID").removeAttr("disabled");

		$(".nav-group-item").removeClass("active");
		$("#addWebsite").addClass("active");
		$('#moduleSetting').hide();
		$("#IsInitByDedeCMS").show();
		$('#websiteSetting').show();
		$('#indexSetting').hide();
	});

	// 创建托盘菜单
	log.debug('create tray');
	tray = new Tray(path.join(SrcDir, 'icon', 'dedeampz.ico'))
	const contextMenu = Menu.buildFromTemplate([{
		label: '重启Apache',
		click: function() {
			ipcRenderer.send('show');
			$("#RestartApache").click();
		}
	}, {
		label: '启动Apache',
		click: function() {
			ipcRenderer.send('show');
			$("#StartApache").click();
		}
	}, {
		label: '停止Apache',
		click: function() {
			ipcRenderer.send('show');
			$("#StopApache").click();
		}
	}, {
		type: 'separator'
	}, {
		label: '重启Mariadb',
		click: function() {
			ipcRenderer.send('show');
			$("#RestartMariadb").click();
		}
	}, {
		label: '启动Mariadb',
		click: function() {
			ipcRenderer.send('show');
			$("#StartMariadb").click();
		}
	}, {
		label: '停止Mariadb',
		click: function() {
			ipcRenderer.send('show');
			$("#StopMariadb").click();
		}
	}, {
		type: 'separator'
	}, {
		label: '命令行',
		click: function() {
			$("#ToolCli").click();
		}
	}, {
		label: 'Hosts编辑',
		click: function() {
			$("#ToolHost").click();
		}
	}, {
		label: '数据库管理',
		click: function() {
			$("#ToolDB").click();
		}
	}, {
		type: 'separator'
	}, {
		label: '退出',
		accelerator: 'Command+Q',
		click: function() {
			ipcRenderer.send('closeWindow');
		}
	}])
	tray.setToolTip('DedeAMPZ')
	tray.setContextMenu(contextMenu)

	tray.on('click', function() { // 左键单击时显示窗口
		ipcRenderer.send('show');
	});

	//initAMP();
	log.debug('create actions');
	$('#startDedeAMPZ').bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 15000);
		DedeAMPZ.startApache(function(info) {
			if (info.isend) {
				$("#StartMariadb").click();
			};
		});
	});

	$('#stopDedeAMPZ').bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 15000);
		DedeAMPZ.stopApache(function(info) {
			if (info.isend) {
				$("#StopMariadb").click();
			};
		});
	});

	$('#restartDedeAMPZ').bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 15000);
		DedeAMPZ.restartApache(function(info) {
			if (info.isend) {
				$("#RestartMariadb").click();
			};
		});
	});

	$("#DedeAMPZCli").bind('click', function(event) {
		event.preventDefault();
		exec('start ' + SetEnvCmd, {
			encoding: 'utf8',
			cwd: BaseDir
		}, (err, stdout, stderr) => {
			if (err) {
				console.error(err);
				return;
			}
			console.log(stdout);
		});
	});

	$('#about').bind('click', function(event) {
		event.preventDefault();
		App.about();
	});

	$("#RestartApache").bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.restartApache(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	$("#StartApache").bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.startApache(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	$('#StopApache').bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.stopApache(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	$("#RestartMariadb").bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.restartMariadb(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	$("#StartMariadb").bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.startMariadb(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	$('#StopMariadb').bind('click', function(event) {
		event.preventDefault();
		$('#Loading').show();
		setTimeout(function() {
			$('#Loading').hide();
		}, 10000);
		DedeAMPZ.stopMariadb(function(info) {
			if (info.isend) $('#Loading').hide();
		});
	});

	var showSettingPanel = function(itemname) {
		$(".nav-group-item").removeClass("active");
		$("#" + itemname).addClass("active");
		$('#moduleSetting').show();
		$('#websiteSetting').hide();
		$('#indexSetting').hide();
	}

	$("#indexDedeAMPZ2").bind('click', function(event) {
		event.preventDefault();
		$('#indexDedeAMPZ').click();
	});

	$('#indexDedeAMPZ').bind('click', function(event) {
		event.preventDefault();
		$(".nav-group-item").removeClass("active");
		$("#indexDedeAMPZ").addClass("active");
		$('#moduleSetting').hide();
		$('#websiteSetting').hide();
		$('#indexSetting').show();
	});

	$("#ActionApacheSetting").bind('click', function(event) {
		event.preventDefault();
		$('#settingApache').click();
	});
	$("#ActionMariadbSetting").bind('click', function(event) {
		event.preventDefault();
		$('#settingMariadb').click();
	});
	$("#ActionPHPSetting").bind('click', function(event) {
		event.preventDefault();
		$('#settingPHP').click();
	});

	var SettingType = '';

	$('#settingApache').bind('click', function(event) {
		event.preventDefault();
		showSettingPanel('settingApache');
		var ApacheConfigStr = DedeAMPZ.getApacheConfigStr();
		$("#settingAMP").val(ApacheConfigStr);
		SettingType = 'Apache';
	});

	$('#settingMariadb').bind('click', function(event) {
		event.preventDefault();
		showSettingPanel('settingMariadb');
		var MariadbConfigStr = DedeAMPZ.getMariadbConfigStr();
		$("#settingAMP").val(MariadbConfigStr);
		SettingType = 'Mariadb';
	});

	$('#settingPHP').bind('click', function(event) {
		event.preventDefault();
		showSettingPanel('settingPHP');
		var PHPConfigStr = DedeAMPZ.getPHPConfigStr();
		$("#settingAMP").val(PHPConfigStr);
		SettingType = 'PHP';
	});

	$('#SaveSettingAMP').bind('click', function(event) {
		event.preventDefault();
		if (SettingType == 'Apache') {
			ApacheConfigStr = $("#settingAMP").val();
			fs.writeFileSync(ApacheTempINI, ApacheConfigStr);
			var Result = DedeAMPZ.testApacheConfigStr();
			if (Result.status == 0) {
				fs.writeFileSync(ApacheINI, ApacheConfigStr);
				var options = {
					title: 'DedeAMPZ',
					type: 'info',
					buttons: ['Ok'],
					message: 'DedeAMPZ',
					detail: '成功保存Apache配置，您需要重启Apache服务器才能生效'
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {}
				});
			} else {
				var options = {
					title: 'DedeAMPZ',
					type: 'error',
					buttons: ['Ok', 'Cancel'],
					message: 'DedeAMPZ',
					detail: Result.stderr
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {
						//Todo:查看错误
						console.log('goto http://dedeampz.dedecms.com/error?q=' + Result.stderr);
					}
				});
			}
			console.log(Result);
			//alert(ApacheConfigStr);
		} else if (SettingType == 'Mariadb') {
			MariadbConfigStr = $("#settingAMP").val();
			fs.writeFileSync(MariadbTempINI, MariadbConfigStr);
			var Result = DedeAMPZ.testMariadbConfigStr();
			console.log(Result);
			if (Result.status == 0) {
				fs.writeFileSync(MariadbINI, MariadbConfigStr);
				var options = {
					title: 'DedeAMPZ',
					type: 'info',
					buttons: ['Ok'],
					message: 'DedeAMPZ',
					detail: '成功保存Mariadb配置，您需要重启Mariadb服务器才能生效'
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {}
				});
			} else {
				var options = {
					title: 'DedeAMPZ',
					type: 'error',
					buttons: ['Ok', 'Cancel'],
					message: 'DedeAMPZ',
					detail: Result.stderr
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {
						//Todo:查看错误
						console.log('goto http://dedeampz.dedecms.com/error?q=' + Result.stderr);
					}
				});
			}
			console.log(Result);
		} else {
			PHPConfigStr = $("#settingAMP").val();
			fs.writeFileSync(PHPTempINI, PHPConfigStr);
			var Result = DedeAMPZ.testPHPConfigStr();
			if (Result) {
				fs.writeFileSync(PHPINI, PHPConfigStr);
				var options = {
					title: 'DedeAMPZ',
					type: 'info',
					buttons: ['Ok'],
					message: 'DedeAMPZ',
					detail: '成功保存PHP配置，您需要重启Apache服务器才能生效'
				};
				dialog.showMessageBox(win, options, function(response) {
					if (response == 0) {}
				});
			}
		}
	});

	$("#CancelSettingAMP").bind('click', function(event) {
		event.preventDefault();
		if (SettingType == 'Apache') {
			$('#settingApache').click();
		} else if (SettingType == 'Mariadb') {
			$('#settingMariadb').click();
		} else {
			$('#settingPHP').click();
		}
	});

	$("#ClearLog").bind('click', function(event) {
		event.preventDefault();
		$('#showDedeAMPZ').val('');
	});

	$("#showDedeAMPZ").change(function() {
		console.log($('#showDedeAMPZ').val());
		DedeAMPZ.clearControlLog();
	});

	var uuid = execSync("wmic path win32_computersystemproduct get uuid").toString().replace(/^UUID(.*?)/gm, "").trim();
	UserInfo.uuid = uuid;
	console.log(UserInfo);
	request.post({
		url: 'http://dedeampz.dedecms.com/checkupdate/' + DedeAMPZ_Version,
		form: {
			UserInfo
		}
	}, function(err, httpResponse, body) {
		if(body != 'latest'){
			var ExePath = path.join(path.dirname(app.getPath("exe")), "Update.exe");
			exec("start "+ExePath);
		}
	})

});