/**
 * Copyright (c) 2016-present, DesDev, Inc.
 * All rights reserved.
 *
 * Official:http://dedeampz.dedecms.com
 *
 * Company:http://www.desdev.cn
 */

const {
	remote
} = require('electron')
const {
	Menu, MenuItem
} = remote;

var CurrentModule = '';
var CurrentWebsite = '';

const MenuAMP = new Menu();
MenuAMP.append(new MenuItem({
	label: '重启',
	click() {
		if (CurrentModule == 'Apache') {
			//$("#indexDedeAMPZ").click();
			$("#RestartApache").click();
		} else if (CurrentModule == 'Mariadb') {
			$("#RestartMariadb").click();
		}
	}
}))
MenuAMP.append(new MenuItem({
	type: 'separator',
}))
MenuAMP.append(new MenuItem({
	label: '启动',
	click() {
		if (CurrentModule == 'Apache') {
			//$("#indexDedeAMPZ").click();
			$("#StartApache").click();
		} else if (CurrentModule == 'Mariadb') {
			$("#StartMariadb").click();
		}
	}
}))
MenuAMP.append(new MenuItem({
	label: '停止',
	click() {
		if (CurrentModule == 'Apache') {
			//$("#indexDedeAMPZ").click();
			$("#StopApache").click();
		} else if (CurrentModule == 'Mariadb') {
			$("#StopMariadb").click();
		}
	}
}))
MenuAMP.append(new MenuItem({
	type: 'separator',
}))
MenuAMP.append(new MenuItem({
	label: '配置',
	click() {
		if (CurrentModule == 'Apache') {
			//$("#indexDedeAMPZ").click();
			$("#settingApache").click();
		} else if (CurrentModule == 'Mariadb') {
			$("#settingMariadb").click();
		} else {
			$("#settingPHP").click();
		}
	}
}))

const MenuWebsite = new Menu()
MenuWebsite.append(new MenuItem({
	label: '访问',
	click() {
		Websites.getOne(CurrentWebsite, (Website) => {
			exec('start http://' + Website.ServerName);
		});
	}
}))
MenuWebsite.append(new MenuItem({
	label: '浏览',
	click() {
		Websites.getOne(CurrentWebsite, (Website) => {
			exec('start explorer ' + Website.DocumentRoot.replace(/\//g,"\\"));
		});
	}
}))
MenuWebsite.append(new MenuItem({
	label: '命令行',
	click() {
		Websites.getOne(CurrentWebsite, (Website) => {
			exec('start ' + SetEnvCmd + " " + Website.DocumentRoot + " " + Website.SiteID);
		});
	}
}))
MenuWebsite.append(new MenuItem({
	label: '编辑',
	click() {
		Websites.getOne(CurrentWebsite, (Website) => {
			$("#Site_" + Website.SiteID).click();
		});
	}
}))
MenuWebsite.append(new MenuItem({
	type: 'separator',
}))
//MenuWebsite.append(new MenuItem({
//	label: '禁用',
//	click() {
//		console.log('item 2 clicked')
//	}
//}))
MenuWebsite.append(new MenuItem({
	label: '删除',
	click() {
		var options = {
			title: 'DedeAMPZ',
			type: 'info',
			buttons: ['Yes', 'No'],
			message: 'DedeAMPZ',
			detail: '确定删除当前选定站点？'
		};
		dialog.showMessageBox(win, options, (response) => {
			if (response == 0) {
				Websites.deleteOne(CurrentWebsite);
			}
		});
		
		
	}
}))

window.addEventListener('contextmenu', (e) => {
	event.preventDefault();
	if (e.clientY < 35) {
		return;
	}
	if (e.clientX < 220) {
		//console.log(e);
		if (e.target.id == 'settingApache' || e.target.id == 'settingMariadb' || e.target.id == 'settingPHP') {
			MenuAMP.items[0].enabled = true;
			MenuAMP.items[1].enabled = true;
			MenuAMP.items[2].enabled = true;
			MenuAMP.items[3].enabled = true;
			if (e.target.id == 'settingApache') CurrentModule = 'Apache';
			if (e.target.id == 'settingMariadb') CurrentModule = 'Mariadb';
			if (e.target.id == 'settingPHP') {
				MenuAMP.items[0].enabled = false;
				MenuAMP.items[1].enabled = false;
				MenuAMP.items[2].enabled = false;
				MenuAMP.items[3].enabled = false;
				CurrentModule = 'PHP';
			}
			MenuAMP.popup(remote.getCurrentWindow());
			return;
		}
		if (e.target.className == 'sitenav nav-group-item' || e.target.className == 'sitenav nav-group-item active') {
			if (e.target.id.match(/^Site/)) {
				CurrentWebsite = e.target.id.replace(/Site_/, '');
			} else {
				return;
			}
			MenuWebsite.popup(remote.getCurrentWindow());
			return;
		}
	}
}, false)