/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.common;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolver;
import com.inprise.vbroker.compiler.backends.depsolver.DependencySpec;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.SimpleStringBuffer;
import java.io.File;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class GenericBackend {
    private static final boolean _trace = false;
    protected DependencySpec _depSpec;
    protected DepSolver _depSolver;
    protected DepSolver _topDepSolver;
    protected BufferWriter _bufferWriter;
    protected static final String LINE_SEP;
    protected static final char LINE_SEP_CHAR;
    protected static final String COMMA_LINE_SEP;
    protected int _preferredLineWidth = 78;
    protected int _horizPos;
    private int _savedHorizPos;
    protected int _virtualCharCount;
    private int[] _virtualCountStack = new int[10];
    private int[] _realCountStack = new int[10];
    private int _conditionalStackDepth;
    private Stack _bufferPool = new Stack();
    public ErrorReporter _ER;
    protected static final String[] SPACES;
    protected RepositoryNode _repository;
    protected CommonOptions _options;
    protected int _rootFile;
    protected Stack _openFiles = new Stack();
    protected SimpleStringBuffer _outputBuffer;
    public SimpleStringBuffer Buffer = this._outputBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer _formerBuffer;
    private SimpleStringBuffer _lineBreakBuffer = new SimpleStringBuffer();
    private SimpleStringBuffer _tmpBuffer = new SimpleStringBuffer();
    public Hashtable FileTable = new Hashtable();
    protected static final int NUM_SPACES_PER_INDENT = 2;
    public int Indent = 0;
    public String TabString = null;

    protected GenericBackend(RepositoryNode repositoryNode, DependencySpec dependencySpec, String string, BufferWriter bufferWriter) {
        this._repository = repositoryNode;
        this._depSpec = dependencySpec;
        this._bufferWriter = bufferWriter;
        if (this._repository != null) {
            this._ER = this._repository._ER;
            this._rootFile = this._ER.setFile(string);
        }
    }

    protected void _dispatch(ContainedNode containedNode, String string) {
        int n = containedNode._kind;
        switch (n) {
            case 7: {
                this.genOperation((OperationNode)containedNode);
                break;
            }
            case 5: {
                this.genInterface((InterfaceNode)containedNode);
                break;
            }
            case 2: {
                this.genAttribute((AttributeNode)containedNode);
                break;
            }
            case 9: {
                this.genAlias((AliasNode)containedNode);
                break;
            }
            case 4: {
                this.genException((ExceptionNode)containedNode);
                break;
            }
            case 3: {
                this.genConstant((ConstantNode)containedNode);
                break;
            }
            case 22: {
                this.genValueMember((ValueMemberNode)containedNode);
                break;
            }
            case 20: {
                this.genValue((ValueNode)containedNode);
                break;
            }
            case 21: {
                this.genValueBox((ValueBoxNode)containedNode);
                break;
            }
            case 23: {
                this.genNative((NativeNode)containedNode);
                break;
            }
            case 12: {
                this.genEnum((EnumNode)containedNode, string);
                break;
            }
            case 10: {
                this.genStruct((StructNode)containedNode, string);
                break;
            }
            case 11: {
                this.genUnion((UnionNode)containedNode, string);
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("unknown or invalid type ").append(Node.typeName(n)).append(" (").append(n).append(") in GeneraticBackend.dispatch()"))));
            }
        }
    }

    protected void add(char c) {
        this.Buffer.append(c);
        ++this._horizPos;
        ++this._virtualCharCount;
    }

    protected void add(int n) {
        this.add(Integer.toString(n));
    }

    protected void add(String string) {
        int n = string.length();
        this.Buffer.append(string);
        this._horizPos += n;
        this._virtualCharCount += n;
    }

    protected void addln(char c) {
        this.Buffer.append(c);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += 2;
    }

    protected void addln(int n) {
        this.addln(Integer.toString(n));
    }

    protected void addln(long l) {
        this.addln(Long.toString(l));
    }

    protected void addln(String string) {
        int n = string.length();
        this.Buffer.append(string);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += n + 1;
    }

    protected void beginLineBreaking() {
        this._savedHorizPos = this._horizPos;
        this._lineBreakBuffer.reset();
        this._formerBuffer = this.Buffer;
        this.Buffer = this._lineBreakBuffer;
    }

    protected void beginModule(ModuleNode moduleNode) {
    }

    protected void beginRepository(RepositoryNode repositoryNode) {
    }

    protected void closeFile() {
        this.closeFile(true);
    }

    protected void closeFile(String string, boolean bl) {
        if (this.Indent != 0) {
            if (this._ER._verbose) {
                this._ER.untranslatedMessage(String.valueOf(String.valueOf(new StringBuffer("Bad Indent ").append(this.Indent).append("at close of file ").append(string))));
            }
            this.Indent = 0;
        }
        String string2 = this._options._rootDir != null ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._options._rootDir))).append(File.separatorChar).append(string))) : string;
        Object v = this.FileTable.get(string);
        if (v == null) {
            this._ER.fatal("Comp.BE.generatingNonExistent", new Object[]{string2});
        } else {
            if (v == Boolean.TRUE || v == Boolean.FALSE) {
                throw new RuntimeException("attempting to close previously closed file".concat(String.valueOf(String.valueOf(string2))));
            }
            if (this._options._listFiles) {
                System.out.println(string2);
            }
            if (this._bufferWriter.write(string2, (SimpleStringBuffer)v, true, this._bufferPool, bl)) {
                this.FileTable.put(string2, Boolean.TRUE);
            } else {
                this.FileTable.put(string2, Boolean.FALSE);
            }
        }
    }

    protected void closeFile(boolean bl) {
        this.closeFile((String)this._openFiles.pop(), bl);
        if (!this._openFiles.empty()) {
            this.useFile((String)this._openFiles.peek());
        }
    }

    protected void closeModule(ModuleNode moduleNode) {
    }

    protected final void commaSepDefs(Vector vector, boolean bl) {
        int n = this._horizPos;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            String string;
            ContainedNode containedNode = (ContainedNode)vector.elementAt(i);
            String string2 = string = bl ? containedNode._beFullName : containedNode._beName;
            if (i == 0) {
                this.add(string);
                continue;
            }
            if (this._horizPos > n && this._horizPos + string.length() + 2 > this._preferredLineWidth) {
                this.add(",");
                this.newLine();
                this.indentTo(n);
            } else {
                this.add(", ");
            }
            this.add(string);
        }
    }

    protected final void commaSepList(Type type, Vector vector) {
        int n = this._horizPos;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            String string = type.toLiteral(vector.elementAt(i));
            if (i == 0) {
                this.add(string);
                continue;
            }
            if (this._horizPos > n && this._horizPos + string.length() + 2 > this._preferredLineWidth) {
                this.add(",");
                this.newLine();
                this.indentTo(n);
            } else {
                this.add(", ");
            }
            this.add(string);
        }
    }

    public void dispatch(ContainedNode containedNode) {
        if (containedNode._kind == 6) {
            ModuleNode moduleNode = (ModuleNode)containedNode;
            this.beginModule(moduleNode);
            this.endModule(moduleNode);
        } else {
            this._dispatch(containedNode, null);
        }
    }

    protected void dispatch(ContainedNode containedNode, String string) {
        this._dispatch(containedNode, string);
    }

    protected void endLineBreaking() {
        this.Buffer = this._formerBuffer;
        this._horizPos = this._savedHorizPos;
        boolean bl = true;
        String string = this._lineBreakBuffer.toString();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                c = string.charAt(i + 1);
                while (i + 1 < n && (c == ' ' || c == '\n' || c == '\r' || c == '\t')) {
                    c = string.charAt(++i + 1);
                }
                this._tmpBuffer.append(',');
                bl = this.lineBreakWord(bl);
                continue;
            }
            this._tmpBuffer.append(c);
        }
        this.lineBreakWord(bl);
    }

    protected void endModule(ModuleNode moduleNode) {
    }

    protected void endRepository(RepositoryNode repositoryNode) {
    }

    protected void ensureIndent() {
        if (this._horizPos == 0) {
            this.indent();
        }
    }

    protected void ensureNewLine() {
        if (this._horizPos != 0) {
            this.newLine();
        }
    }

    protected void finish() {
    }

    private final void finishNodes(DepSolver depSolver) {
        this._repository.finish(2);
        int n = depSolver._numDefinitions;
        for (int i = 0; i < n; ++i) {
            ContainedNode containedNode = depSolver._definitions[i];
            int n2 = depSolver._codes[i];
            boolean bl = containedNode.finish(n2);
            if (containedNode.isContainer() && n2 == 6 || containedNode._kind == 6 && n2 == 2 && !this._depSpec._modulesAreBreakable) {
                DepSolver.ContainerDepNode containerDepNode = (DepSolver.ContainerDepNode)depSolver.idlDefn2DepNode(containedNode, true);
                this.finishNodes(containerDepNode.Subgraph);
            }
            if (bl && (this._options._genInclFiles || containedNode._fileNumber == this._rootFile)) continue;
            depSolver._definitions[i] = null;
        }
    }

    protected void forwardDeclareInterface(InterfaceNode interfaceNode) {
    }

    protected void forwardDeclareValue(ValueNode valueNode) {
    }

    protected void gen() {
        if (this._depSolver == this._topDepSolver) {
            this.beginRepository(this._repository);
        }
        int n = this._depSolver._numDefinitions;
        block8: for (int i = 0; i < n; ++i) {
            ContainedNode containedNode = this._depSolver._definitions[i];
            int n2 = this._depSolver._codes[i];
            if (containedNode == null) continue;
            switch (n2) {
                case 6: {
                    this.dispatch(containedNode, null);
                    continue block8;
                }
                case 4: {
                    this.openModule((ModuleNode)containedNode);
                    continue block8;
                }
                case 5: {
                    this.closeModule((ModuleNode)containedNode);
                    continue block8;
                }
                case 3: {
                    this.endModule((ModuleNode)containedNode);
                    continue block8;
                }
                case 2: {
                    this.beginModule((ModuleNode)containedNode);
                    continue block8;
                }
                case 1: {
                    if (containedNode instanceof InterfaceNode) {
                        this.forwardDeclareInterface((InterfaceNode)containedNode);
                        continue block8;
                    }
                    this.forwardDeclareValue((ValueNode)containedNode);
                    continue block8;
                }
                default: {
                    this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid generation code (").append(this._depSolver._codes[i]).append(") from DepSolver"))));
                }
            }
        }
        if (this._depSolver == this._topDepSolver) {
            this.endRepository(this._repository);
        }
    }

    protected void genAlias(AliasNode aliasNode) {
    }

    protected void genAttribute(AttributeNode attributeNode) {
    }

    protected void genConstant(ConstantNode constantNode) {
    }

    protected void genContents(ContainerNode containerNode) {
        DepSolver.ContainerDepNode containerDepNode = (DepSolver.ContainerDepNode)this._depSolver.idlDefn2DepNode((Node)((Object)containerNode), true);
        DepSolver depSolver = this._depSolver;
        this._depSolver = containerDepNode.Subgraph;
        this.gen();
        this._depSolver = depSolver;
    }

    protected void genEnum(EnumNode enumNode, String string) {
    }

    protected void genException(ExceptionNode exceptionNode) {
    }

    protected void genInterface(InterfaceNode interfaceNode) {
    }

    protected void genNative(NativeNode nativeNode) {
    }

    protected void genOperation(OperationNode operationNode) {
    }

    protected void genStruct(StructNode structNode, String string) {
    }

    protected void genUnion(UnionNode unionNode, String string) {
    }

    protected void genValue(ValueNode valueNode) {
    }

    protected void genValueBox(ValueBoxNode valueBoxNode) {
    }

    protected void genValueMember(ValueMemberNode valueMemberNode) {
    }

    public void generate(ContainerNode containerNode) {
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        this._topDepSolver = this._depSolver = new DepSolver(this._depSpec, containerNode);
        this.initialize();
        this.finishNodes(this._depSolver);
        this.gen();
        this.finish();
    }

    protected String getCurrentIndent() {
        if (this.TabString == null) {
            if (this.Indent == 0) {
                return "";
            }
            if (this.Indent == 1) {
                return "  ";
            }
            if (this.Indent == 2) {
                return "    ";
            }
            String string = "";
            for (int i = 0; i < this.Indent * 2; ++i) {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(' ')));
            }
            return string;
        }
        return this.TabString;
    }

    protected void indent() {
        if (this.TabString == null) {
            int n = 2 * this.Indent;
            this.Buffer.append(' ', n);
            this._horizPos += n;
        } else {
            int n = this.TabString.length();
            this.Buffer.append(this.TabString);
            this._horizPos += n;
        }
    }

    protected void indentTo(int n) {
        this.Buffer.append(' ', n);
        this._horizPos += n;
    }

    protected void initialize() {
        this._options = this._repository._options;
        this._repository.finishParameterizedTypes();
    }

    protected final boolean isForwardDeclared(InheritableNode inheritableNode) {
        return this._depSolver.isForwardDeclared(inheritableNode);
    }

    private final boolean lineBreakWord(boolean bl) {
        if (this._tmpBuffer.length() > 0) {
            String string = this._tmpBuffer.toString();
            this._tmpBuffer.reset();
            if (bl) {
                this.add(string);
            } else if (this._horizPos + 1 + string.length() > this._preferredLineWidth && this._horizPos > this._savedHorizPos) {
                this.newLine();
                this.indentTo(this._savedHorizPos);
                this.add(string);
            } else {
                this.add(' ');
                this.add(string);
            }
            return false;
        }
        return bl;
    }

    protected void newLine() {
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        ++this._virtualCharCount;
    }

    protected void openModule(ModuleNode moduleNode) {
    }

    protected final void popConditional(int n) {
        --this._conditionalStackDepth;
        int n2 = this._virtualCountStack[this._conditionalStackDepth];
        int n3 = this._realCountStack[this._conditionalStackDepth];
        int n4 = this._virtualCharCount - n2;
        if (n4 <= n) {
            this.Buffer.reset(n3);
            this._virtualCharCount = n2;
        }
    }

    protected final void print(char c) {
        this.indent();
        this.Buffer.append(c);
        ++this._horizPos;
        ++this._virtualCharCount;
    }

    protected final void print(int n) {
        this.print(Integer.toString(n));
    }

    protected void print(String string) {
        this.indent();
        int n = string.length();
        this.Buffer.append(string);
        this._horizPos += n;
        this._virtualCharCount += n;
    }

    protected final void println(char c) {
        this.indent();
        this.Buffer.append(c);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += 2;
    }

    protected void println(String string) {
        this.indent();
        int n = string.length();
        this.Buffer.append(string);
        this.Buffer.append(LINE_SEP);
        this._horizPos = 0;
        this._virtualCharCount += n + 1;
    }

    protected final void pushConditional() {
        this._virtualCountStack[this._conditionalStackDepth] = this._virtualCharCount;
        this._realCountStack[this._conditionalStackDepth] = this.Buffer.length();
        ++this._conditionalStackDepth;
    }

    protected void useFile(String string) {
        this.useFile(string, 32768);
    }

    protected void useFile(String string, int n) {
        Object v = this.FileTable.get(string);
        if (v == null) {
            if (this._bufferPool.size() > 0) {
                this.Buffer = (SimpleStringBuffer)this._bufferPool.pop();
                this.Buffer.ensureCapacity(n);
            } else {
                this.Buffer = new SimpleStringBuffer(n);
            }
            this.FileTable.put(string, this.Buffer);
            this._openFiles.push(string);
        } else {
            if (v == Boolean.FALSE) {
                String string2 = string;
                if (this._options._rootDir != null) {
                    string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._options._rootDir))).append(File.separatorChar).append(string)));
                }
                throw new RuntimeException(String.valueOf(String.valueOf(new StringBuffer("attempt to re-open file ").append(string2).append(" after closing it"))));
            }
            this.Buffer = (SimpleStringBuffer)v;
        }
    }

    static {
        _trace = false;
        LINE_SEP = System.getProperty("line.separator");
        LINE_SEP_CHAR = LINE_SEP.charAt(0);
        COMMA_LINE_SEP = ",".concat(String.valueOf(String.valueOf(LINE_SEP)));
        SPACES = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " "};
        NUM_SPACES_PER_INDENT = 2;
    }
}

