/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.depsolver;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InheritableNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.backends.depsolver.DependencySpec;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import java.util.Hashtable;
import java.util.Vector;

public final class DepSolver
implements DepSolverDefs {
    private boolean Trace = false;
    public ErrorReporter _ER;
    private boolean Toplevel = false;
    private DependencySpec DepSpec;
    public ContainedNode[] _definitions;
    public int _numDefinitions;
    public int[] _codes;
    private Vector DepNodes = new Vector(100);
    public Hashtable IdlNode2DepNodeMap;
    private Vector NodesInCycle;
    private ModuleNode currentModule;
    private int currentModuleIndex;
    private Vector _v = new Vector();
    private ContainedNode[] _tmpDefinitions;
    private int[] _tmpCodes;
    private Hashtable modulesSeen = new Hashtable();

    public DepSolver(DependencySpec dependencySpec, ContainerNode containerNode) {
        this(dependencySpec, containerNode, new Hashtable(200), new Vector(), true);
        this.solveIt();
    }

    DepSolver(DependencySpec dependencySpec, ContainerNode containerNode, Hashtable hashtable, Vector vector, boolean bl) {
        int n;
        this._ER = containerNode.ER();
        this.DepSpec = dependencySpec;
        this.IdlNode2DepNodeMap = hashtable;
        this.NodesInCycle = vector;
        this.Toplevel = bl;
        this.createDependencyNodes(containerNode);
        switch (containerNode.kind()) {
            case 6: {
                n = ((ContainedContainerNode)containerNode)._contents.size() * 2;
                break;
            }
            case 17: {
                n = ((RepositoryNode)containerNode).numObjects() * 2;
                break;
            }
            default: {
                n = ((ContainedContainerNode)containerNode)._contents.size();
            }
        }
        this._definitions = new ContainedNode[n];
        this._codes = new int[n];
    }

    private boolean breakable(int n) {
        return n == 6 ? this.DepSpec._modulesAreBreakable : false;
    }

    public boolean breakable(ContainerNode containerNode) {
        return containerNode.kind() == 6 ? this.DepSpec._modulesAreBreakable : false;
    }

    private boolean canForwardDeclare(DepNode depNode, int n) {
        Object v;
        DepNode depNode2 = (DepNode)depNode.DependsOnDecl.elementAt(n);
        ContainedNode containedNode = depNode2.IDLDefn;
        if (containedNode._kind == 5) {
            if (!this.DepSpec._inheritablesCanBeForwardDeclared) {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(depNode2.name())).concat(" cannot be forward declared because *no* interfaces can be."));
                }
                return false;
            }
        } else if (containedNode._kind == 20) {
            if (!this.DepSpec._inheritablesCanBeForwardDeclared) {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(depNode2.name())).concat(" cannot be forward declared because *no* values can be."));
                }
                return false;
            }
        } else {
            if (this.Trace) {
                System.err.println(String.valueOf(String.valueOf(depNode2.name())).concat(" cannot be forward declared because it is neither an interface nor a value."));
            }
            return false;
        }
        if ((v = this.IdlNode2DepNodeMap.get(containedNode)) instanceof DepNode[]) {
            depNode.DependsOnDecl.setElementAt(((DepNode[])v)[0], n);
            if (this.Trace) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Declaration for ").append(depNode2.name()).append(" already exists; switching to it."))));
            }
            return true;
        }
        DepNode[] depNodeArray = new DepNode[]{new DepNode(depNode2.IDLDefn, false), depNode2};
        ModuleNode moduleNode = this.moduleOf(depNode2.IDLDefn);
        if (moduleNode != null) {
            depNodeArray[0].addDependency(this.idlDefn2DepNode(moduleNode, true), true);
        }
        this.IdlNode2DepNodeMap.put(depNode2.IDLDefn, depNodeArray);
        depNode.DependsOnDecl.setElementAt(depNodeArray[0], n);
        if (this.Trace) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating declaration for ").append(depNode2.name()).append(" and switching ").append(depNode.name()).append("'s edge to it."))));
        }
        return true;
    }

    private void cleanupSolutionTrace() {
        ModuleNode moduleNode;
        ContainedNode containedNode;
        int n;
        this._tmpDefinitions = new ContainedNode[this._numDefinitions * 4];
        this._tmpCodes = new int[this._numDefinitions * 4];
        for (n = 0; n < this._numDefinitions; ++n) {
            containedNode = this._definitions[n];
            moduleNode = this.moduleOf(containedNode);
            if (moduleNode != this.currentModule) {
                if (this.currentModule == null) {
                    this.openModule(moduleNode);
                } else if (moduleNode == null) {
                    this.closeModule(null);
                } else {
                    this.closeModule(moduleNode);
                    if (this.currentModule != moduleNode) {
                        this.openModule(moduleNode);
                    }
                }
            }
            if (this.currentModuleIndex == this._tmpDefinitions.length) {
                this.expandTmpArrays();
            }
            this._tmpDefinitions[this.currentModuleIndex] = this._definitions[n];
            this._tmpCodes[this.currentModuleIndex] = this._codes[n];
            ++this.currentModuleIndex;
        }
        if (this.currentModule != null) {
            this.closeModule(this.currentModule);
        }
        for (n = this.currentModuleIndex - 1; n >= 0; --n) {
            containedNode = this._tmpDefinitions[n];
            if (containedNode._kind != 6 || this.modulesSeen.get(moduleNode = (ModuleNode)containedNode) != Boolean.TRUE) continue;
            this.modulesSeen.put(moduleNode, Boolean.FALSE);
            this._tmpCodes[n] = 3;
        }
        this._numDefinitions = this.currentModuleIndex;
        this._definitions = new ContainedNode[this._numDefinitions];
        this._codes = new int[this._numDefinitions];
        System.arraycopy(this._tmpDefinitions, 0, this._definitions, 0, this._numDefinitions);
        System.arraycopy(this._tmpCodes, 0, this._codes, 0, this._numDefinitions);
        this._tmpDefinitions = null;
        this._tmpCodes = null;
    }

    private void cleanupSolutionTraceForUnbreakableModules() {
        int n;
        int n2 = 0;
        for (n = 0; n < this._numDefinitions; ++n) {
            if (this._definitions[n]._kind != 6) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        n = this._numDefinitions + n2;
        this._tmpDefinitions = new ContainedNode[n];
        this._tmpCodes = new int[n];
        int n3 = 0;
        for (int i = 0; i < this._numDefinitions; ++i) {
            if (this._definitions[i]._kind == 6) {
                this._tmpDefinitions[n3] = this._definitions[i];
                this._tmpCodes[n3++] = 2;
                this._tmpDefinitions[n3] = this._definitions[i];
                this._tmpCodes[n3++] = 3;
                ((ContainerDepNode)this.idlDefn2DepNode((Node)this._definitions[i], (boolean)true)).Subgraph.cleanupSolutionTraceForUnbreakableModules();
                continue;
            }
            this._tmpDefinitions[n3] = this._definitions[i];
            this._tmpCodes[n3++] = this._codes[i];
        }
        this._definitions = this._tmpDefinitions;
        this._codes = this._tmpCodes;
        this._numDefinitions = this._tmpDefinitions.length;
    }

    private void closeModule(ModuleNode moduleNode) {
        ContainerNode containerNode = DepSolver.lca(this.currentModule, moduleNode);
        do {
            if (this.currentModuleIndex == this._tmpDefinitions.length) {
                this.expandTmpArrays();
            }
            this._tmpDefinitions[this.currentModuleIndex] = this.currentModule;
            this._tmpCodes[this.currentModuleIndex] = 5;
            ++this.currentModuleIndex;
            ContainerNode containerNode2 = this.currentModule._container;
            if (!(containerNode2 instanceof ModuleNode)) {
                this.currentModule = null;
                return;
            }
            this.currentModule = (ModuleNode)containerNode2;
        } while (this.currentModule != containerNode);
    }

    private void createDependencyEdges() {
        if (this.Trace) {
            System.err.println("createDependencyEdges invoked.");
        }
        int n = this.DepNodes.size();
        for (int i = 0; i < n; ++i) {
            DepNode depNode = (DepNode)this.DepNodes.elementAt(i);
            this.createEdgesFor(depNode);
            if (!(depNode instanceof ContainerDepNode)) continue;
            ((ContainerDepNode)depNode).Subgraph.createDependencyEdges();
        }
    }

    private void createDependencyNodes(ContainerNode containerNode) {
        if (this.Trace) {
            System.err.println("createDependencyNodes invoked.");
        }
        Vector vector = containerNode.contents();
        for (int i = 0; i < vector.size(); ++i) {
            DepNode depNode;
            boolean bl;
            Node node = (Node)vector.elementAt(i);
            int n = node._kind;
            if (n == 24) continue;
            if (n == 23) {
                ContainedNode containedNode = (ContainedNode)node;
                if (containedNode._name.equals("TypeCode") || containedNode._name.equals("Principal")) continue;
            }
            if ((bl = Node.isContainer(n)) && !this.breakable(n)) {
                depNode = new ContainerDepNode(this, (ContainerNode)vector.elementAt(i));
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating (unbreakable) container node for ").append(((ContainedNode)vector.elementAt((int)i))._name).append("."))));
                }
            } else {
                depNode = new DepNode((ContainedNode)vector.elementAt(i), true);
                if (bl) {
                    this.createDependencyNodes((ContainerNode)vector.elementAt(i));
                }
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating node for ").append(((ContainedNode)vector.elementAt((int)i))._name).append("."))));
                }
            }
            this.IdlNode2DepNodeMap.put(vector.elementAt(i), depNode);
            this.DepNodes.addElement(depNode);
        }
    }

    private void createEdgesFor(DepNode depNode) {
        int n = depNode.IDLDefn._kind;
        switch (depNode.IDLDefn._kind) {
            case 6: 
            case 12: 
            case 23: {
                this.recordDependencyOnContainer(depNode);
                break;
            }
            case 3: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for constant ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                ConstantNode constantNode = (ConstantNode)depNode.IDLDefn;
                Type type = constantNode._type;
                this.recordTypeDependenciesFor(depNode, type, false);
                break;
            }
            case 4: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for exception ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Vector vector = ((ExceptionNode)depNode.IDLDefn)._memberTypes;
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    Type type = (Type)vector.elementAt(i);
                    this.recordTypeDependenciesFor(depNode, type, false);
                }
                break;
            }
            case 5: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for interface ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                InterfaceNode interfaceNode = (InterfaceNode)depNode.IDLDefn;
                Vector vector = interfaceNode._bases;
                for (int i = 0; i < vector.size(); ++i) {
                    InterfaceNode interfaceNode2 = (InterfaceNode)vector.elementAt(i);
                    depNode.addDependency(this.idlDefn2DepNode(interfaceNode2, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
                }
                break;
            }
            case 20: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for value ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                ValueNode valueNode = (ValueNode)depNode.IDLDefn;
                this.recordDependencyOnSuperValues(depNode);
                this.recordDependencyOnSuperInterfaces(depNode);
                Vector vector = valueNode._initParamTypes;
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector2 = (Vector)vector.elementAt(i);
                    for (int j = 0; j < vector2.size(); ++j) {
                        this.recordTypeDependenciesFor(depNode, (Type)vector2.elementAt(j), false);
                    }
                }
                break;
            }
            case 22: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for value member ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Type type = ((ValueMemberNode)depNode.IDLDefn)._type;
                this.recordTypeDependenciesFor(depNode, type, false);
                break;
            }
            case 10: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for struct ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Vector vector = ((StructNode)depNode.IDLDefn)._memberTypes;
                int n3 = vector.size();
                for (int i = 0; i < n3; ++i) {
                    Type type = (Type)vector.elementAt(i);
                    this.recordTypeDependenciesFor(depNode, type, false);
                }
                break;
            }
            case 7: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for operation ").append(depNode.name()).append("."))));
                }
                this.recordDependenciesForOperation(depNode);
                break;
            }
            case 9: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for alias ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Type type = ((AliasNode)depNode.IDLDefn)._type;
                this.recordTypeDependenciesFor(depNode, type, false);
                break;
            }
            case 21: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for value box ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Type type = ((ValueBoxNode)depNode.IDLDefn)._type;
                this.recordTypeDependenciesFor(depNode, type, false);
                break;
            }
            case 2: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for attribute ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Type type = ((AttributeNode)depNode.IDLDefn)._type;
                this.recordTypeDependenciesFor(depNode, type, false);
                break;
            }
            case 11: {
                if (this.Trace) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("Creating edges for union ").append(depNode.name()).append("."))));
                }
                this.recordDependencyOnContainer(depNode);
                Type type = ((UnionNode)depNode.IDLDefn)._discriminator;
                if (!(type instanceof EnumNode) || ((EnumNode)type)._container != depNode.IDLDefn) {
                    this.recordTypeDependenciesFor(depNode, type, false);
                }
                Vector vector = ((UnionNode)depNode.IDLDefn)._memberTypes;
                int n4 = vector.size();
                for (int i = 0; i < n4; ++i) {
                    Type type2 = (Type)vector.elementAt(i);
                    this.recordTypeDependenciesFor(depNode, type2, false);
                }
                break;
            }
            default: {
                this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(String.valueOf(new StringBuffer("unknown or invalid IDL type ").append(Node.typeName(n)).append(" (").append(n).append(")")))});
            }
        }
    }

    private static boolean definedWithin(ContainedNode containedNode, ContainerNode containerNode) {
        ContainerNode containerNode2 = containedNode._container;
        while (containerNode2 != null && !(containerNode2 instanceof RepositoryNode)) {
            if (containerNode2 == containerNode) {
                return true;
            }
            containerNode2 = ((ContainedNode)((Object)containerNode2))._container;
        }
        return false;
    }

    private void expandTmpArrays() {
        ContainedNode[] containedNodeArray = new ContainedNode[this._tmpDefinitions.length * 2];
        int[] nArray = new int[this._tmpDefinitions.length * 2];
        System.arraycopy(this._tmpDefinitions, 0, containedNodeArray, 0, this._tmpDefinitions.length);
        System.arraycopy(this._tmpCodes, 0, nArray, 0, this._tmpDefinitions.length);
        this._tmpDefinitions = containedNodeArray;
        this._tmpCodes = nArray;
    }

    public DepNode idlDefn2DepNode(Node node, boolean bl) {
        Object v = this.IdlNode2DepNodeMap.get(node);
        if (v == null) {
            return null;
        }
        if (v instanceof DepNode[]) {
            return ((DepNode[])v)[bl ? 1 : 0];
        }
        return (DepNode)v;
    }

    private String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = String.valueOf(String.valueOf(string)).concat(" ");
        }
        return string;
    }

    public boolean isForwardDeclared(InheritableNode inheritableNode) {
        Object v = this.IdlNode2DepNodeMap.get(inheritableNode);
        if (v == null) {
            this._ER.fatal("Comp.VerboseInternal", new Object[]{"no dependency node found for ".concat(String.valueOf(String.valueOf(inheritableNode._fullName)))});
        }
        return v instanceof DepNode[];
    }

    private static ContainerNode lca(ModuleNode moduleNode, ModuleNode moduleNode2) {
        if (moduleNode == null || moduleNode2 == null) {
            return null;
        }
        Vector<ModuleNode> vector = new Vector<ModuleNode>(10);
        Vector<ModuleNode> vector2 = new Vector<ModuleNode>(10);
        ContainerNode containerNode = moduleNode;
        while (containerNode != null) {
            vector.addElement((ModuleNode)containerNode);
            if (containerNode instanceof ModuleNode) {
                containerNode = containerNode._container;
                continue;
            }
            containerNode = null;
        }
        containerNode = moduleNode2;
        while (containerNode != null) {
            vector2.addElement((ModuleNode)containerNode);
            if (containerNode instanceof ModuleNode) {
                containerNode = containerNode._container;
                continue;
            }
            containerNode = null;
        }
        int n = vector.size() - 1;
        int n2 = n;
        for (int i = vector2.size() - 1; n >= 0 && i >= 0 && vector.elementAt(n) == vector2.elementAt(i); --i) {
            n2 = n--;
        }
        return (ContainerNode)vector.elementAt(n2);
    }

    private ModuleNode moduleOf(ContainedNode containedNode) {
        ContainerNode containerNode = containedNode._container;
        while (containerNode != null) {
            if (containerNode instanceof ModuleNode) {
                return (ModuleNode)containerNode;
            }
            if (containerNode instanceof RepositoryNode) {
                return null;
            }
            containerNode = ((ContainedNode)((Object)containerNode))._container;
        }
        return null;
    }

    private void openModule(ModuleNode moduleNode) {
        this.openModule(moduleNode, DepSolver.lca(this.currentModule, moduleNode));
        this.currentModule = moduleNode;
    }

    private void openModule(ModuleNode moduleNode, ContainerNode containerNode) {
        if (moduleNode._container != moduleNode._repository && moduleNode._container != containerNode) {
            this.openModule((ModuleNode)moduleNode._container, containerNode);
        }
        if (this.currentModuleIndex == this._tmpDefinitions.length) {
            this.expandTmpArrays();
        }
        this._tmpDefinitions[this.currentModuleIndex] = moduleNode;
        this._tmpCodes[this.currentModuleIndex] = this.modulesSeen.get(moduleNode) == null ? 2 : 4;
        ++this.currentModuleIndex;
        this.modulesSeen.put(moduleNode, Boolean.TRUE);
    }

    private void printGraph(int n) {
        int n2 = this.DepNodes.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            DepNode depNode = (DepNode)this.DepNodes.elementAt(i);
            System.err.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indent(n)))).append("Dependency node ").append(depNode.name()))));
            if (depNode instanceof ContainerDepNode) {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat(" (an unbreakable container):"));
            } else {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat(" (a normal node):"));
            }
            System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indent(n)))).append("IsDefn:").append(depNode.IsDefn))));
            if (depNode.DependsOnDefn.size() > 0) {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat("Definition Edges:"));
                for (n3 = 0; n3 < depNode.DependsOnDefn.size(); ++n3) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indent(n)))).append("  ").append(((DepNode)depNode.DependsOnDefn.elementAt(n3)).name()))));
                }
            } else {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat("Definition Edges: <none>"));
            }
            if (depNode.DependsOnDecl.size() > 0) {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat("Declaration Edges:"));
                for (n3 = 0; n3 < depNode.DependsOnDecl.size(); ++n3) {
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indent(n)))).append("  ").append(((DepNode)depNode.DependsOnDecl.elementAt(n3)).name()))));
                }
            } else {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat("Declaration Edges: <none>"));
            }
            if (depNode instanceof ContainerDepNode) {
                System.err.println(String.valueOf(String.valueOf(this.indent(n))).concat("SubDependency Graph:"));
                ((ContainerDepNode)depNode).Subgraph.printGraph(n + 2);
            }
            System.err.println("\n");
        }
    }

    private void printSolution(String string, int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print(String.valueOf(String.valueOf(new StringBuffer("[").append(string).append(i).append("]\t "))));
            switch (this._codes[i]) {
                case 1: {
                    System.err.print("DECLARE ");
                    break;
                }
                case 6: {
                    System.err.print("DEFINE  ");
                    break;
                }
                case 2: {
                    System.err.print("BEGIN   ");
                    break;
                }
                case 3: {
                    System.err.print("END     ");
                    break;
                }
                case 4: {
                    System.err.print("OPEN    ");
                    break;
                }
                case 5: {
                    System.err.print("CLOSE   ");
                    break;
                }
                default: {
                    System.err.print("??????? ");
                }
            }
            ContainedNode containedNode = this._definitions[i];
            if (containedNode == null) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("ERROR!  node in position ").append(i).append(" was null; cannot print it."))));
                continue;
            }
            System.err.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(containedNode.typeName()))).append(" ").append(containedNode._name))));
            if ((!containedNode.isContainer() || this._codes[i] != 6) && (containedNode._kind != 6 || this._codes[i] != 2 || this.DepSpec._modulesAreBreakable)) continue;
            ContainerDepNode containerDepNode = (ContainerDepNode)this.idlDefn2DepNode(containedNode, true);
            containerDepNode.Subgraph.printSolution(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(i).append("."))), containerDepNode.Subgraph._numDefinitions);
        }
    }

    private void recordDependenciesForOperation(DepNode depNode) {
        this.recordDependencyOnContainer(depNode);
        OperationNode operationNode = (OperationNode)depNode.IDLDefn;
        Vector vector = operationNode._paramTypes;
        Vector vector2 = operationNode._paramModes;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.elementAt(i) == OperationNode.PARAM_IN) {
                this.recordTypeDependenciesFor(depNode, (Type)vector.elementAt(i), false);
                continue;
            }
            if (vector2.elementAt(i) == OperationNode.PARAM_OUT) {
                this.recordTypeDependenciesFor(depNode, (Type)vector.elementAt(i), false);
                continue;
            }
            this.recordTypeDependenciesFor(depNode, (Type)vector.elementAt(i), false);
        }
        this.recordTypeDependenciesFor(depNode, operationNode._result, false);
        Vector vector3 = operationNode._exceptions;
        for (int i = 0; i < vector3.size(); ++i) {
            depNode.addDependency(this.idlDefn2DepNode((Node)vector3.elementAt(i), true), true);
        }
    }

    private void recordDependencyOnContainer(DepNode depNode) {
        int n;
        Object object;
        if (this.Trace) {
            object = depNode.IDLDefn;
            System.err.print(String.valueOf(String.valueOf(new StringBuffer("recordDependencyOnContainer invoked for ").append(depNode.name()).append(" (container is "))));
            if (((ContainedNode)object)._container == ((Node)object)._repository) {
                System.err.println("the repository)");
            } else {
                System.err.println(String.valueOf(String.valueOf(((ContainedNode)((Object)((ContainedNode)object)._container))._beName)).concat(")."));
            }
        }
        if ((n = (object = depNode.IDLDefn._container).kind()) != 17 && n != 6) {
            depNode.addDependency(this.idlDefn2DepNode((Node)object, true), true);
        }
    }

    private void recordDependencyOnSuperInterfaces(DepNode depNode) {
        ValueNode valueNode = (ValueNode)depNode.IDLDefn;
        InterfaceNode interfaceNode = valueNode._supportedInterface;
        if (interfaceNode != null) {
            depNode.addDependency(this.idlDefn2DepNode(interfaceNode, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
        Vector vector = valueNode._abstractInterfaces;
        for (int i = 0; i < vector.size(); ++i) {
            InterfaceNode interfaceNode2 = (InterfaceNode)vector.elementAt(i);
            depNode.addDependency(this.idlDefn2DepNode(interfaceNode2, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
    }

    private void recordDependencyOnSuperValues(DepNode depNode) {
        ValueNode valueNode = (ValueNode)depNode.IDLDefn;
        ValueNode valueNode2 = valueNode._concreteBase;
        if (valueNode2 != null) {
            depNode.addDependency(this.idlDefn2DepNode(valueNode2, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
        Vector vector = valueNode._abstractBases;
        for (int i = 0; i < vector.size(); ++i) {
            ValueNode valueNode3 = (ValueNode)vector.elementAt(i);
            depNode.addDependency(this.idlDefn2DepNode(valueNode3, this.DepSpec._inheritablesDefineFully), this.DepSpec._inheritablesDefineFully);
        }
    }

    private void recordTypeDependenciesFor(DepNode depNode, Type type, boolean bl) {
        int n = ((Node)((Object)type))._kind;
        switch (n) {
            case 13: 
            case 14: 
            case 18: {
                return;
            }
            case 19: {
                return;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                ContainedNode containedNode = (ContainedNode)((Object)type);
                if (this.Trace) {
                    System.err.println("Adding dependency edge to contained node ".concat(String.valueOf(String.valueOf(containedNode._fullName))));
                }
                depNode.addDependency(this.idlDefn2DepNode(containedNode, bl), bl);
                return;
            }
            case 15: {
                SequenceNode sequenceNode = (SequenceNode)type;
                Type type2 = sequenceNode._type;
                if (type2 != depNode.IDLDefn) {
                    this.recordTypeDependenciesFor(depNode, type2, bl);
                }
                return;
            }
            case 16: {
                ArrayNode arrayNode = (ArrayNode)type;
                Type type3 = arrayNode._type;
                this.recordTypeDependenciesFor(depNode, type3, bl);
                return;
            }
        }
        this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(String.valueOf(new StringBuffer("unknown or invalid IDL type ").append(((Node)((Object)type)).typeName()).append(" (").append(n).append(")")))});
    }

    private void recordVisit(DepNode depNode) {
        if (this.Trace) {
            System.err.println("Recording the visit to node ".concat(String.valueOf(String.valueOf(depNode.name()))));
        }
        if (this.DepSpec._modulesAreBreakable && depNode.IDLDefn._kind == 6 || (depNode.IDLDefn._kind == 7 || depNode.IDLDefn._kind == 2) && !this.DepSpec._showMethods) {
            return;
        }
        this._definitions[this._numDefinitions] = depNode.IDLDefn;
        this._codes[this._numDefinitions] = depNode.IsDefn ? 6 : 1;
        ++this._numDefinitions;
    }

    public boolean solveIt() {
        if (this.Trace) {
            System.err.println(String.valueOf(String.valueOf(this.Toplevel ? "[toplevel]" : "")).concat("solveIt invoked."));
        }
        if (this.Toplevel) {
            this.createDependencyEdges();
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("\n----------Dependency Graph:---------------");
            this.printGraph(0);
            System.err.println("------------------------------------------\n");
        }
        int n = this.DepNodes.size();
        for (int i = 0; i < n; ++i) {
            DepNode depNode = (DepNode)this.DepNodes.elementAt(i);
            if (depNode.Visited || this.visit(depNode)) continue;
            this._ER.fatal("Comp.VerboseInternal", new Object[]{"circularity detected in dependency graph involving ".concat(String.valueOf(String.valueOf(depNode.IDLDefn._fullName)))});
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("SOLUTION BEFORE CLEANUP:");
            this.printSolution("", this._numDefinitions);
            System.err.println("\n");
        }
        if (this.Toplevel) {
            if (this.DepSpec._modulesAreBreakable) {
                this.cleanupSolutionTrace();
            } else {
                this.cleanupSolutionTraceForUnbreakableModules();
            }
        }
        if (this.Trace && this.Toplevel) {
            System.err.println("SOLUTION AFTER CLEANUP:");
            this.printSolution("", this._definitions.length);
            System.err.println("\n");
        }
        return true;
    }

    private boolean visit(DepNode depNode) {
        DepNode depNode2;
        int n;
        if (depNode.Visited) {
            this._ER.fatal("Comp.VerboseInternal", new Object[]{String.valueOf(String.valueOf(new StringBuffer("node ").append(depNode.IDLDefn._name).append(" visited twice")))});
        }
        depNode.Visited = true;
        depNode.OnStack = true;
        if (this.Trace) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("Visiting ").append(depNode.IsDefn ? "definition" : "declaration").append(" of ").append(depNode.IDLDefn._name))));
        }
        int n2 = depNode.DependsOnDefn.size();
        for (n = 0; n < n2; ++n) {
            depNode2 = (DepNode)depNode.DependsOnDefn.elementAt(n);
            if (this.Trace) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Checking definition edge from ").append(depNode.IDLDefn._name).append(" to ").append(depNode2.IDLDefn._name))));
            }
            if (depNode2.OnStack) {
                if (this.Trace) {
                    System.err.println("...circularity detected; failing");
                }
                depNode.OnStack = false;
                depNode.Visited = false;
                return false;
            }
            if (!depNode2.Visited && !this.visit(depNode2)) {
                if (this.Trace) {
                    System.err.println("...circularity detected; failing");
                }
                depNode.OnStack = false;
                depNode.Visited = false;
                return false;
            }
            if (!this.Trace) continue;
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("(resume checks for ").append(depNode.IDLDefn._name).append(")"))));
        }
        n2 = depNode.DependsOnDecl.size();
        for (n = 0; n < n2; ++n) {
            depNode2 = (DepNode)depNode.DependsOnDecl.elementAt(n);
            if (this.Trace) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Checking declaration edge from ").append(depNode.IDLDefn._name).append(" to ").append(depNode2.IDLDefn._name))));
            }
            if (depNode2.OnStack) {
                if (this.canForwardDeclare(depNode, n)) {
                    depNode2 = (DepNode)depNode.DependsOnDecl.elementAt(n);
                } else {
                    if (this.Trace) {
                        System.err.println("...circularity detected; failing");
                    }
                    depNode.OnStack = false;
                    depNode.Visited = false;
                    return false;
                }
            }
            if (!depNode2.Visited && !this.visit(depNode2)) {
                if (this.canForwardDeclare(depNode, n)) {
                    depNode2 = (DepNode)depNode.DependsOnDecl.elementAt(n);
                    if (this.Trace) {
                        System.err.println(String.valueOf(String.valueOf(new StringBuffer("Re-trying visit of ").append(depNode2.name()).append(" after (presumably) creating-or-switching-to its declaration"))));
                    }
                    if (!depNode2.Visited && !this.visit(depNode2)) {
                        if (this.Trace) {
                            System.err.println("...circularity detected (the forward declaration didn't help!); failing");
                        }
                        depNode.OnStack = false;
                        depNode.Visited = false;
                        return false;
                    }
                } else {
                    if (this.Trace) {
                        System.err.println("...circularity detected; failing");
                    }
                    depNode.OnStack = false;
                    depNode.Visited = false;
                    return false;
                }
            }
            if (!this.Trace) continue;
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("(resume checks for ").append(depNode.IDLDefn._name).append(")"))));
        }
        this.recordVisit(depNode);
        depNode.OnStack = false;
        if (depNode instanceof ContainerDepNode) {
            if (this.Trace) {
                System.err.println("This node is also a container; recursively solving that now.");
            }
            ((ContainerDepNode)depNode).Subgraph.solveIt();
        }
        if (this.Trace) {
            System.err.println("Leaving node ".concat(String.valueOf(String.valueOf(depNode.IDLDefn._name))));
        }
        return true;
    }

    public class ContainerDepNode
    extends DepNode {
        public DepSolver Subgraph;

        ContainerDepNode(DepSolver depSolver, ContainerNode containerNode) {
            super((ContainedNode)((Object)containerNode), true);
            this.Subgraph = new DepSolver(depSolver.DepSpec, containerNode, depSolver.IdlNode2DepNodeMap, depSolver.NodesInCycle, false);
        }
    }

    public class DepNode {
        public final ContainedNode IDLDefn;
        final boolean IsDefn;
        boolean Visited = false;
        boolean OnStack = false;
        public Vector DependsOnDefn = new Vector();
        public Vector DependsOnDecl = new Vector();
        public Vector GlobalDeps;

        public DepNode(ContainedNode containedNode, boolean bl) {
            this.IDLDefn = containedNode;
            this.IsDefn = bl;
        }

        String name() {
            return this.IDLDefn._name;
        }

        void addDependency(DepNode depNode, boolean bl) {
            DepNode depNode2;
            Object object;
            if (DepSolver.this.Trace) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Requesting dependency edge from IDLDefn ").append(this.IDLDefn._name).append(" to ").append(depNode.name()).append("."))));
            }
            ContainerNode containerNode = this.IDLDefn._container;
            ContainerNode containerNode2 = depNode.IDLDefn._container;
            RepositoryNode repositoryNode = this.IDLDefn._repository;
            if (containerNode != repositoryNode && containerNode2 == repositoryNode) {
                if (this.GlobalDeps == null) {
                    this.GlobalDeps = new Vector(5);
                }
                this.GlobalDeps.addElement(depNode.IDLDefn);
                if (DepSolver.this.Trace) {
                    System.err.println("(registering this edge as a `global target' dependency)");
                }
            }
            if (containerNode == containerNode2 || containerNode == depNode.IDLDefn) {
                if (bl) {
                    this.DependsOnDefn.addElement(depNode);
                } else {
                    this.DependsOnDecl.addElement(depNode);
                }
                return;
            }
            if (DepSolver.this.Trace) {
                System.err.println("Target was not my own container, nor did it share my container.");
                System.err.println("Begin searching for the LCA, in order to compute the proxy node(s) for this edge.");
            }
            DepSolver.this._v.setSize(0);
            ContainerNode containerNode3 = containerNode;
            while (containerNode3 != repositoryNode) {
                DepSolver.this._v.addElement(containerNode3);
                containerNode3 = ((ContainedNode)((Object)containerNode3))._container;
            }
            int n = DepSolver.this._v.size();
            Object object2 = repositoryNode;
            containerNode3 = containerNode2;
            block1: while (containerNode3 != repositoryNode) {
                for (int i = 0; i < n; ++i) {
                    object = (ContainerNode)DepSolver.this._v.elementAt(i);
                    if (object != containerNode3) continue;
                    object2 = object;
                    break block1;
                }
                containerNode3 = ((ContainedNode)((Object)containerNode3))._container;
            }
            ContainedNode containedNode = this.IDLDefn;
            containerNode3 = containerNode;
            while (containerNode3 != repositoryNode && containerNode3 != object2 && !DepSolver.this.breakable(containerNode3)) {
                containedNode = (ContainedNode)((Object)containerNode3);
                containerNode3 = ((ContainedNode)((Object)containerNode3))._container;
            }
            object = depNode.IDLDefn;
            containerNode3 = containerNode2;
            while (containerNode3 != repositoryNode && containerNode3 != object2 && !DepSolver.this.breakable(containerNode3)) {
                object = (ContainedNode)((Object)containerNode3);
                containerNode3 = ((ContainedNode)((Object)containerNode3))._container;
            }
            if (DepSolver.this.Trace) {
                if (containedNode != this.IDLDefn) {
                    System.err.println("Assigning \"from\" proxy of ".concat(String.valueOf(String.valueOf(containedNode._name))));
                }
                if (object != depNode.IDLDefn) {
                    System.err.println("Assigning \"to\"   proxy of ".concat(String.valueOf(String.valueOf(((ContainedNode)object)._name))));
                }
            }
            DepNode depNode3 = containedNode == this.IDLDefn ? this : DepSolver.this.idlDefn2DepNode(containedNode, true);
            DepNode depNode4 = depNode2 = object == depNode.IDLDefn ? depNode : DepSolver.this.idlDefn2DepNode((Node)object, true);
            if (containedNode == object) {
                if (DepSolver.this.Trace) {
                    System.err.println("Dropping this dependency edge: would be circular");
                }
                return;
            }
            if (bl || object != depNode.IDLDefn) {
                depNode3.DependsOnDefn.addElement(depNode2);
            } else {
                depNode3.DependsOnDecl.addElement(depNode2);
            }
        }
    }
}

