/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal;

import com.inprise.vbroker.compiler.util.IndentableStringBuffer;

public class PascalWriteBuffers {
    protected static final transient boolean trace = false;
    protected int nodeKind = 0;
    protected int iNumberOfBuffers = 0;
    protected int iNumberOfPasses = 0;
    protected int iBaseIndent = 0;
    protected IndentableStringBuffer[][] buffers = null;

    public PascalWriteBuffers(int n, int n2, int n3, int n4) {
        this.nodeKind = n;
        this.iNumberOfBuffers = n3;
        this.iNumberOfPasses = n2;
        this.iBaseIndent = n4;
        this.buffers = new IndentableStringBuffer[this.iNumberOfPasses][this.iNumberOfBuffers];
    }

    void discard(int n) {
        for (int i = 0; i < this.iNumberOfBuffers; ++i) {
            this.buffers[n][i] = null;
        }
    }

    public IndentableStringBuffer getBuffer(int n, int n2) {
        IndentableStringBuffer indentableStringBuffer = null;
        if (n2 >= 0 && n2 < this.iNumberOfBuffers) {
            if (this.buffers[n][n2] == null) {
                this.buffers[n][n2] = new IndentableStringBuffer();
            }
            indentableStringBuffer = this.buffers[n][n2];
        } else {
            indentableStringBuffer = null;
        }
        return indentableStringBuffer;
    }

    void reset() {
        for (int i = 0; i < this.iNumberOfPasses; ++i) {
            this.reset(i, this.iBaseIndent);
        }
    }

    void reset(int n) {
        this.reset(n, this.iBaseIndent);
    }

    void reset(int n, int n2) {
        for (int i = 0; i < this.iNumberOfBuffers; ++i) {
            if (this.buffers[n][i] == null) continue;
            this.buffers[n][i].reset();
            this.buffers[n][i].indent(n2);
        }
    }

    static {
        trace = false;
    }
}

