/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.StringFunctions;

public final class IntValue {
    public long _val;
    public boolean _unsigned = false;

    private IntValue(long l) {
        this._val = l;
    }

    public IntValue(long l, boolean bl) {
        this._val = l;
        this._unsigned = bl;
    }

    public IntValue(String string, ErrorReporter errorReporter) {
        char c = string.charAt(0);
        if (c >= '1' && c <= '9') {
            try {
                this._val = Long.parseLong(this.handleTrailingU(this.stripTrailingL(string)));
            }
            catch (NumberFormatException numberFormatException) {
                errorReporter.error("Comp.Util.NumericTranslation", string);
            }
        } else if (c == '0') {
            if (string.length() > 1) {
                char c2 = string.charAt(1);
                if (c2 == 'x' || c2 == 'X') {
                    String string2 = this.handleTrailingU(this.stripTrailingL(string.substring(2)));
                    this._val = StringFunctions.translateHexLiteral(string2, false);
                } else {
                    this._val = StringFunctions.translateOctalLiteral(this.handleTrailingU(this.stripTrailingL(string)), false);
                }
            } else {
                this._val = 0L;
            }
        } else if (c == 'L') {
            this._val = StringFunctions.translateWideCharacterLiteral(string.substring(1), true);
        } else {
            if (c != '\'') {
                System.err.println("IDL preprocessor: fatal error: unable to convert lexeme to value in constant parser");
            }
            this._val = StringFunctions.translateCharacterLiteral(string, false);
        }
    }

    public void add(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        long l = this._val;
        this._val += intValue._val;
        if (!this._unsigned && (l > (long)0 && intValue._val > (long)0 && this._val <= (long)0 || l < (long)0 && intValue._val < (long)0 && this._val >= (long)0)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void and(IntValue intValue) {
        this._unsigned = false;
        this._val = this._val != (long)0 && intValue._val != (long)0 ? 1 : 0;
    }

    public void bitNot() {
        this._val ^= 0L - 1L;
    }

    public void bitand(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        this._val &= intValue._val;
    }

    public void bitor(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        this._val |= intValue._val;
    }

    public void bitxor(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        this._val ^= intValue._val;
    }

    public void condition(IntValue intValue, IntValue intValue2) {
        this._unsigned = intValue._unsigned || intValue2._unsigned;
        this._val = this._val != (long)0 ? intValue._val : intValue2._val;
    }

    public void div(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        long l = this._val;
        if (intValue._val == 0L) {
            throw new ArithmeticException("Comp.Arith.divisionByZero");
        }
        this._val /= intValue._val;
    }

    public void eq(IntValue intValue) {
        this._unsigned = false;
        this._val = this._val == intValue._val ? 1 : 0;
    }

    public void ge(IntValue intValue) {
        if (!this._unsigned && !intValue._unsigned) {
            this._val = this._val >= intValue._val ? 1 : 0;
        } else if (this._val >= (long)0 && intValue._val >= (long)0) {
            this._val = this._val >= intValue._val ? 1 : 0;
        } else if (this._val < (long)0 && intValue._val < (long)0) {
            this._val = this._val >= intValue._val ? 0 : 1;
        } else if (this._val >= (long)0 && intValue._val < (long)0) {
            this._val = 0L;
        } else if (this._val < (long)0 && intValue._val >= (long)0) {
            this._val = 1L;
        }
        this._unsigned = false;
    }

    public void gt(IntValue intValue) {
        if (!this._unsigned && !intValue._unsigned) {
            this._val = this._val > intValue._val ? 1 : 0;
        } else if (this._val >= (long)0 && intValue._val >= (long)0) {
            this._val = this._val > intValue._val ? 1 : 0;
        } else if (this._val < (long)0 && intValue._val < (long)0) {
            this._val = this._val > intValue._val ? 0 : 1;
        } else if (this._val >= (long)0 && intValue._val < (long)0) {
            this._val = 0L;
        } else if (this._val < (long)0 && intValue._val >= (long)0) {
            this._val = 1L;
        }
        this._unsigned = false;
    }

    private String handleTrailingU(String string) {
        int n = string.length();
        if (n > 1 && string.charAt(n - 1) == 'u' || string.charAt(n - 1) == 'U') {
            this._unsigned = true;
            return string.substring(0, n - 1);
        }
        return string;
    }

    public void le(IntValue intValue) {
        if (!this._unsigned && !intValue._unsigned) {
            this._val = this._val <= intValue._val ? 1 : 0;
        } else if (this._val >= (long)0 && intValue._val >= (long)0) {
            this._val = this._val <= intValue._val ? 1 : 0;
        } else if (this._val < (long)0 && intValue._val < (long)0) {
            this._val = this._val <= intValue._val ? 0 : 1;
        } else if (this._val >= (long)0 && intValue._val < (long)0) {
            this._val = 1L;
        } else if (this._val < (long)0 && intValue._val >= (long)0) {
            this._val = 0L;
        }
        this._unsigned = false;
    }

    public void logicalNot() {
        this._unsigned = false;
        this._val = this._val == (long)0 ? 1 : 0;
    }

    public void lshift(IntValue intValue) {
        boolean bl = this._unsigned = this._unsigned || intValue._unsigned;
        if (!intValue._unsigned && intValue._val < 0L) {
            this.rshift(new IntValue(-intValue._val));
        } else {
            this._val = intValue._val >= 64L || intValue._unsigned && intValue._val < (long)0 ? 0L : (this._val <<= (int)intValue._val);
        }
    }

    public void lt(IntValue intValue) {
        if (!this._unsigned && !intValue._unsigned) {
            this._val = this._val < intValue._val ? 1 : 0;
        } else if (this._val >= (long)0 && intValue._val >= (long)0) {
            this._val = this._val < intValue._val ? 1 : 0;
        } else if (this._val < (long)0 && intValue._val < (long)0) {
            this._val = this._val < intValue._val ? 0 : 1;
        } else if (this._val >= (long)0 && intValue._val < (long)0) {
            this._val = 1L;
        } else if (this._val < (long)0 && intValue._val >= (long)0) {
            this._val = 0L;
        }
        this._unsigned = false;
    }

    public void mod(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        long l = this._val;
        if (intValue._val == 0L) {
            throw new ArithmeticException("Comp.Arith.divisionByZero");
        }
        this._val %= intValue._val;
    }

    public void mul(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        long l = this._val;
        this._val *= intValue._val;
        if (!this._unsigned && (l != (long)0 && this._val / l != intValue._val || (this._val & l & intValue._val) < 0L)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void ne(IntValue intValue) {
        this._unsigned = false;
        this._val = this._val != intValue._val ? 1 : 0;
    }

    public void or(IntValue intValue) {
        this._unsigned = false;
        this._val = this._val != (long)0 || intValue._val != (long)0 ? 1 : 0;
    }

    public void rshift(IntValue intValue) {
        boolean bl = this._unsigned = this._unsigned || intValue._unsigned;
        if (!intValue._unsigned && intValue._val < 0L) {
            this.lshift(new IntValue(-intValue._val));
        } else {
            this._val = this._unsigned ? (intValue._val >= 64L || intValue._unsigned && intValue._val < (long)0 ? 0L : (this._val >>>= (int)intValue._val)) : (intValue._val >= 64L || intValue._unsigned && intValue._val < (long)0 ? (this._val >>= 63) : (this._val >>= (int)intValue._val));
        }
    }

    public void rshift_pad_zero(IntValue intValue) {
        boolean bl = this._unsigned = this._unsigned || intValue._unsigned;
        if (!intValue._unsigned && intValue._val < 0L) {
            this.lshift(new IntValue(-intValue._val));
        } else {
            this._val = intValue._val >= 64L || intValue._unsigned && intValue._val < (long)0 ? 0L : (this._val >>>= (int)intValue._val);
        }
    }

    private String stripTrailingL(String string) {
        int n = string.length();
        if (n > 1 && string.charAt(n - 1) == 'l' || string.charAt(n - 1) == 'L') {
            return string.substring(0, n - 1);
        }
        return string;
    }

    public void sub(IntValue intValue) {
        this._unsigned = this._unsigned || intValue._unsigned;
        long l = this._val;
        this._val -= intValue._val;
        if (!this._unsigned && (l > (long)0 && intValue._val > (long)0 && this._val <= (long)0 || l < (long)0 && intValue._val < (long)0 && this._val >= (long)0)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void unaryMinus() {
        this._val = -this._val;
    }
}

