/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.DriverUsage;
import com.inprise.vbroker.util.Version;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Options {
    public static final String _lineSep = System.getProperty("line.separator");
    public ErrorReporter _ER;

    public Options(ErrorReporter errorReporter) {
        this._ER = errorReporter;
    }

    public void checkForUnusedFlags(String[] stringArray, boolean[] blArray) {
        if (blArray[1]) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || !string.startsWith("-") || string.equals("-")) continue;
            if (string.startsWith("-no_")) {
                string = "-".concat(String.valueOf(String.valueOf(string.substring(4))));
            }
            if (string.equals("-version") || string.equals("-XXX_debug") || string.equals("-no_XXX_debug") || string.equals("-strict") || string.equals("-no_strict") || string.equals("-warn_all") || string.equals("-no_warn_all") || string.equals("-back_compat_mapping")) {
                if (string.equals("-version")) {
                    this._ER.printUntranslated(Version.java());
                    this._ER.printUntranslated(Version.platform());
                    blArray[1] = true;
                }
                stringArray[i] = null;
                continue;
            }
            blArray[0] = true;
            this._ER.warn("Comp.Tools.unusedFlag", stringArray[i]);
            stringArray[i] = null;
        }
    }

    protected String[] cleanupArg(String[] stringArray, int n) {
        Object object;
        Object object2;
        String[] stringArray2 = this.deprecatedGluedList();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray[n].startsWith(stringArray2[i]) || stringArray[n].length() <= stringArray2[i].length() || stringArray[n].equals("-export_skel")) continue;
                this._ER.warn("Comp.Tools.deprecatedGluedStyle", stringArray[n]);
                object2 = stringArray2[i];
                object = stringArray[n].substring(stringArray2[i].length());
                String[] stringArray3 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, n);
                stringArray3[n] = object2;
                stringArray3[n + 1] = object;
                System.arraycopy(stringArray, n + 1, stringArray3, n + 2, stringArray.length - n - 1);
                stringArray = stringArray3;
                break;
            }
        }
        Object object3 = stringArray[n];
        object2 = this.deprecatedMap();
        if (object2 != null && (object = (String)((Dictionary)object2).get(object3)) != null) {
            if (((String)object).startsWith("-XXX")) {
                this._ER.warn("Comp.Tools.deprecatedFlagWithHiddenReplacement", new Object[]{object3});
            } else {
                this._ER.warn("Comp.Tools.deprecatedFlag", new Object[]{object3, object});
            }
            stringArray[n] = object3 = object;
        }
        if ((object = this.eliminatedMap()) != null && ((Dictionary)object).get(object3) != null) {
            this._ER.warn("Comp.Tools.eliminatedFlag", (String)object3);
            stringArray[n] = null;
        }
        return stringArray;
    }

    protected String[] deprecatedGluedList() {
        return null;
    }

    protected Hashtable deprecatedMap() {
        return null;
    }

    protected Hashtable eliminatedMap() {
        return null;
    }

    protected String getArg(String[] stringArray, int n) {
        if (stringArray.length <= n + 1) {
            this._ER.error("Comp.Tools.missingArgument", stringArray[n]);
            throw new IllegalArgumentException("expected command-line argument at location ".concat(String.valueOf(String.valueOf(n))));
        }
        String string = stringArray[n + 1];
        if (string == null || string.startsWith("-")) {
            this._ER.error("Comp.Tools.missingArgument", stringArray[n]);
            throw new IllegalArgumentException("expected command-line argument at location ".concat(String.valueOf(String.valueOf(n))));
        }
        stringArray[n + 1] = null;
        stringArray[n] = null;
        if (string.startsWith("\\-")) {
            return string.substring(1);
        }
        return string;
    }

    public abstract String[] getUsage();

    protected final String[] getUsage(Options[] optionsArray, String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = this.getUsage();
        for (n = 0; n < stringArray2.length; ++n) {
            String string = stringArray2[n];
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        if (optionsArray != null) {
            for (n = 0; n < optionsArray.length; ++n) {
                stringArray2 = optionsArray[n].getUsage();
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string = stringArray2[i];
                    if (vector.contains(string)) continue;
                    vector.addElement(string);
                }
            }
        }
        vector.addElement("Comp.Tools.CLflag.help");
        vector.addElement("Comp.Tools.CLflag.version");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] parse(String[] stringArray, boolean[] blArray) {
        if (blArray[1]) {
            return stringArray;
        }
        block9: for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String string = stringArray[i];
            if (string == null || !string.startsWith("-")) continue;
            if ((stringArray = this.cleanupArg(stringArray, i)) == null) {
                blArray[1] = true;
                blArray[0] = true;
                return stringArray;
            }
            string = stringArray[i];
            if (string == null) continue;
            if ((string = string.substring(1)).startsWith("no_")) {
                bl = true;
                string = string.substring(3);
            }
            if (string.equals("")) continue;
            try {
                switch (string.charAt(0)) {
                    case 'X': {
                        if (string.equals("XXX_debug")) {
                            this._ER._verbose = true;
                            break;
                        }
                        if (!string.equals("XXX_authors")) continue block9;
                        this._ER.untranslatedMessage("VisiBroker 4.0 Compiler Suite authors:");
                        this._ER.untranslatedMessage("  Vijay Natarajan");
                        this._ER.untranslatedMessage("  Tim A. Wagner");
                        stringArray[i] = null;
                        break;
                    }
                    case '?': {
                        if (!string.equals("?")) continue block9;
                        blArray[0] = true;
                        blArray[1] = true;
                        String[] stringArray2 = stringArray;
                        return stringArray2;
                    }
                    case 'h': {
                        if (!string.equals("h") && !string.equals("help")) continue block9;
                        blArray[0] = true;
                        blArray[1] = true;
                        String[] stringArray3 = stringArray;
                        return stringArray3;
                    }
                    case 'u': {
                        if (!string.equals("usage")) continue block9;
                        blArray[0] = true;
                        blArray[1] = true;
                        String[] stringArray4 = stringArray;
                        return stringArray4;
                    }
                    case 'v': {
                        if (!string.equals("version")) continue block9;
                        this.version();
                        blArray[0] = false;
                        blArray[1] = false;
                        String[] stringArray5 = stringArray;
                        return stringArray5;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                blArray[1] = true;
                blArray[0] = true;
                String[] stringArray6 = stringArray;
                return stringArray6;
            }
        }
        return stringArray;
    }

    public final void printUsage(Options[] optionsArray, String[] stringArray) {
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(_lineSep))).append("  ").append(this._ER.getMesg("Comp.Tools.driverOptions"))));
        String[] stringArray2 = this.getUsage(optionsArray, stringArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(_lineSep))).append("  ").append(this._ER.getMesg(stringArray2[i])))))));
        }
        this._ER.add("Comp.Tools.usage", new Object[]{string});
        DriverUsage.printUsage(this._ER.getToolName());
    }

    protected abstract void version();
}

