/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.ByteMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ByteMap
implements Cloneable,
Serializable {
    private transient ByteMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public ByteMap() {
        this(101, 0.75f);
    }

    public ByteMap(int n) {
        this(n, 0.75f);
    }

    public ByteMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new ByteMapEntry[n];
        this.threshold = (int)((float)n * f);
    }

    private boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized void clear() {
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n = byteMapEntryArray.length;
        while (--n >= 0) {
            byteMapEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            ByteMap byteMap = (ByteMap)super.clone();
            byteMap.table = new ByteMapEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                byteMap.table[n] = this.table[n] != null ? (ByteMapEntry)this.table[n].clone() : null;
            }
            ByteMap byteMap2 = byteMap;
            return byteMap2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean containsKey(byte[] byArray) {
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n = this.getHash(byArray);
        int n2 = (n & Integer.MAX_VALUE) % byteMapEntryArray.length;
        ByteMapEntry byteMapEntry = byteMapEntryArray[n2];
        while (byteMapEntry != null) {
            if (byteMapEntry.hash == n && this.areEqual(byteMapEntry.key, byArray)) {
                return true;
            }
            byteMapEntry = byteMapEntry.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return new ByteMapEnumerator(this, this.table, false);
    }

    public synchronized Object get(byte[] byArray) {
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n = this.getHash(byArray);
        int n2 = (n & Integer.MAX_VALUE) % byteMapEntryArray.length;
        ByteMapEntry byteMapEntry = byteMapEntryArray[n2];
        while (byteMapEntry != null) {
            if (byteMapEntry.hash == n && this.areEqual(byteMapEntry.key, byArray)) {
                return byteMapEntry.value;
            }
            byteMapEntry = byteMapEntry.next;
        }
        return null;
    }

    private int getHash(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n ^= byArray[i];
        }
        return n;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new ByteMapEnumerator(this, this.table, true);
    }

    public synchronized Object put(byte[] byArray, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n = this.getHash(byArray);
        int n2 = (n & Integer.MAX_VALUE) % byteMapEntryArray.length;
        ByteMapEntry byteMapEntry = byteMapEntryArray[n2];
        while (byteMapEntry != null) {
            if (byteMapEntry.hash == n && this.areEqual(byteMapEntry.key, byArray)) {
                Object object2 = byteMapEntry.value;
                byteMapEntry.value = object;
                return object2;
            }
            byteMapEntry = byteMapEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(byArray, object);
        }
        byteMapEntry = new ByteMapEntry();
        byteMapEntry.hash = n;
        byteMapEntry.key = byArray;
        byteMapEntry.value = object;
        byteMapEntry.next = byteMapEntryArray[n2];
        byteMapEntryArray[n2] = byteMapEntry;
        ++this.count;
        return null;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new ByteMapEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            byte[] byArray = (byte[])objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.put(byArray, object);
            --n2;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n2 = n * 2 + 1;
        ByteMapEntry[] byteMapEntryArray2 = new ByteMapEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = byteMapEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            ByteMapEntry byteMapEntry = byteMapEntryArray[n3];
            while (byteMapEntry != null) {
                ByteMapEntry byteMapEntry2 = byteMapEntry;
                byteMapEntry = byteMapEntry.next;
                int n4 = (byteMapEntry2.hash & Integer.MAX_VALUE) % n2;
                byteMapEntry2.next = byteMapEntryArray2[n4];
                byteMapEntryArray2[n4] = byteMapEntry2;
            }
        }
    }

    public synchronized Object remove(byte[] byArray) {
        ByteMapEntry[] byteMapEntryArray = this.table;
        int n = this.getHash(byArray);
        int n2 = (n & Integer.MAX_VALUE) % byteMapEntryArray.length;
        ByteMapEntry byteMapEntry = byteMapEntryArray[n2];
        ByteMapEntry byteMapEntry2 = null;
        while (byteMapEntry != null) {
            if (byteMapEntry.hash == n && this.areEqual(byteMapEntry.key, byArray)) {
                if (byteMapEntry2 != null) {
                    byteMapEntry2.next = byteMapEntry.next;
                } else {
                    byteMapEntryArray[n2] = byteMapEntry.next;
                }
                --this.count;
                return byteMapEntry.value;
            }
            byteMapEntry2 = byteMapEntry;
            byteMapEntry = byteMapEntry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("=").append(string2))));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            ByteMapEntry byteMapEntry = this.table[i];
            while (byteMapEntry != null) {
                objectOutputStream.writeObject(byteMapEntry.key);
                objectOutputStream.writeObject(byteMapEntry.value);
                byteMapEntry = byteMapEntry.next;
            }
        }
    }

    static {
        serialVersionUID = 1421746759512286392L;
    }

    class ByteMapEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        ByteMapEntry[] table;
        ByteMapEntry entry;

        ByteMapEnumerator(ByteMap byteMap, ByteMapEntry[] byteMapEntryArray, boolean bl) {
            this.table = byteMapEntryArray;
            this.keys = bl;
            this.index = byteMapEntryArray.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                ByteMapEntry byteMapEntry = this.entry;
                this.entry = byteMapEntry.next;
                return this.keys ? byteMapEntry.key : (byte[])byteMapEntry.value;
            }
            throw new NoSuchElementException("ByteMapEnumerator");
        }
    }
}

