/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntMap
implements Cloneable,
Serializable {
    private transient IntMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public IntMap() {
        this(101, 0.75f);
    }

    public IntMap(int n) {
        this(n, 0.75f);
    }

    public IntMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IntMapEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public synchronized void clear() {
        IntMapEntry[] intMapEntryArray = this.table;
        int n = intMapEntryArray.length;
        while (--n >= 0) {
            intMapEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntMap intMap = (IntMap)super.clone();
            intMap.table = new IntMapEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                intMap.table[n] = this.table[n] != null ? (IntMapEntry)this.table[n].clone() : null;
            }
            IntMap intMap2 = intMap;
            return intMap2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean containsKey(int n) {
        IntMapEntry[] intMapEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intMapEntryArray.length;
        IntMapEntry intMapEntry = intMapEntryArray[n3];
        while (intMapEntry != null) {
            if (intMapEntry.hash == n2 && intMapEntry.key == n) {
                return true;
            }
            intMapEntry = intMapEntry.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return new IntMapEnumerator(this, this.table);
    }

    public synchronized Object get(int n) {
        IntMapEntry[] intMapEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intMapEntryArray.length;
        IntMapEntry intMapEntry = intMapEntryArray[n3];
        while (intMapEntry != null) {
            if (intMapEntry.hash == n2 && intMapEntry.key == n) {
                return intMapEntry.value;
            }
            intMapEntry = intMapEntry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntMapEntry[] intMapEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intMapEntryArray.length;
        IntMapEntry intMapEntry = intMapEntryArray[n3];
        while (intMapEntry != null) {
            if (intMapEntry.hash == n2 && intMapEntry.key == n) {
                Object object2 = intMapEntry.value;
                intMapEntry.value = object;
                return object2;
            }
            intMapEntry = intMapEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        intMapEntry = new IntMapEntry();
        intMapEntry.hash = n2;
        intMapEntry.key = n;
        intMapEntry.value = object;
        intMapEntry.next = intMapEntryArray[n3];
        intMapEntryArray[n3] = intMapEntry;
        ++this.count;
        return null;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new IntMapEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            int n4 = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            this.put(n4, object);
            --n2;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        IntMapEntry[] intMapEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntMapEntry[] intMapEntryArray2 = new IntMapEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = intMapEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntMapEntry intMapEntry = intMapEntryArray[n3];
            while (intMapEntry != null) {
                IntMapEntry intMapEntry2 = intMapEntry;
                intMapEntry = intMapEntry.next;
                int n4 = (intMapEntry2.hash & Integer.MAX_VALUE) % n2;
                intMapEntry2.next = intMapEntryArray2[n4];
                intMapEntryArray2[n4] = intMapEntry2;
            }
        }
    }

    public synchronized Object remove(int n) {
        IntMapEntry[] intMapEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intMapEntryArray.length;
        IntMapEntry intMapEntry = intMapEntryArray[n3];
        IntMapEntry intMapEntry2 = null;
        while (intMapEntry != null) {
            if (intMapEntry.hash == n2 && intMapEntry.key == n) {
                if (intMapEntry2 != null) {
                    intMapEntry2.next = intMapEntry.next;
                } else {
                    intMapEntryArray[n3] = intMapEntry.next;
                }
                --this.count;
                return intMapEntry.value;
            }
            intMapEntry2 = intMapEntry;
            intMapEntry = intMapEntry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            IntMapEntry intMapEntry = this.table[i];
            while (intMapEntry != null) {
                objectOutputStream.writeInt(intMapEntry.key);
                objectOutputStream.writeObject(intMapEntry.value);
                intMapEntry = intMapEntry.next;
            }
        }
    }

    static {
        serialVersionUID = 1421746759512286392L;
    }

    class IntMapEnumerator
    implements Enumeration {
        int index;
        IntMapEntry[] table;
        IntMapEntry entry;

        IntMapEnumerator(IntMap intMap, IntMapEntry[] intMapEntryArray) {
            this.table = intMapEntryArray;
            this.index = intMapEntryArray.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntMapEntry intMapEntry = this.entry;
                this.entry = intMapEntry.next;
                return intMapEntry.value;
            }
            throw new NoSuchElementException("IntMapEnumerator");
        }
    }

    class IntMapEntry {
        int hash;
        int key;
        Object value;
        IntMapEntry next;

        IntMapEntry() {
        }

        protected Object clone() {
            IntMapEntry intMapEntry = new IntMapEntry();
            intMapEntry.hash = this.hash;
            intMapEntry.key = this.key;
            intMapEntry.value = this.value;
            intMapEntry.next = this.next != null ? (IntMapEntry)this.next.clone() : null;
            return intMapEntry;
        }
    }
}

