!define MDE    `My Digital Editions`
!define DIR    `${DATA}\${MDE}`
!define DEFDIR `${DEFDATA}\${MDE}`
 
!define J      `${LAUNCHDIR}\Junction\junction.exe`
!define SYS    HKCU\Software\Sysinternals
!define JUNC   ${SYS}\Junction
 
!define CP     `Control Panel\International`
!define INT    `HKCU\${CP}`
 
Function GetLCID
	!macro _GetLCID _LNG _LCID
		Push ${_LNG}
		Call GetLCID
		Pop ${_LCID}
	!macroend
	!define GetLCID "!insertmacro _GetLCID"
	Exch $0
	StrCmp $0 Dutch 0 +3
	StrCpy $0 1043
		Goto EndLCID
	StrCmp $0 English 0 +3
	StrCpy $0 1033
		Goto EndLCID
	StrCmp $0 French 0 +3
	StrCpy $0 1036
		Goto EndLCID
	StrCmp $0 German 0 +3
	StrCpy $0 1031
		Goto EndLCID
	StrCmp $0 Italian 0 +3
	StrCpy $0 1040
		Goto EndLCID
	StrCmp $0 Japanese 0 +3
	StrCpy $0 1041
		Goto EndLCID
	StrCmp $0 Korean 0 +3
	StrCpy $0 1042
		Goto EndLCID
	StrCmp $0 Portuguese 0 +3
	StrCpy $0 2070
		Goto EndLCID
	StrCmp $0 SimpChinese 0 +3
	StrCpy $0 2052
		Goto EndLCID
	StrCmp $0 Spanish 0 +3
	StrCpy $0 1034
		Goto EndLCID
	StrCmp $0 TradChinese 0 +3
	StrCpy $0 1028
		Goto +2
	StrCpy $0 1033
	EndLCID:
	Exch $0
FunctionEnd
Function GetLNG
	!macro _GetLNG _LCID _LNG _LANG
		Push ${_LCID}
		Call GetLNG
		Pop ${_LNG}
		Pop ${_LANG}
	!macroend
	!define GetLNG "!insertmacro _GetLNG"
	Exch $0
	Push $1
	StrCmp $0 1043 0 +4
	StrCpy $0 00000413
	StrCpy $1 nl-NL
		Goto EndLNG
	StrCmp $0 1033 0 +4
	StrCpy $0 00000409
	StrCpy $1 en-US
		Goto EndLNG
	StrCmp $0 1036 0 +4
	StrCpy $0 0000040c
	StrCpy $1 fr-FR
		Goto EndLNG
	StrCmp $0 1031 0 +4
	StrCpy $0 00000407
	StrCpy $1 de-DE
		Goto EndLNG
	StrCmp $0 1040 0 +4
	StrCpy $0 00000410
	StrCpy $1 it-IT
		Goto EndLNG
	StrCmp $0 1041 0 +4
	StrCpy $0 00000411
	StrCpy $1 ja-JP
		Goto EndLNG
	StrCmp $0 1042 0 +4
	StrCpy $0 00000412
	StrCpy $1 ko-KR
		Goto EndLNG
	StrCmp $0 2070 0 +4
	StrCpy $0 00000816
	StrCpy $1 pt-PT
		Goto EndLNG
	StrCmp $0 2052 0 +4
	StrCpy $0 00000804
	StrCpy $1 zh-CN
		Goto EndLNG
	StrCmp $0 1034 0 +4
	StrCpy $0 0000040a
	StrCpy $1 es-ES
		Goto +3
	StrCpy $0 00000404
	StrCpy $1 zh-TW
	EndLNG:
	Exch $1
	Exch
	Exch $0
FunctionEnd
 
${SegmentFile}
${Segment.OnInit}
	Push $0
	IfFileExists `${SETINI}` +2
	CreateDirectory `${SET}`
	${IsWOW64} $0
	StrCmp $0 0 0 +3
	WriteINIStr `${SETINI}` ${APPNAME}Settings Architecture 32
		Goto +2
	WriteINIStr `${SETINI}` ${APPNAME}Settings Architecture 64
	Pop $0
!macroend

!macro OS
	Push $0
	${If} ${IsNT}
		${IfNot} ${AtLeastWinVista}
			StrCpy $0 `Windows Vista or newer...`
			MessageBox MB_ICONSTOP|MB_TOPMOST `$(MINREQ)`
			Call Unload
			Quit
		${EndIf}
	${Else}
		StrCpy $0 `Windows Vista or newer...`
		MessageBox MB_ICONSTOP|MB_TOPMOST `$(MINREQ)`
		Call Unload
		Quit
	${EndIf}
	Pop $0
!macroend

!macro Lang
	Push $0
	${ReadUserConfig} $0 Language
	StrCmp $0 "" 0 GetLCID
	System::Call `${LCID}`
	GetLCID:
	${GetLCID} $0 $0
	${SetEnvironmentVariable} PortableApps.comLocaleID $0
	Pop $0
!macroend

!macro LangInit
	Push $0
	Push $1
	ReadEnvStr $0 PortableApps.comLocaleID
	${GetLNG} $0 $0 $1
	${SetEnvironmentVariable} PAL:LanguageCustom $0
	${SetEnvironmentVariable} LanguageCustom $1
	Pop $1
	Pop $0
!macroend

!macro Init
	IfFileExists `${DIR}\*.epub` +3
	CreateDirectory `${DIR}`
	CopyFiles /SILENT `${DEFDIR}\*.*` `${DIR}`
!macroend

!macro PreDirMove
	Push $0
	${ConfigRead} `$EXEDIR\${APPNAME}.ini` MyDocuments= $0
	${If} $0 == true
		${WriteRuntimeData} ${PAL} DOCUMENTS 1
		${ValidateFS} `$EXEDIR` $0
		${If} $0 = 1
			${ConfigRead} `$EXEDIR\${APPNAME}.ini` Junctions= $0
			${If} $0 == true
				${Registry::BackupKey} ${JUNC}
				${WriteRuntimeData} ${PAL} NTFS 1
				${Directory::BackupLocal} `$DOCUMENTS` `${MDE}`
				ExecDos::Exec /TOSTACK `"${J}" -accepteula -q "$DOCUMENTS\${MDE}" "${DIR}"`
				Pop $0
			${Else}
				${Directory::BackupLocal} `$DOCUMENTS` `${MDE}`
				${Directory::RestorePortable} `$DOCUMENTS` `${MDE}` `${DIR}`
			${EndIf}
		${Else}
			${Directory::BackupLocal} `$DOCUMENTS` `${MDE}`
			${Directory::RestorePortable} `$DOCUMENTS` `${MDE}` `${DIR}`
		${EndIf}
	${EndIf}
	Pop $0
!macroend

!macro PostDirMove
	Push $0
	${ReadRuntimeData} $0 ${PAL} DOCUMENTS
	${If} $0 = 1
		${ReadRuntimeData} $0 ${PAL} NTFS
		${If} $0 = 1
			ExecDos::Exec /TOSTACK `"${J}" -d "$DOCUMENTS\${MDE}"`
			Pop $0
			${Directory::RestoreLocal} `$DOCUMENTS` `${MDE}`
			${Registry::RestoreBackupKey} ${JUNC}
			${Registry::DeleteKeyEmpty} ${SYS} $0
		${Else}
			${Directory::BackupPortable} `$DOCUMENTS` `${MDE}` `${DIR}`
			${Directory::RestoreLocal} `$DOCUMENTS` `${MDE}`
		${EndIf}
	${EndIf}
	Pop $0
!macroend

${SegmentPrePrimary}
	Push $0
	Push $1
	${ReadUserConfig} $0 Language
	${If} $0 != ""
		System::Call `${LCID}`
		ReadEnvStr $1 PortableApps.comLocaleID
		${If} $0 != $1
			${Registry::BackupValue} `${INT}` Locale
			${Registry::BackupValue} `${INT}` LocaleName
			ReadEnvStr $0 PAL:LanguageCustom
			WriteRegStr HKCU `${CP}` Locale $0
			ReadEnvStr $0 LanguageCustom
			WriteRegStr HKCU `${CP}` LocaleName $0
			${WriteRuntimeData} ${PAL} Locale $0
		${EndIf}
	${EndIf}
	Pop $1
	Pop $0
!macroend

${SegmentPostPrimary}
	Push $0
	ClearErrors
	${ReadRuntimeData} $0 ${PAL} Locale
	${IfNot} ${Errors}
		${Registry::RestoreBackupValue} `${INT}` Locale
		${Registry::RestoreBackupValue} `${INT}` LocaleName
	${EndIf}
	Pop $0
!macroend