rem Batch Files Labyrinth
REM Classic 'Labyrinth' task
REM (c) HACSoft, 2005
REM Legend: 1 - wall, 0 - free way
REM Labyrinth itself:
REM 0000000000
REM 1111111110
REM 0000100100
REM 0100100100
REM 0100100000
REM 0100000100
REM 0000100110
REM 0000100100
REM 0110110000
REM 0010100000
ECHO off
TITLE Labyrinth
SETLOCAL enabledelayedexpansion
CLS
SET bi=2
SET bj=0
SET ei=5
SET ej=6
CALL :read
echo.
ECHO Please wait...
SET /a min=-%width%*%height%
CALL :find %bi% %bj% -1
CLS
SET /a min=-min-1
ECHO Length = %min%
CALL :write
GOTO :eof
::::::::::::::::::::::::::::::::::::::::::::::
:find i j len
:: Finding a free way:
CALL :get_e %1 %2
IF ERRORLEVEL %3  IF not %errorlevel%==0  EXIT /b
SET lab%1_%2=%3
IF %1==%ei%  IF %2==%ej%  SET min=%3
SET /a len=%3-1
IF %len% GTR %min%  ( 
SET /a nj=%2+1
CALL :get_e %1 !nj!
IF not ERRORLEVEL 1  CALL :find %1 !nj! %len%
SET /a nj=%2-1
CALL :get_e %1 !nj!
IF not ERRORLEVEL 1  CALL :find %1 !nj! %len%
SET /a ni=%1+1
CALL :get_e !ni! %2
IF not ERRORLEVEL 1  CALL :find !ni! %2 %len%
SET /a ni=%1-1
CALL :get_e !ni! %2
IF not ERRORLEVEL 1  CALL :find !ni! %2 %len%
)
EXIT /b
:get_e i j
:: Get the value of lab[i,j] cell:
IF %1 LSS 0  EXIT /b 1
IF %1 GTR %height%  EXIT /b 1
IF %2 LSS 0  EXIT /b 1
IF %2 GTR %width%  EXIT /b 1
EXIT /b !lab%1_%2!
:write
:: Showing labyrinth on console:
SET wall=**
FOR /l %%j in (0,1,%width%) do SET wall=!wall!***
ECHO %wall%
FOR /l %%i in (0,1,%height%) do ( 
SET s=
FOR /l %%j in (0,1,%width%) do ( 
SET a=!lab%%i_%%j!
IF %%i==%bi%  IF %%j==%bj%  (set a=[B]) 
IF %%i==%ei%  IF %%j==%ej%  (set a=[E]) 
IF !a!==[B]  (set s=!s![B])  else (
IF !a!==[E]  (set s=!s![E])  else (
IF !a!==1  ( 
SET s=!s!***
) else if !a! lss 0 (
SET /a a=-a-1
IF !a! LEQ 99  ( 
SET !a! a=
IF !a! LEQ 9  SET !a! a=
)
SET s=!s!!a!
) else set s=!s!...
))
)
ECHO *!s!*
)
ECHO %wall%
EXIT /b
:read
:: Getting labyringth from input.txt:
SET height=0
FOR /f %%s in (input.txt) do CALL :readline %%s
ECHO LABYRINTH (%height%x%j%):
SET /a height-=1
SET /a width=j-1
CALL :write
EXIT /b
:readline line
SET j=0
SET s=%1
:nextchar
IF not DEFINED s  GOTO nextline
SET lab%height%_%j%=%s:~0,1%
SET /a j+=1
SET s=%s:~1%
GOTO nextchar
:nextline
SET /a height+=1
EXIT /b
