/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithIndexActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getRepository(true, event) == null) {
            return null;
        }
        IPath[] locations = this.getSelectedLocations(event);
        if (locations.length == 1 && !locations[0].toFile().isDirectory()) {
            ITypedElement next;
            IPath baseLocation = locations[0];
            ITypedElement base = this.getBaseTypeElement(baseLocation);
            try {
                next = this.getIndexTypedElement(baseLocation);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            CompareUtils.openInCompare(workBenchPage, (CompareEditorInput)in);
        } else {
            try {
                CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                view.setInput(this.getSelectedResources(event), "%%%INDEX%%%");
            }
            catch (PartInitException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }

    private ITypedElement getBaseTypeElement(IPath baseLocation) {
        IFile file = ResourceUtil.getFileForLocation((IPath)baseLocation);
        if (file != null) {
            return SaveableCompareEditorInput.createFileElement((IFile)file);
        }
        return new LocalNonWorkspaceTypedElement(baseLocation);
    }

    private ITypedElement getIndexTypedElement(IPath location) throws IOException {
        IFile file = ResourceUtil.getFileForLocation((IPath)location);
        if (file != null) {
            return CompareUtils.getIndexTypedElement(file);
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IPath)location);
        if (mapping != null) {
            return CompareUtils.getIndexTypedElement(mapping.getRepository(), mapping.getRepoRelativePath(location));
        }
        return null;
    }
}

