/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.NonDeletedFilesTree;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutConflictDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private List<String> conflicts;
    private Repository repository;

    public CheckoutConflictDialog(Shell shell, Repository repository, List<String> conflicts) {
        super(shell, UIText.BranchResultDialog_CheckoutConflictsTitle, INFO, UIText.CheckoutConflictDialog_conflictMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.conflicts = conflicts;
    }

    protected Control createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        new NonDeletedFilesTree(main, this.repository, this.conflicts);
        CheckoutConflictDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 10: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.Commit", (IStructuredSelection)new StructuredSelection((Object)new RepositoryNode(null, this.repository)));
                break;
            }
            case 7: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.Reset", (IStructuredSelection)new StructuredSelection((Object)new RepositoryNode(null, this.repository)));
                break;
            }
            case 5: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.stash.create", (IStructuredSelection)new StructuredSelection((Object)new RepositoryNode(null, this.repository)));
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 7, UIText.BranchResultDialog_buttonReset, false);
        this.createButton(parent, 10, UIText.BranchResultDialog_buttonCommit, false);
        this.createButton(parent, 5, UIText.BranchResultDialog_buttonStash, false);
    }
}

