/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResetTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private static final int SWT_NONE = 0;
    private ResetCommand.ResetType resetType = ResetCommand.ResetType.MIXED;
    private Text anySha1;
    private String parsedCommitish;
    private Label subject;
    private Label author;
    private Label sha1;
    private Label committer;
    private final GitDateFormatter gitDateFormatter = new GitDateFormatter(GitDateFormatter.Format.LOCALE);

    public ResetTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 126);
        super.setHelpAvailable(false);
    }

    protected void createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)main);
        Group g2 = new Group(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)g2);
        g2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)g2, 0);
        label.setText(UIText.ResetTargetSelectionDialog_ExpressionLabel);
        this.anySha1 = new Text((Composite)g2, 2048);
        this.anySha1.setToolTipText(UIText.ResetTargetSelectionDialog_ExpressionTooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.anySha1);
        Group g3 = new Group((Composite)g2, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)g3);
        g3.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)g3, 0).setText(UIText.ResetTargetSelectionDialog_CommitLabel);
        this.sha1 = new Label((Composite)g3, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sha1);
        new Label((Composite)g3, 0).setText(UIText.ResetTargetSelectionDialog_SubjectLabel);
        this.subject = new Label((Composite)g3, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.subject);
        new Label((Composite)g3, 0).setText(UIText.ResetTargetSelectionDialog_AuthorLabel);
        this.author = new Label((Composite)g3, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.author);
        new Label((Composite)g3, 0).setText(UIText.ResetTargetSelectionDialog_CommitterLabel);
        this.committer = new Label((Composite)g3, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.committer);
        Group g = new Group(main, 0);
        g.setText(UIText.ResetTargetSelectionDialog_ResetTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)g);
        g.setLayout((Layout)new GridLayout(1, false));
        this.anySha1.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ResetTargetSelectionDialog.this.branchTree.setSelection(null);
            }
        });
        this.anySha1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ResetTargetSelectionDialog.this.anySha1.getText();
                if (text.length() == 0) {
                    ResetTargetSelectionDialog.this.parsedCommitish = null;
                    ResetTargetSelectionDialog.this.setMessage("");
                    return;
                }
                try {
                    ObjectId resolved = ResetTargetSelectionDialog.this.repo.resolve(String.valueOf(text) + "^{commit}");
                    if (resolved == null) {
                        ResetTargetSelectionDialog.this.setMessage(UIText.ResetTargetSelectionDialog_UnresolvableExpressionError, 3);
                        ResetTargetSelectionDialog.this.getButton(0).setEnabled(false);
                        ResetTargetSelectionDialog.this.parsedCommitish = null;
                        ResetTargetSelectionDialog.this.sha1.setText("");
                        ResetTargetSelectionDialog.this.subject.setText("");
                        ResetTargetSelectionDialog.this.author.setText("");
                        ResetTargetSelectionDialog.this.committer.setText("");
                        return;
                    }
                    ResetTargetSelectionDialog.this.setMessage("");
                    ResetTargetSelectionDialog.this.parsedCommitish = text;
                    ResetTargetSelectionDialog.this.getButton(0).setEnabled(true);
                    RevWalk rw = new RevWalk(ResetTargetSelectionDialog.this.repo);
                    RevCommit commit = rw.parseCommit((AnyObjectId)resolved);
                    ResetTargetSelectionDialog.this.sha1.setText(AbbreviatedObjectId.fromObjectId((AnyObjectId)commit).name());
                    ResetTargetSelectionDialog.this.subject.setText(commit.getShortMessage());
                    ResetTargetSelectionDialog.this.author.setText(String.valueOf(commit.getAuthorIdent().getName()) + " <" + commit.getAuthorIdent().getEmailAddress() + "> " + ResetTargetSelectionDialog.this.gitDateFormatter.formatDate(commit.getAuthorIdent()));
                    ResetTargetSelectionDialog.this.committer.setText(String.valueOf(commit.getCommitterIdent().getName()) + " <" + commit.getCommitterIdent().getEmailAddress() + "> " + ResetTargetSelectionDialog.this.gitDateFormatter.formatDate(commit.getCommitterIdent()));
                    rw.dispose();
                }
                catch (IOException e1) {
                    ResetTargetSelectionDialog.this.setMessage(e1.getMessage(), 3);
                    ResetTargetSelectionDialog.this.getButton(0).setEnabled(false);
                    ResetTargetSelectionDialog.this.parsedCommitish = null;
                }
            }
        });
        this.branchTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String refName;
                if (!event.getSelection().isEmpty() && (refName = ResetTargetSelectionDialog.this.refNameFromDialog()) != null) {
                    ResetTargetSelectionDialog.this.anySha1.setText(refName);
                    ResetTargetSelectionDialog.this.anySha1.selectAll();
                }
            }
        });
        Button soft = new Button((Composite)g, 16);
        soft.setText(UIText.ResetTargetSelectionDialog_ResetTypeSoftButton);
        soft.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.SOFT;
                }
            }
        });
        Button medium = new Button((Composite)g, 16);
        medium.setSelection(true);
        medium.setText(UIText.ResetTargetSelectionDialog_ResetTypeMixedButton);
        medium.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.MIXED;
                }
            }
        });
        Button hard = new Button((Composite)g, 16);
        hard.setText(UIText.ResetTargetSelectionDialog_ResetTypeHardButton);
        hard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    ResetTargetSelectionDialog.this.resetType = ResetCommand.ResetType.HARD;
                }
            }
        });
    }

    protected void refNameSelected(String refName) {
        boolean enabled = refName != null || this.parsedCommitish != null;
        this.getButton(0).setEnabled(enabled);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.ResetTargetSelectionDialog_ResetButton);
    }

    protected String getTitle() {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repo);
        return NLS.bind((String)UIText.ResetTargetSelectionDialog_ResetTitle, (Object)repoName);
    }

    protected String getWindowTitle() {
        return UIText.ResetTargetSelectionDialog_WindowTitle;
    }

    public ResetCommand.ResetType getResetType() {
        return this.resetType;
    }

    protected void okPressed() {
        if (this.resetType == ResetCommand.ResetType.HARD && !MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.ResetTargetSelectionDialog_ResetQuestion, (String)UIText.ResetTargetSelectionDialog_ResetConfirmQuestion)) {
            return;
        }
        super.okPressed();
    }

    protected String getMessageText() {
        return UIText.ResetTargetSelectionDialog_SelectBranchForResetMessage;
    }

    public String getRefName() {
        String selected = super.getRefName();
        if (selected != null) {
            return selected;
        }
        return this.parsedCommitish;
    }
}

