/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.egit.ui.internal.push.SimplePushRefWizard;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        Wizard pushWiz = null;
        try {
            switch (node.getType()) {
                case REF: {
                    pushWiz = new SimplePushRefWizard(node.getRepository(), (Ref)node.getObject(), UIText.PushCommand_pushBranchTitle);
                    break;
                }
                case TAG: {
                    pushWiz = new SimplePushRefWizard(node.getRepository(), (Ref)node.getObject(), UIText.PushCommand_pushTagTitle);
                    break;
                }
                case REPO: {
                    pushWiz = new PushWizard(node.getRepository());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("type not supported!");
                }
            }
        }
        catch (URISyntaxException e1) {
            Activator.handleError(e1.getMessage(), e1, true);
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)pushWiz);
        dlg.setHelpAvailable(true);
        dlg.open();
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.enableWhenRepositoryHaveHead(evaluationContext);
    }
}

