/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.StashDropOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashDropCommand
extends RepositoriesViewCommandHandler<StashedCommitNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        StashedCommitNode node = (StashedCommitNode)nodes.get(0);
        Repository repo = node.getRepository();
        if (repo == null) {
            return null;
        }
        final int index = node.getIndex();
        if (index < 0) {
            return null;
        }
        final RevCommit commit = (RevCommit)node.getObject();
        if (commit == null) {
            return null;
        }
        final AtomicBoolean confirmed = new AtomicBoolean();
        final Shell shell = this.getActiveShell(event);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                confirmed.set(MessageDialog.openConfirm((Shell)shell, (String)UIText.StashDropCommand_confirmTitle, (String)MessageFormat.format(UIText.StashDropCommand_confirmMessage, Integer.toString(index))));
            }
        });
        if (!confirmed.get()) {
            return null;
        }
        final StashDropOperation op = new StashDropOperation(repo, index);
        Job job = new Job(MessageFormat.format(UIText.StashDropCommand_jobTitle, commit.name())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    Activator.logError(MessageFormat.format(UIText.StashDropCommand_dropFailed, commit.name()), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }
}

