/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitSynchronizeWizardPage
extends WizardPage {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private boolean forceFetch;
    private boolean shouldIncludeLocal = false;
    private TreeViewer treeViewer;
    private final Map<Repository, Set<IProject>> resources = new HashMap<Repository, Set<IProject>>();
    private final Map<Repository, String> selectedBranches = new HashMap<Repository, String>();
    private final Image branchImage = UIIcons.BRANCH.createImage();
    private final Image repositoryImage = UIIcons.REPOSITORY.createImage();

    GitSynchronizeWizardPage() {
        super(GitSynchronizeWizardPage.class.getName());
        this.setTitle(UIText.GitBranchSynchronizeWizardPage_title);
        this.setMessage(UIText.GitBranchSynchronizeWizardPage_description, 2);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        IProject[] iProjectArray = ROOT.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping != null) {
                Repository repo = repositoryMapping.getRepository();
                Set<IProject> projects = this.resources.get(repo);
                if (projects == null) {
                    projects = new HashSet<IProject>();
                    this.resources.put(repo, projects);
                }
                projects.add(project);
            }
            ++n2;
        }
        this.treeViewer = new TreeViewer(composite, 68352);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewerColumn projectsColumn = new TreeViewerColumn(this.treeViewer, 16384);
        projectsColumn.getColumn().setText(UIText.GitBranchSynchronizeWizardPage_repositories);
        projectsColumn.getColumn().setImage(this.repositoryImage);
        projectsColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof Repository) {
                    Repository repo = (Repository)element;
                    String descr = "";
                    try {
                        descr = String.valueOf(descr) + " [" + repo.getBranch() + "]";
                    }
                    catch (IOException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    Color decorationsColor = JFaceResources.getColorRegistry().get("DECORATIONS_COLOR");
                    String repoName = repo.getWorkTree().getName();
                    int repoNameLen = repoName.length();
                    StyleRange styleRange = new StyleRange(repoNameLen, repoNameLen + descr.length(), decorationsColor, null);
                    cell.setImage(GitSynchronizeWizardPage.this.repositoryImage);
                    cell.setText(String.valueOf(repoName) + descr);
                    cell.setStyleRanges(new StyleRange[]{styleRange});
                }
                super.update(cell);
            }
        });
        TreeViewerColumn dstColumn = new TreeViewerColumn(this.treeViewer, 16384);
        dstColumn.getColumn().setText(UIText.GitBranchSynchronizeWizardPage_destination);
        dstColumn.getColumn().setImage(this.branchImage);
        dstColumn.getColumn().setWidth(200);
        final ComboBoxCellEditor branchesEditor = new ComboBoxCellEditor((Composite)this.treeViewer.getTree(), new String[0]);
        branchesEditor.setActivationStyle(3);
        ((CCombo)branchesEditor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CCombo combo = (CCombo)e.widget;
                TreeSelection sel = (TreeSelection)GitSynchronizeWizardPage.this.treeViewer.getSelection();
                int selectedIdx = combo.getSelectionIndex();
                Repository repo = (Repository)sel.getFirstElement();
                if (selectedIdx != -1) {
                    GitSynchronizeWizardPage.this.selectedBranches.put(repo, combo.getItem(selectedIdx));
                    GitSynchronizeWizardPage.this.setPageComplete(true);
                } else {
                    GitSynchronizeWizardPage.this.selectedBranches.put(repo, null);
                    GitSynchronizeWizardPage.this.setPageComplete(false);
                }
            }
        });
        dstColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                int intValue = (Integer)value;
                if (intValue == -1) {
                    return;
                }
                CCombo combo = (CCombo)branchesEditor.getControl();
                String branch = combo.getItem(intValue);
                GitSynchronizeWizardPage.this.selectedBranches.put((Repository)element, branch);
                GitSynchronizeWizardPage.this.treeViewer.refresh(element, true);
                GitSynchronizeWizardPage.this.validatePage();
            }

            protected Object getValue(Object element) {
                String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(element);
                CCombo combo = (CCombo)branchesEditor.getControl();
                int index = branch == null ? 0 : combo.indexOf(branch);
                return index;
            }

            protected CellEditor getCellEditor(Object element) {
                List additionalRefs;
                Repository repo = (Repository)element;
                LinkedList refs = new LinkedList(repo.getAllRefs().keySet());
                try {
                    additionalRefs = repo.getRefDatabase().getAdditionalRefs();
                }
                catch (IOException iOException) {
                    additionalRefs = null;
                }
                if (additionalRefs != null) {
                    for (Ref ref : additionalRefs) {
                        refs.add(ref.getName());
                    }
                }
                Collections.sort(refs, CommonUtils.STRING_ASCENDING_COMPARATOR);
                branchesEditor.setItems(refs.toArray(new String[refs.size()]));
                return branchesEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        dstColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(element);
                return branch == null ? "" : branch;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        ArrayList<Repository> repositoriesList = new ArrayList<Repository>(this.resources.keySet());
        Collections.sort(repositoriesList, new Comparator<Repository>(){

            @Override
            public int compare(Repository o1, Repository o2) {
                String name1 = o1.getWorkTree().getName();
                String name2 = o2.getWorkTree().getName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        this.treeViewer.setInput((Object)repositoriesList.toArray(new Repository[repositoriesList.size()]));
        projectsColumn.getColumn().pack();
        Composite buttonsComposite = new Composite(composite, 0);
        layout = new GridLayout(4, false);
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        final Button fetchChanges = new Button(buttonsComposite, 32);
        fetchChanges.setText(UIText.GitBranchSynchronizeWizardPage_fetchChangesFromRemote);
        fetchChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitSynchronizeWizardPage.this.forceFetch = fetchChanges.getSelection();
            }
        });
        fetchChanges.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        fetchChanges.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch"));
        final Button includeLocal = new Button(buttonsComposite, 32);
        includeLocal.setText(UIText.GitBranchSynchronizeWizardPage_includeUncommitedChanges);
        includeLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitSynchronizeWizardPage.this.shouldIncludeLocal = includeLocal.getSelection();
            }
        });
        includeLocal.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public void dispose() {
        if (this.branchImage != null) {
            this.branchImage.dispose();
        }
        if (this.repositoryImage != null) {
            this.repositoryImage.dispose();
        }
        super.dispose();
    }

    private void validatePage() {
        this.setPageComplete(!this.selectedBranches.isEmpty());
    }

    Map<Repository, String> getSelectedBranches() {
        return this.selectedBranches;
    }

    Set<IProject> getSelectedProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (Repository repo : this.selectedBranches.keySet()) {
            projects.addAll((Collection<IProject>)this.resources.get(repo));
        }
        return projects;
    }

    boolean shouldIncludeLocal() {
        return this.shouldIncludeLocal;
    }

    boolean forceFetch() {
        return this.forceFetch;
    }
}

